#ifndef OPERATION_CHECK_H
#define OPERATION_CHECK_H

/* **Include** */
#include "mbed.h"
#include "comm.h"
#include "mode.h"
#include "interface_manager.h"
#include "parameter_manager.h"
#include "status_manager.h"
#include "typedef.h"
#include "packet_split.h"
#include "kicker.h"
#include "wheel.h"
#include "dribbler.h"


/* **Define** */

/* **グルーバル関数** */

/* **クラス** */

class OperationCheck{
  public:
  OperationCheck();
  void selectCheckMode(void);
  void viewSelect(void);
  void checkBack(void);
  void run(void);
  
  void checkWheel(void);
  void checkDribble(void);
  void checkStrKick(void);
  void checkChpKick(void);
  
  void resetValue(void);
  
  private:
  Kicker kicker;
  Wheel wheel;
  Dribbler dribble;
  enum CheckMode{SELECT,WHEEL,DRIBBLE,STR_KICK,CHIP_KICK};
  CheckMode checkMode;
  signed char button_count;
  char sideSW_num;
  char charge_flag;
  char kick_flag;
  signed char power;
  char ball;
  signed char vel_value;
  signed short vel_angle;
  
  void createLcdData(void);
  char str[30];
  int counter;
    
};

#endif