

#include "mbed.h"
#include "comm.h"
#include "parameter_manager.h"
#include "packet_split.h"
#include "filter.h"

/* **mbedクラス** */
#ifdef LPC4088

#elif  STM32

#endif

/* **Define** */
#define DISABLE 0
#define ENABLE  1
#define KICK_TYPE_STRAIGHT  0
#define KICK_TYPE_CHIP      1
/* **ローカル関数定義** */

/* **ローカル関数** */

/* **グルーバル関数** */

/* **クラス** */
class InterfaceManager;
LPF vel_value_lpf(0.97);
LPF vel_angle_lpf(0.97);
LPF v_omega_lpf(0.97);

//メンバ変数の初期化は、定義順（Ｗａｒｎｉｎｇになる）
PacketSplit::PacketSplit()
:exc_v_mm_per_sec(0.0),
 exc_v_mrad_per_sec(0.0),
 exc_v_angle_value(0.0)
{    
}
 
void PacketSplit::splitPacket(void)
{
    initStructureRawData();
    //XBeeデータ取得
    receiver.receivePacketData();
    substituteData();

}

void PacketSplit::initStructureRawData(void)
{
    ParameterManager::raw_data.vphasor_value_of_machine = 0;
    ParameterManager::raw_data.vphasor_angle_of_machine = 0;
    ParameterManager::raw_data.vw_of_machine = 0;
    ParameterManager::raw_data.actions_of_machine = 0;
    ParameterManager::raw_data.power = 0;
}

void PacketSplit::substituteData(void)
{
    initStructurePartial();

    splitCommand();
    splitPower();

    ParameterManager::machine_data.machine_id = ParameterManager::raw_data.machine_id;

#ifndef EXCHANGE_REQUEST
    ParameterManager::machine_data.v_mm_per_sec = (short)ParameterManager::raw_data.vphasor_value_of_machine * 10; //MAX:4m/s
    ParameterManager::machine_data.angle_degree = (short)ParameterManager::raw_data.vphasor_angle_of_machine * 2;  //2°刻み
    ParameterManager::machine_data.vw_mrad_per_sec = (short)(ParameterManager::raw_data.vw_of_machine - 127) * 12; //127を0とおく
#endif

#ifdef EXCHANGE_REQUEST
    exc_v_mm_per_sec   = (double)ParameterManager::raw_data.vphasor_value_of_machine * 15.6686; 
    exc_v_mrad_per_sec = (double)(ParameterManager::raw_data.vw_of_machine - 127) * 49.087; 
    exc_v_angle_value  = (double)ParameterManager::raw_data.vphasor_angle_of_machine * 2.0;
    
    //exc_v_mm_per_sec   = vel_value_lpf.getLPF_Out(exc_v_mm_per_sec);
    //exc_v_angle_value  = vel_angle_lpf.getLPF_Out(exc_v_angle_value);
    //exc_v_mrad_per_sec = v_omega_lpf.getLPF_Out(exc_v_mrad_per_sec);
//    ParameterManager::machine_data.v_mm_per_sec = (short)exc_v_mm_per_sec; //MAX:4m/s
//    ParameterManager::machine_data.angle_degree = (short)ParameterManager::raw_data.vphasor_angle_of_machine * 2;  //2°刻み
//    ParameterManager::machine_data.vw_mrad_per_sec = (short)exc_v_mrad_per_sec; //127を0とおく
    ParameterManager::machine_data.v_mm_per_sec = (short)exc_v_mm_per_sec; //MAX:4m/s
    ParameterManager::machine_data.angle_degree = (short)exc_v_angle_value;  //2°刻み
    ParameterManager::machine_data.vw_mrad_per_sec = (short)exc_v_mrad_per_sec; //127を0とおく

#endif


    ParameterManager::machine_data.dribble_flag = ParameterManager::command_partial.dribble_flag;
    ParameterManager::machine_data.kick_flag = ParameterManager::command_partial.kick_flag;
    ParameterManager::machine_data.kick_type = ParameterManager::command_partial.kick_type;
    ParameterManager::machine_data.charge_flag = ParameterManager::command_partial.charge_flag;

    ParameterManager::machine_data.kickers_power = ParameterManager::power_partial.kickrs_power;
    ParameterManager::machine_data.dribbler_power = ParameterManager::power_partial.dribbler_power;
}

void PacketSplit::initStructurePartial(void)
{
    ParameterManager::command_partial.charge_flag = 0;
    ParameterManager::command_partial.dribble_flag = 0;
    ParameterManager::command_partial.kick_flag = 0;
    ParameterManager::command_partial.kick_type = 0;

    ParameterManager::power_partial.dribbler_power = 0;
    ParameterManager::power_partial.kickrs_power = 0;
}

void PacketSplit::splitCommand(void)
{
    /*
     * bit7 : ドリブルフラグ
     *         0: ドリブルOFF   1: ドリブルON
     * bit6-5: 無し
     *
     * bit4 : キックフラグ
     *         0: キックOFF 1: キックON
     * bit3 : キックの種類
     *         0:ストレート 1: チップ
     * bit2 : なし
     *
     * bit1 : 充電スイッチ
     *         0:充電しない 1:充電する
     * bit0 : エラーチェックビット
     *         0:エラー 1:正常
     */

    /* ドリブル関連 */
    if(ParameterManager::raw_data.actions_of_machine & 0x80){
        ParameterManager::command_partial.dribble_flag = ENABLE;
    }else{
        ParameterManager::command_partial.dribble_flag = DISABLE;
    }

    /* キック関連 */
    if(ParameterManager::raw_data.actions_of_machine & 0x10){
        ParameterManager::command_partial.kick_flag = ENABLE;
    }else{
        ParameterManager::command_partial.kick_flag = DISABLE;
    }

    if(ParameterManager::raw_data.actions_of_machine & 0x08){
        ParameterManager::command_partial.kick_type = KICK_TYPE_CHIP;
    }else{
        ParameterManager::command_partial.kick_type = KICK_TYPE_STRAIGHT;
    }

    /* 充電関連 */
    if(ParameterManager::raw_data.actions_of_machine & 0x02){
        ParameterManager::command_partial.charge_flag = ENABLE;
    }else{
        ParameterManager::command_partial.charge_flag = DISABLE;
    }

}

void PacketSplit::splitPower(void)
{
    ParameterManager::power_partial.kickrs_power = ParameterManager::raw_data.power & 0x0F;
    ParameterManager::power_partial.dribbler_power = ParameterManager::raw_data.power >> 4;
    ParameterManager::power_partial.dribbler_power &= 0x0F;

}

