#include "mbed.h"
#include "mode.h"
#include "interface_manager.h"
#include "status_manager.h"
#include "parameter_manager.h"
#include "fail_safe.h"
#include "filter.h"
#include "pid.h"

//2019年JapanOpenソフト

Timer t;
LPF DribMot_Current(0.8);
PID DribMot_PID(1.0,0.1,0.0,40.0,0.0);

int main() {
    init_interface();
    init_status();
    
    ParameterManager::machine_id = 3;
    
    ActMode actmode;
    ParameterManager::raw_data.machine_id = ParameterManager::machine_id;
    ParameterManager::raw_data.vphasor_value_of_machine = 0;
    ParameterManager::raw_data.vphasor_angle_of_machine = 0;
    ParameterManager::raw_data.vw_of_machine = 127;
    ParameterManager::raw_data.actions_of_machine = 0;
    ParameterManager::raw_data.power = 0;

    ParameterManager::machine_data.v_mm_per_sec = 0; //MAX:4m/s
    ParameterManager::machine_data.angle_degree = 0;
    ParameterManager::machine_data.vw_mrad_per_sec = 0; 
#ifndef ON_INDICATER
    InterfaceManager::i2c.readIDMsg();
#endif    
    
    while(1) {
        if(StatusManager::ball == 1)
        {
            InterfaceManager::LED  =  1;
        }
        else
        {
            InterfaceManager::LED  =  0;
        }
        
        actmode.run();
#if defined(MAIN_BORD_Ver_4) || defined(MAIN_BORD_Ver_5)
        //StatusManager::motTrqData.MotTrq_short = (short)DribMot_Current.getLPF_Out( (double)InterfaceManager::batVoltage.read_u16()); //*(float)3.3 * 1000) ; //[mNm]          
        StatusManager::dribbleMotor_current = (float)DribMot_Current.getLPF_Out( ((double)InterfaceManager::dribbleMotor_current.read() - (double)0.4841) * (double)3.3 * (double)9.091 );
        //StatusManager::dribbleMotor_current = DribMot_Current.getLPF_Out( InterfaceManager::dribbleMotor_current.read());
        
        StatusManager::req_dribbleMotor_PID = DribMot_PID.getPID_Out( StatusManager::req_dribbleMotor_current , StatusManager::dribbleMotor_current);
        // 指示０の時Duty出力を０にする　０.１Aは最低指示0.133以下であれば良い
        if(StatusManager::req_dribbleMotor_current < (float)0.1)
        {
            StatusManager::req_dribbleMotor_PID = 0.0;
        }
        
        if( StatusManager::dribbleMotor_current > (float)JDG_TH_OVERCUR_DIRBMOT )
        {
            StatusManager::dribbleMot_OvrCur = 1;
            InterfaceManager::dribbleMotor.write((float)1.0 );
        }
        else
        {
           StatusManager::dribbleMot_OvrCur = 0;
           InterfaceManager::dribbleMotor.write((float)1.0 - StatusManager::req_dribbleMotor_PID  * (float)0.01 );
        }
#endif

        
    }
}
