#ifndef INTERFACE_MANAGER_H
#define INTERFACE_MANAGER_H

#include "mbed.h"
#include "typedef.h"
#include "button_roots.h"
#include "i2c_roots.h"
#include "can_roots.h"
#include "xbee_roots.h"

#include "string.h"
#include "stdio.h"

//Main基板ver管理
//#define MAIN_BORD_Ver_3  //赤
//#define MAIN_BORD_Ver_4    //青
#define MAIN_BORD_Ver_5  //白

//Option
//#define ON_INDICATER

class InterfaceManager{
    public:
    static Button_Roots button;
    static I2C_Roots i2c;
    static CAN_Roots can;
    static Xbee_Roots xbee;
    static DigitalOut chip_kick;
    static DigitalOut straight_kick;
    static DigitalOut charge_request;
    static DigitalIn  ball_sensor;
    static DigitalIn  charge_completed;
    static DigitalOut LED;
    static DigitalIn  dribbleIC_fault;
    static DigitalOut dribbleStandBy;
    static PwmOut dribbleMotor;
    static AnalogIn batVoltage;
    static AnalogIn dribbleMotor_current;
//    static DigitalIn  modeSW_1;
//    static DigitalIn  modeSW_2;
    
    private:
    InterfaceManager();
    
    
    
};

/* **グローバル関数** */
extern void init_interface(void);

#endif