#include "mbed.h"
#include "interface_manager.h"

Button_Roots InterfaceManager::button;
I2C_Roots InterfaceManager::i2c;
CAN_Roots InterfaceManager::can;
Xbee_Roots InterfaceManager::xbee;

#if defined(MAIN_BORD_Ver_4)

DigitalOut InterfaceManager::straight_kick(D3);
DigitalOut InterfaceManager::chip_kick(D6);
DigitalOut InterfaceManager::charge_request(D1);
DigitalOut InterfaceManager::LED(D11);
//DigitalOut InterfaceManager::dribbleStandBy(A5);
    
DigitalIn InterfaceManager::ball_sensor(A4);
DigitalIn InterfaceManager::charge_completed(D0);//D0
DigitalIn InterfaceManager::dribbleIC_fault(A6);
    
PwmOut InterfaceManager::dribbleMotor(A5);
AnalogIn InterfaceManager::dribbleMotor_current(A7);

#elif defined(MAIN_BORD_Ver_5)
DigitalOut InterfaceManager::straight_kick(D3);
DigitalOut InterfaceManager::chip_kick(D6);
DigitalOut InterfaceManager::charge_request(D0);
DigitalOut InterfaceManager::LED(D11);
//DigitalOut InterfaceManager::dribbleStandBy(A5);
    
DigitalIn InterfaceManager::ball_sensor(A4);
DigitalIn InterfaceManager::charge_completed(D1);//D0
DigitalIn InterfaceManager::dribbleIC_fault(A7);
    
PwmOut InterfaceManager::dribbleMotor(A5);
AnalogIn InterfaceManager::dribbleMotor_current(A6);

#elif defined(MAIN_BORD_Ver_3)
DigitalOut InterfaceManager::straight_kick(D3);
DigitalOut InterfaceManager::chip_kick(D6);
DigitalOut InterfaceManager::charge_request(D1);
DigitalOut InterfaceManager::LED(D9);
DigitalOut InterfaceManager::dribbleStandBy(A5);

DigitalIn InterfaceManager::ball_sensor(A7);
DigitalIn InterfaceManager::charge_completed(D0);//D0
DigitalIn InterfaceManager::dribbleIC_fault(A4);

PwmOut InterfaceManager::dribbleMotor(A6);
//DigitalIn InterfaceManager::modeSW_1(A3);
//DigitalIn InterfaceManager::modeSW_2(A2);
#endif

AnalogIn InterfaceManager::batVoltage(A0);


void init_interface(void)
{
    //入力PINの設定
    InterfaceManager::ball_sensor.mode(PullUp);
    InterfaceManager::charge_completed.mode(PullUp);
    InterfaceManager::dribbleIC_fault.mode(PullNone);
//    InterfaceManager::modeSW_1.mode(PullNone);
//    InterfaceManager::modeSW_2.mode(PullNone);
    InterfaceManager::straight_kick     = 0;
    InterfaceManager::chip_kick         = 0;
    InterfaceManager::charge_request    = 0;
    //InterfaceManager::dribbleStandBy    = 0;
    
    InterfaceManager::dribbleMotor.period_us(50);
#if defined(MAIN_BORD_Ver_4) || defined(MAIN_BORD_Ver_5)    
    InterfaceManager::dribbleMotor.write(1.0);  //0.0~1.0
#else
    InterfaceManager::dribbleMotor.write(0.0);  //0.0~1.0
#endif    
    //割り込み優先度決定※Ｔｉｍｅｒの優先度は低めに
    NVIC_SetPriority(TIM2_IRQn,5);
    NVIC_SetPriority(TIM1_BRK_TIM15_IRQn,10);
    NVIC_SetPriority(TIM1_UP_TIM16_IRQn,10);
    NVIC_SetPriority(TIM1_TRG_COM_TIM17_IRQn,10);
    NVIC_SetPriority(TIM1_CC_IRQn,10);
    NVIC_SetPriority(TIM3_IRQn,5);
    
    NVIC_SetPriority(I2C1_EV_IRQn,1);
    NVIC_SetPriority(CAN_TX_IRQn,1);
    NVIC_SetPriority(CAN_RX0_IRQn,1);
    NVIC_SetPriority(CAN_RX1_IRQn,1);
    NVIC_SetPriority(USART1_IRQn , 0);
    NVIC_SetPriority(USART2_IRQn , 0);
    NVIC_SetPriority(USART3_IRQn , 0);
    initButton();
    initI2C();
    initCAN();
    initXbee();
    

    
}