#ifndef I2C_ROOTS_H
#define I2C_ROOTS_H

/* **Include** */
#include "mbed.h"
#include "comm.h"
#include "interface_manager.h"
#include "stdbool.h"
#include "stdarg.h"
#include "xprintf.h"

/* **Define** */
#define ADDRESS_LCD 0x7C
#define ADDRESS_INDICATE 0xC0
#define ADDRESS_EEPROM   0xA0
#define I2C_SEND_CYCLE_TIME 0.5

/* **グルーバル関数** */
extern void initI2C(void);
extern void printfLCD(const char* fmt, ...);

/* **クラス** */
class InterfaceManager;

class I2C_Roots{
  public:
  I2C_Roots();
  void setLCDMsg(char* msg,char msg_num);
  void setIndicateMsg(char* msg,char msg_num);
  void setIDMsg(char* msg,char msg_num);
  void readIDMsg(void);
  //char getLCDMsg(void);
  
  char LCDMsg[30];
  char IndicateMsg[30];
  char IDMsg[10];
  private:  
  
  
    
};

#endif