
#include "mbed.h"
#include "comm.h"
#include "interface_manager.h"
#include "status_manager.h"
#include "parameter_manager.h"
#include "i2c_roots.h"

/* **mbedクラス** */
#ifdef LPC4088

#elif  STM32
I2C i2cMBED(PB_7, PB_6); // sda, scl
#endif

Ticker i2c_Timer;

/* **ローカル関数定義** */
static void initLCD(void);

static void sendCommand(unsigned char command);
static void sendCharacter(unsigned char a);
static void clearDisp(void);
static void moveCursor(unsigned char address);
static void initialiseCursorPosition(void);
//static char str[30];
//static char change_scleen;
/* **ローカル変数** */
 


/* **ローカル関数** */
void i2c_send(void)
{
    //500msec周期で送信
    //送信記述はここに書く
//    if(change_scleen != 1) 
//    {
//        change_scleen = 1;
//        sprintf(str,"V:%d\nA:%d",ParameterManager::machine_data.v_mm_per_sec,ParameterManager::machine_data.angle_degree);
//    }
//    else
//    {
//        change_scleen = 0;
//        sprintf(str,"O:%d",ParameterManager::machine_data.vw_mrad_per_sec);
//        
//    }   
//    
//    InterfaceManager::i2c.setLCDMsg(str,sizeof(str)); 
    printfLCD(InterfaceManager::i2c.LCDMsg);    
    
    
    
}

static void initLCD(void)
{
    xdev_out(sendCharacter);

    sendCommand(0x38);
    sendCommand(0x39);
    sendCommand(0x14);
    sendCommand(0x70);
    sendCommand(0x56);
    sendCommand(0x6C);
    wait_ms(200);
    sendCommand(0x38);
    sendCommand(0x0C);
    sendCommand(0x01);
    wait_ms(2);

    initialiseCursorPosition();    
}
extern void printfLCD(const char* fmt, ...)
{
    va_list arp;

    clearDisp();

    va_start(arp, fmt);
    xvprintf(fmt,arp);
    va_end(arp);

    initialiseCursorPosition();
}

static void sendCommand(unsigned char command)
{
    char data[2];
    data[0]= 0x80;
    data[1]= command;
    i2cMBED.write(ADDRESS_LCD, data, 2);
    wait_us(27);
}

static void sendCharacter(unsigned char a)
{
    if(a == '\n') { //改行コードのときは改行する
        moveCursor(0x40);
        return;
    }
    char data[2];
    data[0]= 0xC0;
    data[1]= a;
    i2cMBED.write(ADDRESS_LCD, data, 2);
    wait_us(27);
}

static void initialiseCursorPosition(void)
{
    /* 通信終了時にカーソルを頭に戻す */
    char data[2];
    data[0]= 0x00;
    data[1]= 0x80;
    i2cMBED.write(ADDRESS_LCD, data, 2);

}


static void clearDisp(void)
{
    sendCommand(0x01);
    wait_ms(1);
}


static void moveCursor(unsigned char address)
{
    sendCommand(0x80 | address);
}


/* **グルーバル関数** */
extern void initI2C(void)
{
//#ifndef ON_INDICATER
    i2cMBED.frequency(400000); 
//#else
//    i2cMBED.frequency(100000);   
//#endif
    initLCD();
    i2c_Timer.attach(i2c_send, I2C_SEND_CYCLE_TIME);    
}

/* **クラス** */
I2C_Roots::I2C_Roots()
{
    
        
}

void I2C_Roots::setLCDMsg(char* msg,char msg_num)
{
    for(char i = 0; i <= msg_num ; i++)
    {
        LCDMsg[i] = *(msg + i);   
    }
 
    
}

void I2C_Roots::setIndicateMsg(char* msg,char msg_num)
{
    for(char i = 0; i <= msg_num ; i++)
    {
        IndicateMsg[i] = *(msg + i);   
    }
 
    StatusManager::indicate_i2c_enable = i2cMBED.write(ADDRESS_INDICATE, IndicateMsg, msg_num);
}

void I2C_Roots::setIDMsg(char* msg,char msg_num)
{
    for(char i = 0; i <= msg_num ; i++)
    {
        IDMsg[i] = *(msg + i);   
    }
    i2cMBED.write(ADDRESS_EEPROM, IDMsg, msg_num);
}

void I2C_Roots::readIDMsg(void)
{
    char msg_num = 2;
    for(char i = 0; i <= msg_num ; i++)
    {
        IDMsg[i] = 0;   
    }
    msg_num = 2;
    i2cMBED.write(ADDRESS_EEPROM, IDMsg, msg_num, 1);
    
    msg_num = 1;
    i2cMBED.read(ADDRESS_EEPROM, IDMsg, msg_num, 1);
    ParameterManager::machine_id = IDMsg[0];
    
    if(ParameterManager::machine_id > MAX_ID)
    {
        ParameterManager::machine_id = MIN_ID;     
    }
    
}