
#include "mbed.h"
#include "comm.h"
#include "interface_manager.h"
#include "can_roots.h"

/* **mbedクラス** */
#ifdef LPC4088

#elif  STM32
CAN canMBED(PA_11, PA_12); // sda, scl
#endif

Ticker can_Timer;
char data[4];
CANMessage msg(0x410, &data[0] , 4 );

//変数定義


//変数宣言

static char send_data[7] = {0};

/* **ローカル関数定義** */



/* **ローカル関数** */
void can_send(void)
{
    //4msec周期で送信
    //送信記述はここに書く

    canMBED.write(CANMessage(MOT_ORDER_ID,InterfaceManager::can.send_motvel_data,8));   

//    send_data[1] = StatusManager::motTrqData.MotTrq_char.L;
//    send_data[0] = StatusManager::motTrqData.MotTrq_char.H;
//    send_data[2] = 0;
//    send_data[3] = 0;
//    send_data[4] = 0;
//    send_data[5] = 0;
//    send_data[6] = 0;
//    send_data[7] = 0;
//    
//    canMBED.write(CANMessage(MOTOR_TORQUE_MSG,send_data,7));
//    
    
}

void onMsgReceived() 
{
    canMBED.read(msg);
    if(msg.id == 0x102)
    {
        InterfaceManager::can.recive_motvel_data[0] = msg.data[0];
        InterfaceManager::can.recive_motvel_data[1] = msg.data[1];
        InterfaceManager::can.recive_motvel_data[2] = msg.data[2];
        InterfaceManager::can.recive_motvel_data[3] = msg.data[3];
    }
    
}


/* **グルーバル関数** */
extern void initCAN(void)
{
    canMBED.frequency(1000000);   
    canMBED.mode(CAN::Normal);
    canMBED.attach(&onMsgReceived);
    can_Timer.attach(can_send, CAN_SEND_CYCLE_TIME);    
}

/* **クラス** */
CAN_Roots::CAN_Roots()
{
    
        
}

char CAN_Roots::setMotVel(OrderMotVel& order)
{
    //TODU:データを上書きしたか判定処理を入れたい
    send_motvel_data[0] = (char)order.Mot0Order.Vel_char.L;
    send_motvel_data[1] = (char)order.Mot0Order.Vel_char.H;
    send_motvel_data[2] = (char)order.Mot1Order.Vel_char.L;
    send_motvel_data[3] = (char)order.Mot1Order.Vel_char.H;
    send_motvel_data[4] = (char)order.Mot2Order.Vel_char.L;
    send_motvel_data[5] = (char)order.Mot2Order.Vel_char.H;
    send_motvel_data[6] = (char)order.Mot0Order.Vel_char.L;
    send_motvel_data[7] = (char)order.Mot0Order.Vel_char.H;

//    send_motvel_data[0] = 1;
//    send_motvel_data[1] = 2;
//    send_motvel_data[2] = 3;
//    send_motvel_data[3] = 4;
//    send_motvel_data[4] = 5;
//    send_motvel_data[5] = 6;
//    send_motvel_data[6] = 7;
//    send_motvel_data[7] = 8;

    return 0;   
}



