
#include "mbed.h"
#include "comm.h"
#include "interface_manager.h"
#include "button_roots.h"


/* **mbedクラス** */
#ifdef LPC4088

#elif  STM32
    #if defined(MAIN_BORD_Ver_4)
        //CrossSelectSW
        DigitalIn Mode_SW1(A2);
        DigitalIn Mode_SW2(A3);   
        InterruptIn CrossSW_UP(D9);   //EXT2
        InterruptIn CrossSW_LEFT(D7);  //PUSH D7
        //InterruptIn CrossSW_DOWN(D9);  //KICK
        DigitalIn   DUMY(D8);  //KICK
        InterruptIn CrossSW_RIGHT(A1); //EXT   
    #elif defined(MAIN_BORD_Ver_5)
        //SWの配置が変わったので使いやすい構成にかえる
        //CrossSelectSW
        DigitalIn Mode_SW1(A2);
        DigitalIn Mode_SW2(A3);   
        InterruptIn CrossSW_UP(D9);   //EXT2
        InterruptIn CrossSW_LEFT(D7);  //PUSH D7
        //InterruptIn CrossSW_DOWN(D9);  //KICK
        DigitalIn   DUMY(A1);  //KICK
        InterruptIn CrossSW_RIGHT(D8); //EXT   
    #elif defined(MAIN_BORD_Ver_3) 
        //ModeSelectSW
        DigitalIn Mode_SW1(A3);
        DigitalIn Mode_SW2(A2);
        //CrossSelectSW
        InterruptIn CrossSW_UP(D11);   //EXT2
        InterruptIn CrossSW_LEFT(D7);  //PUSH D7
        //InterruptIn CrossSW_DOWN(D9);  //KICK
        DigitalIn   DUMY(D8);  //KICK
        InterruptIn CrossSW_RIGHT(A1); //EXT
    #endif
#endif

DigitalOut myled(LED1);

Ticker t_up;
Ticker t_left;
Ticker t_down;
Ticker t_right;

/* **ローカル割り込み関数** */
//#ifndef MAIN_BORD_Ver_5
void check_click_up(void)
{
    if(InterfaceManager::button.count_click[0]  ==  1)
    {
        InterfaceManager::button.setButtunStatus(CROSS_UP, SINGLE_CLICK); 
    }  
    else if(InterfaceManager::button.count_click[0]  ==  2)
    {
        InterfaceManager::button.setButtunStatus(CROSS_UP, DOUBLE_CLICK); 
    }
    InterfaceManager::button.count_click[0]  = 0;
    t_up.detach();
    
}
//#endif
//void check_click_down(void)
//{
//    if(InterfaceManager::button.count_click[1]  ==  1)
//    {
//        InterfaceManager::button.setButtunStatus(CROSS_DOWN, SINGLE_CLICK); 
//    }  
//    else if(InterfaceManager::button.count_click[1]  ==  2)
//    {
//        InterfaceManager::button.setButtunStatus(CROSS_DOWN, DOUBLE_CLICK); 
//    }
//    InterfaceManager::button.count_click[1]  = 0;
//    t_down.detach();    
//}
void check_click_left(void)
{
    if(InterfaceManager::button.count_click[2]  ==  1)
    {
        InterfaceManager::button.setButtunStatus(CROSS_LEFT, SINGLE_CLICK); 
    }  
    else if(InterfaceManager::button.count_click[2]  ==  2)
    {
        InterfaceManager::button.setButtunStatus(CROSS_LEFT, DOUBLE_CLICK); 
    }
    InterfaceManager::button.count_click[2]  = 0;
    t_left.detach();
}
void check_click_right(void)
{
    if(InterfaceManager::button.count_click[3]  ==  1)
    {
        InterfaceManager::button.setButtunStatus(CROSS_RIGHT, SINGLE_CLICK); 
    }  
    else if(InterfaceManager::button.count_click[3]  ==  2)
    {
        InterfaceManager::button.setButtunStatus(CROSS_RIGHT, DOUBLE_CLICK); 
    }
    InterfaceManager::button.count_click[3]  = 0;
    t_right.detach();
    
}

//#ifndef MAIN_BORD_Ver_5
void click_up(void)
{
    myled = !myled;
    switch(InterfaceManager::button.count_click[0]){
        case 0:
        t_up.attach(check_click_up, CHECK_TIME);
        InterfaceManager::button.count_click[0]++;
        break;
        
        case 1:
        InterfaceManager::button.count_click[0]++;
        break;
        
        default:
        InterfaceManager::button.count_click[0] = 0;
        break;
    }  
    
}
//#endif
//void click_down(void)
//{
//    myled = !myled;
//    switch(InterfaceManager::button.count_click[1]){
//        case 0:
//        t_down.attach(check_click_down, CHECK_TIME);
//        InterfaceManager::button.count_click[1]++;
//        break;
//        
//        case 1:
//        InterfaceManager::button.count_click[1]++;
//        break;
//        
//        default:
//        InterfaceManager::button.count_click[1] = 0;
//        break;
//    } 
//    
//}
void click_left(void)
{
    myled = !myled;
    switch(InterfaceManager::button.count_click[2]){
        case 0:
        t_left.attach(check_click_left, CHECK_TIME);
        InterfaceManager::button.count_click[2]++;
        break;
        
        case 1:
        InterfaceManager::button.count_click[2]++;
        break;
        
        default:
        InterfaceManager::button.count_click[2] = 0;
        break;
    }    
    
}
void click_right(void)
{
    myled = !myled;
    switch(InterfaceManager::button.count_click[3]){
        case 0:
        t_right.attach(check_click_right, CHECK_TIME);
        InterfaceManager::button.count_click[3]++;
        break;
        
        case 1:
        InterfaceManager::button.count_click[3]++;
        break;
        
        default:
        InterfaceManager::button.count_click[3] = 0;
        break;
    } 
    
}


/* **グルーバル関数** */
void initButton(void)
{
    Mode_SW1.mode(PullDown);
    Mode_SW2.mode(PullDown);
    
    //#ifndef MAIN_BORD_Ver_5
    CrossSW_UP.mode(PullNone);
    //#else
    //UP.mode(PullNone);
    //#endif
    //CrossSW_DOWN.mode(PullNone);
    DUMY.mode(PullNone);
    CrossSW_LEFT.mode(PullNone);
    CrossSW_RIGHT.mode(PullNone);   
    
    //入力割り込み設定
    //#ifndef MAIN_BORD_Ver_5
    CrossSW_UP.fall(&click_up);
    //#else
    
    //#endif   
    CrossSW_LEFT.fall(&click_left);

    //CrossSW_DOWN.rise(&click_down);
    CrossSW_RIGHT.fall(&click_right);
    
}

/* **クラス** */
Button_Roots::Button_Roots()
{
    modeSW1    = 0;
    modeSW2    = 0;
    modeSW     = 0;
    crossUp    = 0;
    crossDown  = 0;
    crossLeft  = 0;
    crossRight = 0;
    
}
char Button_Roots::getButtonStatus(char ButtonNames)
{
    switch(ButtonNames){
        case MODE_SW1:
        return !Mode_SW1;
        
        case MODE_SW2:
        return !Mode_SW2;
        
        case MODE_SW:
        modeSW = !Mode_SW1 + (!Mode_SW2 << 1); 
        return modeSW;
        
        case CROSS_UP:
//        #ifndef MAIN_BORD_Ver_5
        button_status   = crossUp;
        crossUp         = 0;
//        #else
//        if( (!UP) && (cross_up_old == 1) ){
//            is_button_pushed_up    = 1;
//        }else{
//            is_button_pushed_up    = 0;
//        }
//        cross_up_old   = !UP;
//        button_status   = is_button_pushed_up;
//        #endif
        return button_status;      

        case CROSS_DOWN:
        if( (!DUMY) && (cross_down_old == 1) ){
            is_button_pushed    = 1;
        }else{
            is_button_pushed    = 0;
        }
        cross_down_old   = !DUMY;
        button_status   = is_button_pushed;
        //crossDown       = 0;
        return button_status;
        
        case CROSS_LEFT:
        button_status   = crossLeft;
        crossLeft       = 0;
        return button_status;        

        case CROSS_RIGHT:
        button_status   = crossRight;
        crossRight      = 0;
        return button_status;
        
        default:
        return 99;
        
    } 

}
char Button_Roots::setButtunStatus(char ButtonNames, char ButtonStatus)
{
    switch(ButtonNames){
        case MODE_SW1:
        return modeSW1 = ButtonStatus;
        
        case MODE_SW2:
        return modeSW2 = ButtonStatus;
        
        case CROSS_UP:
        return crossUp = ButtonStatus;      

        case CROSS_DOWN:
        return crossDown = ButtonStatus;
        
        case CROSS_LEFT:
        return crossLeft  = ButtonStatus;       

        case CROSS_RIGHT:
        return crossRight = ButtonStatus;
        
        default:
        return 99;
        
    }    
    
}
