
#ifndef TYPEDEF_H
#define TYPEDEF_H

#include "mbed.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>

/* *********************************************   */
typedef struct RawData
{
    unsigned char machine_id;
    unsigned char vphasor_value_of_machine;
    unsigned char vphasor_angle_of_machine;
    unsigned char vw_of_machine;
    unsigned char actions_of_machine;
    unsigned char power;
}RawData;
/* *********************************************   */

/* *********************************************   */
typedef struct MachineData
{
    unsigned char machine_id;
    unsigned short v_mm_per_sec;
    unsigned short angle_degree;
    signed short vw_mrad_per_sec;
    unsigned char dribble_flag;
    unsigned char kick_flag;
    unsigned char kick_type;
    unsigned char charge_flag;
    unsigned char dribbler_power;
    unsigned char kickers_power;
}MachineData;
/* *********************************************   */

/* *********************************************   */
typedef struct CommandPartial{
    unsigned char dribble_flag;
    unsigned char kick_flag;
    unsigned char kick_type;
    unsigned char charge_flag;
}CommandPartial;
/* *********************************************   */

/* *********************************************   */
typedef struct PowerPartial{
    unsigned char kickrs_power;
    unsigned char dribbler_power;
}PowerPartial;
/* *********************************************   */

/* *********************************************   */
typedef struct {
    union{
        signed short Vel_short;
        struct{
            signed short L:8;
            signed short H:8;
        }Vel_char;
    }Mot0Order;
    
    union{
        signed short Vel_short;
        struct{
            signed short L:8;
            signed short H:8;
        }Vel_char;
    }Mot1Order;
    
    union{
        signed short Vel_short;
        struct{
            signed short L:8;
            signed short H:8;
        }Vel_char;
    }Mot2Order;
    
    union{
        signed short Vel_short;
        struct{
            signed short L:8;
            signed short H:8;
        }Vel_char;
    }Mot3Order;
    
} OrderMotVel;
/* *********************************************   */

/* *********************************************   */
typedef enum ErrAddFIFO {  /* addFIFO()の戻り値 */ 
    ADD_SUCCESS,
    FIFO_OVERFLOWED
} ErrAddFIFO;
/* *********************************************   */

/* *********************************************   */
typedef enum ErrGetFIFO { /* getFIFO()の戻り値 */ 
    GET_SUCCESS,
    FIFO_EMPTY
} ErrGetFIFO;
/* *********************************************   */

/* *********************************************   */
typedef enum ErrGetAllFIFO{ /*getAllFIFO()の戻り値 */
    SUCCESS_GET_ALL_FIFO,
    BUFFER_SIZE_IS_NOT_ENOUGH
} ErrGetAllFIFO;
/* *********************************************   */

union MotorTorque_Data{
    signed short MotTrq_short;
    struct{
        signed short L:8;
        signed short H:8;
    }MotTrq_char;
};

#endif