#ifndef STATUS_MANAGER_H
#define STATUS_MANAGER_H

#include "mbed.h"
#include "typedef.h"


class StatusManager{
    public:
    
    //MODE関係
    static char mode;
    static signed char uart;
    
    //Kicker関係
    static char is_kicking;
    static char req_charge;
    static char ball;
    static char charge_end;
    
    //Dribbler関係
    static char dribbleIC_fault;
    static char dribbleMot_OvrCur;
    static float dribbleMotor_current;
    static float req_dribbleMotor_current;
    static float req_dribbleMotor_PID;
    
    //XBee関係
    static char xbee_time_out;
    static char xbee_receiveing;
    
    //バッテリー
    static float supply_voltage;
    
    //その他
    static char alive_count;
    static unsigned short DriveTime;
    static char indicate_i2c_enable;
    static unsigned char MainBoard;
    
    //Wheel
    static signed short Vel_Wheel1;
    static signed short Vel_Wheel2;
    static signed short Vel_Wheel3;
    static signed short Angle;
    
    static MotorTorque_Data motTrqData;
    
    private:
    StatusManager();
    
    
    
};

/* **グローバル関数** */
extern void init_status(void);

#endif