#include "mbed.h"
#include "status_manager.h"
#include "interface_manager.h"

char StatusManager::is_kicking;
char StatusManager::mode;
signed char StatusManager::uart;
char StatusManager::req_charge;
char StatusManager::ball;
char StatusManager::xbee_time_out;
char StatusManager::xbee_receiveing;
char StatusManager::dribbleIC_fault;
char StatusManager::dribbleMot_OvrCur;
char StatusManager::charge_end;
float StatusManager::supply_voltage;
float StatusManager::dribbleMotor_current;
float StatusManager::req_dribbleMotor_current;
float StatusManager::req_dribbleMotor_PID;
char  StatusManager::alive_count;
char  StatusManager::indicate_i2c_enable;
unsigned short StatusManager::DriveTime;
unsigned char  StatusManager::MainBoard;
signed short StatusManager::Vel_Wheel1;
signed short StatusManager::Vel_Wheel2;
signed short StatusManager::Vel_Wheel3;
signed short StatusManager::Angle;
MotorTorque_Data StatusManager::motTrqData;

extern void init_status(void)
{
    StatusManager::charge_end       = 0;
    StatusManager::is_kicking       = 0;
    StatusManager::dribbleIC_fault  = 0;
    StatusManager::dribbleMot_OvrCur = 0;
    StatusManager::alive_count = 0;
    StatusManager::DriveTime = 0;
    StatusManager::req_dribbleMotor_PID = 0;
    StatusManager::indicate_i2c_enable = 0;
    StatusManager::Vel_Wheel1 = 0;
    StatusManager::Vel_Wheel2 = 0;
    StatusManager::Vel_Wheel3 = 0;
    StatusManager::Angle = 0;
    
#if defined(MAIN_BORD_Ver_3)
    StatusManager::MainBoard = 3;
#elif defined(MAIN_BORD_Ver_4)
    StatusManager::MainBoard = 4;
#elif defined(MAIN_BORD_Ver_5)
    StatusManager::MainBoard = 5;
#endif
    
}