
#include "mbed.h"
#include "comm.h"
#include "interface_manager.h"
#include "parameter_manager.h"
#include "status_manager.h"
#include "pid.h"
#include "math.h"

/* **mbedクラス** */
#ifdef LPC4088

#elif  STM32

#endif

/* **ローカル関数定義** */

/* **ローカル関数** */

/* **グルーバル関数** */

/* **クラス** */
class InterfaceManager;
//メンバ変数の初期化は、定義順（Ｗａｒｎｉｎｇになる）
PID::PID(float m_Kp = (float)1.0 , float m_Ki = (float)0.1 , float m_Kd = (float)0.0 , float m_Integral_limit_max = (float)40.0, float m_Integral_limit_min = (float)0.0)
{
   output[0] = 0;
   output[1] = 0;
   output[2] = 0;
   output[3] = 0;
   err[0] = 0;
   err[1] = 0;
   err[2] = 0;
   Kp = m_Kp;
   Ki = m_Ki;
   Kd = m_Kd;
   Integral_limit_max = m_Integral_limit_max;
   Integral_limit_min = m_Integral_limit_min;
}

float PID::getPID_Out(float req, float ref)
{
    err[0] = req - ref;
    
    output[0] = Kp * err[0];
    output[1] = Ki * err[0] + output[1];
    output[2] = Kd * (err[0] - err[1]);
    
    err[1] = err[0];
    
    output[3] = output[0] + output[1] + output[2];
    
    if( output[3] >= Integral_limit_max)
    {
        output[1] = Integral_limit_max - (output[0] + output[2]);
        output[3] = Integral_limit_max;
    }
    else if( output[3] <= Integral_limit_min)
    {
        output[1] = Integral_limit_min - (output[0] + output[2]);
        output[3] = Integral_limit_min;
        
    }
    
    return output[3];
}

