
#include "mbed.h"
#include "comm.h"
#include "interface_manager.h"
#include "parameter_manager.h"
#include "kick_power.h"

/* **mbedクラス** */
#ifdef LPC4088

#elif  STM32

#endif

/* **ローカル関数定義** */

/* **ローカル関数** */

/* **グルーバル関数** */

/* **クラス** */
//メンバ変数の初期化は、定義順（Ｗａｒｎｉｎｇになる）
Kick_Power::Kick_Power()
:ZERO_POINT_FIVE_METER_PAR_SEC_(0.0005),
 ONE_METER_PAR_SEC_(0.001),
 ONE_POINT_FIVE_METER_PAR_SEC_(0.002),
 TWO_METER_PAR_SEC_(0.003),
 TWO_POINT_FIVE_METER_PAR_SEC_(0.004),
 THREE_METER_PAR_SEC_(0.005),
 THREE_POINT_FIVE_METER_PAR_SEC_(0.006),
 FOUR_METER_PAR_SEC_(0.007),
 FOUR_POINT_FIVE_METER_PAR_SEC_(0.008),
 FIVE_METER_PAR_SEC_(0.009),
 FIVE_POINT_FIVE_METER_PAR_SEC_(0.010),
 SIX_METER_PAR_SEC_(0.011),
 SIX_POINT_FIVE_METER_PAR_SEC_(0.012),
 SEVEN_METER_PAR_SEC_(0.013),
 SEVEN_POINT_FIVE_METER_PAR_SEC_(0.014),
 EIGHT_METER_PAR_SEC_(0.015),
 ZERO_POINT_FIVE_METER_(0.0005),
 ONE_METER_(0.001),
 ONE_POINT_FIVE_METER_(0.002),
 TWO_METER_(0.003),
 TWO_POINT_FIVE_METER_(0.004),
 THREE_METER_(0.005),
 THREE_POINT_FIVE_METER_(0.006),
 FOUR_METER_(0.007),
 FOUR_POINT_FIVE_METER_(0.008),
 FIVE_METER_(0.009),
 FIVE_POINT_FIVE_METER_(0.010),
 SIX_METER_(0.011),
 SIX_POINT_FIVE_METER_(0.012),
 SEVEN_METER_(0.013),
 SEVEN_POINT_FIVE_METER_(0.014),
 EIGHT_METER_(0.015),
 PERIOD_OF_FORCE_FIRE_(0.005)
 {    
 }
 
 
double Kick_Power::getStraightPowerTime(char power)
{
    switch(power){
    case 0:
        return ZERO_POINT_FIVE_METER_PAR_SEC_;
        

    case 1:
        return ONE_METER_PAR_SEC_;
        

    case 2:
        return ONE_POINT_FIVE_METER_PAR_SEC_;
        

    case 3:
        return TWO_METER_PAR_SEC_;
        

    case 4:
        return TWO_POINT_FIVE_METER_PAR_SEC_;
        

    case 5:
        return THREE_METER_PAR_SEC_;
        

    case 6:
        return THREE_POINT_FIVE_METER_PAR_SEC_;
        

    case 7:
        return FOUR_METER_PAR_SEC_;
        

    case 8:
        return FOUR_POINT_FIVE_METER_PAR_SEC_;
        

    case 9:
        return FIVE_METER_PAR_SEC_;
        

    case 10:
        return FIVE_POINT_FIVE_METER_PAR_SEC_;
        

    case 11:
        return SIX_METER_PAR_SEC_;
        

    case 12:
        return SIX_POINT_FIVE_METER_PAR_SEC_;
        

    case 13:
        return SEVEN_METER_PAR_SEC_;
        

    case 14:
        return SEVEN_POINT_FIVE_METER_PAR_SEC_;
        

    case 15:
        return EIGHT_METER_PAR_SEC_;
        

    default:
        return PERIOD_OF_FORCE_FIRE_;
        
    }

}
double Kick_Power::getChipPowerTime(char power)
{
    switch(power){
    case 0:
        return ZERO_POINT_FIVE_METER_PAR_SEC_;
        

    case 1:
        return ONE_METER_PAR_SEC_;
        

    case 2:
        return ONE_POINT_FIVE_METER_PAR_SEC_;
        

    case 3:
        return TWO_METER_PAR_SEC_;
        

    case 4:
        return TWO_POINT_FIVE_METER_PAR_SEC_;
        

    case 5:
        return THREE_METER_PAR_SEC_;
        

    case 6:
        return THREE_POINT_FIVE_METER_PAR_SEC_;
        

    case 7:
        return FOUR_METER_PAR_SEC_;
        

    case 8:
        return FOUR_POINT_FIVE_METER_PAR_SEC_;
        

    case 9:
        return FIVE_METER_PAR_SEC_;
        

    case 10:
        return FIVE_POINT_FIVE_METER_PAR_SEC_;
        

    case 11:
        return SIX_METER_PAR_SEC_;
        

    case 12:
        return SIX_POINT_FIVE_METER_PAR_SEC_;
        

    case 13:
        return SEVEN_METER_PAR_SEC_;
        

    case 14:
        return SEVEN_POINT_FIVE_METER_PAR_SEC_;
        

    case 15:
        return EIGHT_METER_PAR_SEC_;
        

    default:
        return PERIOD_OF_FORCE_FIRE_;
        
    }

}