
#include "mbed.h"
#include "comm.h"
#include "interface_manager.h"
#include "parameter_manager.h"
#include "status_manager.h"
#include "filter.h"
#include "math.h"

/* **mbedクラス** */
#ifdef LPC4088

#elif  STM32

#endif

/* **ローカル関数定義** */

/* **ローカル関数** */

/* **グルーバル関数** */

/* **クラス** */
class InterfaceManager;
//メンバ変数の初期化は、定義順（Ｗａｒｎｉｎｇになる）
LPF::LPF(double coefficient = 0.9)
{
   output[0] = 0;
   output[1] = 0;
   filter_coefficient = coefficient;
}

double LPF::getLPF_Out(double input)
{
    output[1] = filter_coefficient * output[0] + ((double)1.0 - filter_coefficient) * input;
    output[0] = output[1];

    return output[0];
}

