
#include "mbed.h"
#include "comm.h"
#include "fifo.h"

/* **mbedクラス** */
#ifdef LPC4088

#elif  STM32

#endif


/* **ローカル関数定義** */

/* **ローカル関数** */

/* **グルーバル関数** */

/* **クラス** */
FIFO_Roots::FIFO_Roots()
:head_write(0),
 head_read(0)
{}
 
 ErrAddFIFO  FIFO_Roots::addFIFO(fifo_type data )
{
    unsigned char   next = (head_write+ 1) & (FIFO_SIZE - 1);

    if( next == head_read ){
        return  FIFO_OVERFLOWED;
    }

    fifo_data[head_write]    = data;
    head_write  = next;

    return  ADD_SUCCESS;
    
}

fifo_type  FIFO_Roots::getFIFO(void)
{
    fifo_type buf;
    
    buf    = fifo_data[head_read];
    head_read   = (head_read + 1) & (FIFO_SIZE - 1 );

    return  buf;
}

ErrGetFIFO FIFO_Roots::statusFIFO(void)
{
    if( head_read == head_write ){
        return  FIFO_EMPTY;
    }
    return GET_SUCCESS;
}