#ifndef WHEEL_ROOTS_H
#define WHEEL_ROOTS_H

/* **Include** */
#include "mbed.h"
#include "comm.h"
#include "typedef.h"
#include "interface_manager.h"
#include "status_manager.h"

/* **Define** */
#define DEG2RAD 0.01745329251 // π/180 = 0.01745329251
#define RAD2DEG 57.2957795130 // 180/π = 57.2957795130

/* **変数定義** */
#ifndef EXCHANGE_REQUEST
const double CONST_MACHINE_RADIUS_  = 0.07;
const double CONST_WHEEL_RADIUS_    = 24; //old:26
const double CONST_GEER_RATIO_      = 2.22; //old:2.83
#endif

#ifdef EXCHANGE_REQUEST
const double CONST_MACHINE_RADIUS_  = 0.07;
const double CONST_WHEEL_RADIUS_    = 28;
const double CONST_GEER_RATIO_      = 2.4;
#endif

const double CONST_V0_COEFFICIENT_VX_ = -0.5,       CONST_V0_COEFFICIENT_VY_ = 0.8660254;
const double CONST_V1_COEFFICIENT_VX_ = -0.5,       CONST_V1_COEFFICIENT_VY_ = -0.8660254;
const double CONST_V2_COEFFICIENT_VX_ = 1,          CONST_V2_COEFFICIENT_VY_ = 0;
const double CONST_V3_COEFFICIENT_VX_ = 2.0000015,  CONST_V3_COEFFICIENT_VY_ = 1.15470024;
/* **グルーバル関数** */

/* **クラス** */
class InterfaceManager;
class StatusManager;

class Wheel{
  public:
  Wheel();
  void setVelocity(short V_value, short V_angle, short V_omega);
  short getVel_Mot0(void){return order.Mot0Order.Vel_short;}
  short getVel_Mot1(void){return order.Mot1Order.Vel_short;}
  short getVel_Mot2(void){return order.Mot2Order.Vel_short;}
  short getVel_Mot3(void){return order.Mot3Order.Vel_short;}
  
  private:
  OrderMotVel order;
  short Vel_Value;
  short Vel_Angle;
  short Vel_Omega;

  double Vel_X;
  double Vel_Y;
  double Vel_OMEGA;
  
  double Vel_Mot0_double;
  double Vel_Mot1_double;
  double Vel_Mot2_double;
  double Vel_Mot3_double;
    
  void calcWheelVelocity(void);
  void convertPhasorToVector(void);
  void resolveVector(void);
  double operationV0(double vx,double vy, double vw);
  double operationV1(double vx,double vy, double vw);
  double operationV2(double vx,double vy, double vw);
  double operationV3(double vx,double vy, double vw);
  
  
};


#endif