#ifndef KICKER_ROOTS_H
#define KICKER_ROOTS_H

/* **Include** */
#include "mbed.h"
#include "comm.h"
#include "interface_manager.h"
#include "status_manager.h"

/* **Define** */
#define STRAIGHT    0
#define CHIP        1
#define CONTINUE_DELAY 1400  //main処理周期　0.45ms
#define NUM_OF_KICK 49//n+1回やります
//#define CONTINUE_DELAY 80  //main処理周期　0.45ms
//#define NUM_OF_KICK 0//n+1回やります

/* **変数定義** */

/* **グルーバル関数** */

/* **クラス** */
class InterfaceManager;
class StatusManager;

class Kicker{
  public:
  Kicker();
  void setKick(char flag_kick, char kick_Type, char kick_power);
  void setCharge(char flag_charge); 
  void forceFireKick(void);

  
  private:  
  void fireKick(char t_KickType,char t_power); 
  void checkKickEnable(void);
  void checkRelease(void);
  void checkChargeCompleted(void);
  void checkBallSensor(void);
  void fireTimer(void);
  
  enum  BALL{IS_NOT_EXIST, IS_EXIST};
  enum  KickPermit{DISABLE, ENABLE};
  BALL  ball;
  KickPermit kickPermit;
  char  f_kick;
  char  f_charge_fin;
  char  kickType;
  char  power;
  char  f_charge;
  char  isRelease;
  short fireTime;
  int  count_continue_delay;
  int  count_num_of_kick;
  int  mode_discharge;

};

#endif