
#include "mbed.h"
#include "comm.h"
#include "interface_manager.h"
#include "parameter_manager.h"
#include "kicker.h"

/* **mbedクラス** */
#ifdef LPC4088

#elif  STM32
Timeout kickTimer;
#endif

/* **ローカル関数定義** */
void fireTimer(void);
void driveFireTimer(double firetime);

/* **ローカル関数** */
void fireTimer(void)
{
    InterfaceManager::straight_kick     = 0;
    InterfaceManager::chip_kick         = 0;
    StatusManager::is_kicking           = 0;
    kickTimer.detach();
    return;
}

void driveFireTimer(double firetime)
{
    kickTimer.attach(&fireTimer,(float)firetime);   
}

/* **グルーバル関数** */

/* **クラス** */
//メンバ変数の初期化は、定義順（Ｗａｒｎｉｎｇになる）
Kicker::Kicker()
:ball(IS_NOT_EXIST),
 kickPermit(DISABLE),
 f_kick(0),
 f_charge_fin(0),
 kickType(STRAIGHT),
 power(0),
 f_charge(0),
 isRelease(0),
 fireTime(0),
 count_continue_delay(0),
 count_num_of_kick(0),
 mode_discharge(0)
 {    
 }

void Kicker::setKick(char flag_kick, char kick_Type, char kick_power)
{
    
    f_kick      = flag_kick;
    kickType    = kick_Type;
    power       = kick_power;
    
    checkBallSensor();      //ball
    checkChargeCompleted(); //f_charge_fin
    if(f_kick == 1)
    {
        checkKickEnable();
        if(kickPermit == ENABLE)
        {
            fireKick(kickType, power);
        }
    }
}

void Kicker::setCharge(char flag_charge)
{
    if(flag_charge && (StatusManager::is_kicking == 0))
    {
        f_charge = 1;
        InterfaceManager::charge_request    = 1;
    }
    else
    {
        f_charge = 0;
        InterfaceManager::charge_request    = 0;
    }
    StatusManager::req_charge = f_charge;
}

void Kicker::fireKick(char t_KickType,char t_power)
{
   switch(t_KickType)
    {
        case STRAIGHT:
        InterfaceManager::LED  =  1;
        InterfaceManager::charge_request    = 0;
        StatusManager::is_kicking           = 1;
        InterfaceManager::straight_kick     = 1;
        driveFireTimer(ParameterManager::kickpower.getStraightPowerTime(t_power));
        //driveFireTimer(ParameterManager::kickpower.getChipPowerTime(t_power));
        break;
        
        case CHIP:
        InterfaceManager::charge_request    = 0;
        StatusManager::is_kicking           = 1;
        InterfaceManager::chip_kick         = 1;
        driveFireTimer(ParameterManager::kickpower.getChipPowerTime(t_power));
        //driveFireTimer(ParameterManager::kickpower.getStraightPowerTime(t_power));
        break;
        
        default:
        InterfaceManager::straight_kick     = 0;
        InterfaceManager::chip_kick         = 0;
        break;   
    }
}

void Kicker::forceFireKick(void)
{
    

    if( InterfaceManager::button.getButtonStatus(CROSS_DOWN) == 1 ){
        mode_discharge  = 1;
    }
    
    if( mode_discharge == 0 ){
        count_continue_delay    = 0;
        count_num_of_kick   = 0;
        return;
    }

    if( count_num_of_kick > NUM_OF_KICK ){
        mode_discharge  = 0;
        return;
    }

    if( StatusManager::is_kicking == 1 ){
        return;
    }

    if( count_continue_delay < CONTINUE_DELAY ){
        count_continue_delay ++;
        return;
    }

    count_continue_delay    = 0;
    
    StatusManager::is_kicking           = 1;
    InterfaceManager::charge_request    = 0;
    fireKick(STRAIGHT, 1);

    count_num_of_kick++;   
    
}

void Kicker::checkKickEnable(void)
{
    
    //if( f_charge_fin )
    if( f_charge_fin && (ball == IS_EXIST) && !isRelease && !StatusManager::is_kicking)
    {
        
        kickPermit      = ENABLE;
        isRelease       = 1;
        f_charge_fin    = 0;
        //StatusManager::charge_end = InterfaceManager::charge_completed; 
    }
    else
    {
        kickPermit      = DISABLE;
    }

}

void Kicker::checkChargeCompleted(void)
{
    //不論理   
    if(InterfaceManager::charge_completed == 0)
    {
        f_charge_fin = 1;  
    }   
    else
    {
        f_charge_fin = 0;   
    }
    StatusManager::charge_end = f_charge_fin; 
}

void Kicker::checkBallSensor(void)
{
    if(InterfaceManager::ball_sensor == 0)
    {
        isRelease = 0;
        ball = IS_NOT_EXIST; 
        StatusManager::ball = 0;  
    }
    else if(InterfaceManager::ball_sensor == 1)
    {   
        ball = IS_EXIST; //豆知識ＥＸＩＳＴは、存在する（知らんかった；；）  
        StatusManager::ball = 1;
    }
     
}


