
#include "mbed.h"
#include "comm.h"
#include "interface_manager.h"
#include "parameter_manager.h"
#include "dribbler.h"

/* **mbedクラス** */
#ifdef LPC4088

#elif  STM32

#endif

/* **ローカル関数定義** */
void fireTimer(void);
void driveFireTimer(double firetime);

/* **ローカル関数** */

/* **グルーバル関数** */

/* **クラス** */
class InterfaceManager;
//メンバ変数の初期化は、定義順（Ｗａｒｎｉｎｇになる）
Dribbler::Dribbler()
:f_dribble(0),
 power(0)
 {    
 }

void Dribbler::setdribble(char flag_dribble, char dribble_power)
{
    f_dribble   = flag_dribble;
    power       = dribble_power;
    
    checkIC();
//    if(1)
    if(f_dribble)
    //if(f_dribble && (StatusManager::dribbleIC_fault == 0))
    {
        //InterfaceManager::dribbleStandBy = 0;
//        if(power < 5)
//        {
//            power = 5;
//        }
//        
//        if(power > 11)
//        {
//            power = 11;
//        }
        if( StatusManager::dribbleMot_OvrCur  != 1)
        {   
            driveDribble(power);
        }
        else
        {
            driveDribble(0);
        }
    }
    else
    {
        driveDribble(0);
        //InterfaceManager::dribbleStandBy = 0;   
    }
}

void Dribbler::driveDribble(char t_power)
{

    #if defined(MAIN_BORD_Ver_4) || defined(MAIN_BORD_Ver_5)
//        if(t_power != 0)
//        {
//            t_power = 12;    
//        }
        StatusManager::req_dribbleMotor_current = t_power/(float)15.0 * (float)2.0;
        //InterfaceManager::dribbleMotor.write((float)(1.0 - t_power/15.0 * 0.50 ));
    #else
        InterfaceManager::dribbleMotor.write((float)(t_power/15.0));
    #endif
    //InterfaceManager::dribbleMotor.write(0.0); 
    
}

void Dribbler::checkIC(void)
{
    StatusManager::dribbleIC_fault = InterfaceManager::dribbleIC_fault;
}

