
#include "mbed.h"
#include "comm.h"
#include "parameter_manager.h"
#include "interface_manager.h"
#include "receiver.h"

/* **mbedクラス** */
#ifdef LPC4088

#elif  STM32
Timeout TimeOutCheckTimer;
#endif

/* **Define** */
#define NUM_OF_HEADER   3
#define NUM_OF_DATA 5
#define NUM_OF_CHECKSUM 2
/* **ローカル変数定義** */
const unsigned char  FLAME_HEADER_VALUE0_ = 0xFF;
const unsigned char FLAME_HEADER_VALUE1_ = 0xC3;
const unsigned char FIFO_EMPTY_ = 1;
//#ifndef ON_INDICATER
static char send_msg[3] = {0};
//#endif
/* **ローカル関数定義** */
void timeOutCheckTimer(void);
void timeOutCheckTimerDetach(void);
/* **ローカル関数** */
void checkTimer(void)
{
    StatusManager::xbee_time_out = 1;
    StatusManager::xbee_receiveing = 0;
}

void timeOutCheckTimer(void)
{
    TimeOutCheckTimer.attach(&checkTimer,(float)0.5);   
}
void timeOutCheckTimerDetach(void)
{
    TimeOutCheckTimer.detach();   
}
/* **グルーバル関数** */

/* **クラス** */
class InterfaceManager;
class ParameterManager;

//メンバ変数の初期化は、定義順（Ｗａｒｎｉｎｇになる）
Receiver::Receiver()
:error_status(0)
{
        
}

void Receiver::receivePacketData(void)
{
    ScanFunctionSwitch();

    error_status = substitutePacketData();
    StatusManager::uart = error_status;
    
    //if((error_status >= 0) && (StatusManager::xbee_time_out == 0)){
    if((error_status != -1) && (StatusManager::xbee_time_out == 0)){    
        
        ParameterManager::raw_data.machine_id = ParameterManager::machine_id;
        ParameterManager::raw_data.vphasor_value_of_machine = received_data[0];
        ParameterManager::raw_data.vphasor_angle_of_machine = received_data[1];
        ParameterManager::raw_data.vw_of_machine = received_data[2];
        ParameterManager::raw_data.actions_of_machine = received_data[3];
        ParameterManager::raw_data.power = received_data[4];
    }
    else{
        
        ParameterManager::raw_data.machine_id = ParameterManager::machine_id;
        ParameterManager::raw_data.vphasor_value_of_machine = 0;
        ParameterManager::raw_data.vphasor_angle_of_machine = 0;
        ParameterManager::raw_data.vw_of_machine = 127;
        ParameterManager::raw_data.actions_of_machine = 0;
        ParameterManager::raw_data.power = 0;
    }   
    
}

void Receiver::ScanFunctionSwitch(void)
{
    if(InterfaceManager::button.getButtonStatus(CROSS_RIGHT))
    {
        ParameterManager::machine_id++;
        if(ParameterManager::machine_id > MAX_ID)
        {
            ParameterManager::machine_id = MIN_ID;
        }
        //#ifndef ON_INDICATER
        send_msg[2] = ParameterManager::machine_id;
        InterfaceManager::i2c.setIDMsg( send_msg , sizeof(send_msg));
        //#endif
    }
    
    if(InterfaceManager::button.getButtonStatus(CROSS_LEFT))
    {
        ParameterManager::machine_id--;
        if(ParameterManager::machine_id > MAX_ID)
        {
            ParameterManager::machine_id = MAX_ID;
        }
        //#ifndef ON_INDICATER
        send_msg[2] = ParameterManager::machine_id;
        InterfaceManager::i2c.setIDMsg( send_msg , sizeof(send_msg));
        //#endif
    }
}


signed char Receiver::substitutePacketData(void)
{
    /*
     * 引数
     * *p_received_data : 受信データ配列のポインタ
     *
     * 返り値
     * 0    : 正常終了
     * -1   : タイムアウト
     * -2   : オーバーランエラー
     * -3   : フレーミングエラー
     * 1    : 受信中
     * 2    : フレームリーダー1まで受信
     * 3    : フレームリーダー2まで受信
     * 4    : マシンIDまで受信
     */
    static unsigned int num_of_data;
    static unsigned char    received_id = 0;
    static unsigned char    receiving_data[NUM_OF_DATA+5], verified_data[NUM_OF_DATA+5];
    unsigned char  buffer, calculated_checksum, checksum_flag;
    unsigned int i;
    //char str[30] ={0};
    error_status = 0;
    
    //フレーミングとかのエラー情報がマイコンと違って取得が簡単じゃないので、強制的にelseに行くようにしている
    if(error_status == 1){
        num_of_data = 0;
        return -2;
    }else if(error_status == 2){
        num_of_data = 0;
        return -3;
    }else{
        while(InterfaceManager::xbee.fifo.statusFIFO() != FIFO_EMPTY_){
            buffer = InterfaceManager::xbee.fifo.getFIFO();
            //sprintf(str,"buf:%d",buffer);
            //InterfaceManager::i2c.setLCDMsg(str,sizeof(str));   
            switch(num_of_data){
                case 0:
                    if(buffer != FLAME_HEADER_VALUE0_){
                        num_of_data = 0;
                    }else{
                        num_of_data++;
                    }
                    break;

                case 1:
                    if(buffer != FLAME_HEADER_VALUE1_){
                        num_of_data = 0;
                    }else{
                        num_of_data++;
                    }
                    break;

                case 2:
                    if(buffer != ParameterManager::machine_id){
                        num_of_data = 0;
                    }else{
                        received_id = buffer;
                        num_of_data++;
                    }
                    break;

                case    NUM_OF_DATA + NUM_OF_HEADER:
                    /*チェックサム1*/
                    calculated_checksum = received_id;
                    for( i = 0; i < NUM_OF_DATA; i++ ){
                        calculated_checksum ^= receiving_data[i];
                    }


                    if( buffer == calculated_checksum ){
                        num_of_data ++;
                    }else{
                        num_of_data = 0;
                    }
                    break;

                case    NUM_OF_DATA + NUM_OF_HEADER + 1:
                    /*チェックサム2*/
                    calculated_checksum = received_id;
                    for( i = 0; i < NUM_OF_DATA; i++ ){
                        calculated_checksum ^= receiving_data[i];
                    }
                    calculated_checksum = ~calculated_checksum;

                    if( buffer == calculated_checksum ){
                        for( i = 0; i < NUM_OF_DATA; i++ ){
                            verified_data[i]    = receiving_data[i];
                        }
//                        timeout.detach();
//                        timeout.attach(rx_timeout,0.5);
//                        StatusManager::xbee_time_out = 0;
                        checksum_flag = 1;
                        StatusManager::xbee_receiveing = 1;
                        StatusManager::xbee_time_out = 0;
                        timeOutCheckTimerDetach();
                        timeOutCheckTimer();
                        
                    }

                    num_of_data = 0;
                    break;

                default:
                    receiving_data[num_of_data - NUM_OF_HEADER] = buffer;
                    num_of_data++;

                    break;
            }
        }

        for( i=0; i<NUM_OF_DATA; i++ ){
            received_data[i] = verified_data[i];
        }

        if(StatusManager::xbee_receiveing == 0){
            return -1;
        }

        if(checksum_flag == 1){
            checksum_flag = 0;
            return 0;
        }

        switch(num_of_data){
            case 0:
                return 1;

            case 1:
                return 2;

            case 2:
                return 3;

            case 3:
                return 4;

            default:
                break;
        }

        return 5;
    } 
    /*
     * 引数
     * *p_received_data : 受信データ配列のポインタ
     *
     * 返り値
     * 0    : 正常終了
     * -1   : タイムアウト
     * -2   : オーバーランエラー
     * -3   : フレーミングエラー
     * 1    : 受信中
     * 2    : フレームリーダー1まで受信
     * 3    : フレームリーダー2まで受信
     * 4    : マシンIDまで受信
     */
}
