
#include "mbed.h"
#include "comm.h"
#include "mode.h"
#include "interface_manager.h"
#include "status_manager.h"
#include "parameter_manager.h"
#include "normal_routine.h"

/* **mbedクラス** */
#ifdef LPC4088

#elif  STM32

#endif

#ifdef ON_INDICATER
static char batVoltage[1];
#endif

/* **ローカル関数定義** */

/* **ローカル関数** */

/* **グルーバル関数** */

/* **クラス** */
class InterfaceManager;
class StatusManager;
class ParameterManager;



//メンバ変数の初期化は、定義順（Ｗａｒｎｉｎｇになる）
NormalRoutine::NormalRoutine()
{
    failsafe.init();
}
 
void NormalRoutine::run(void)
{
    packet.splitPacket();
    
    //Kick
    kicker.setCharge(ParameterManager::machine_data.charge_flag);
    kicker.setKick(ParameterManager::machine_data.kick_flag,ParameterManager::machine_data.kick_type,ParameterManager::machine_data.kickers_power);
    kicker.forceFireKick();
    
    //Wheel
    wheel.setVelocity(ParameterManager::machine_data.v_mm_per_sec,ParameterManager::machine_data.angle_degree,ParameterManager::machine_data.vw_mrad_per_sec);
    //wheel.setVelocity(5000,0,0);
    
    //Drible 
    dribble.setdribble(ParameterManager::machine_data.dribble_flag, ParameterManager::machine_data.dribbler_power);
    //dribble.setdribble(1, 3);
    
    StatusManager::supply_voltage = InterfaceManager::batVoltage.read();
    StatusManager::supply_voltage *= (float)3.3 * (float)6.251;
    
    

    //sprintf(str,"T%dOv:%d\nC:%3.2f",StatusManager::DriveTime,StatusManager::dribbleMot_OvrCur,StatusManager::dribbleMotor_current);
    createLcdData();
    InterfaceManager::i2c.setLCDMsg(str,sizeof(str)); 

#ifdef ON_INDICATER    
    batVoltage[0] = (char)(StatusManager::supply_voltage * 10);
    //batVoltage[0] = 150;
    InterfaceManager::i2c.setIndicateMsg( batVoltage , sizeof(batVoltage));
#endif    

}

void NormalRoutine::createLcdData(void)
{
    
    /*
 
     * 0    : 正常終了
 
     * -1   : タイムアウト
 
     * -2   : オーバーランエラー
 
     * -3   : フレーミングエラー
 
     * 1    : 受信中
 
     * 2    : フレームリーダー1まで受信
 
     * 3    : フレームリーダー2まで受信
 
     * 4    : マシンIDまで受信
 
     */
    switch(StatusManager::uart){
    case 0:
        //sprintf(str,"ID%dB%3.1f\nComplete",ParameterManager::machine_id,StatusManager::supply_voltage);
        sprintf(str,"ID%d:CP\nB%3.1fBN%d",ParameterManager::machine_id,StatusManager::supply_voltage,StatusManager::MainBoard);
        sprintf(str_uart,"Complete");
        break;
 
    case 1:
        //sprintf(str,"ID%dB%3.1f\nComplete",ParameterManager::machine_id,StatusManager::supply_voltage);
        sprintf(str,"ID%d:RC\nB%3.1fBN%d",ParameterManager::machine_id,StatusManager::supply_voltage,StatusManager::MainBoard);
        sprintf(str_uart,"Recived");
        break;
 
    case 2:
        //sprintf(str,"ID%dB%3.1f\nHeader1",ParameterManager::machine_id,StatusManager::supply_voltage);
        sprintf(str,"ID%d:H1\nB%3.1fBN%d",ParameterManager::machine_id,StatusManager::supply_voltage,StatusManager::MainBoard);
        sprintf(str_uart,"Header1");
        break;

    case 3:
        //sprintf(str,"ID%dB%3.1f\nHeader2",ParameterManager::machine_id,StatusManager::supply_voltage);
        sprintf(str,"ID%d:H2\nB%3.1fBN%d",ParameterManager::machine_id,StatusManager::supply_voltage,StatusManager::MainBoard);
        sprintf(str_uart,"Header2");
        break;
 
    case 4:
        //sprintf(str,"ID%dB%3.1f\nCheckER1",ParameterManager::machine_id,StatusManager::supply_voltage);
        sprintf(str,"ID%d:CE1\nB%3.1fBN%d",ParameterManager::machine_id,StatusManager::supply_voltage,StatusManager::MainBoard);
        sprintf(str_uart,"CheckERR");
        break;

    case 5:
        //sprintf(str,"ID%dB%3.1f\nCheckER2",ParameterManager::machine_id,StatusManager::supply_voltage);
        sprintf(str,"ID%d:CE2\nB%3.1fBN%d",ParameterManager::machine_id,StatusManager::supply_voltage,StatusManager::MainBoard);
        sprintf(str_uart,"CheckERR");
        break;

    case -1:
        //sprintf(str,"ID%dB%3.1f\nTimeOut",ParameterManager::machine_id,StatusManager::supply_voltage);
        //sprintf(str,"ID%dB%d\nTimeOut",ParameterManager::machine_id,StatusManager::indicate_i2c_enable);
        sprintf(str,"ID%d:TO\nB%3.1fBN%d",ParameterManager::machine_id,StatusManager::supply_voltage,StatusManager::MainBoard);
        sprintf(str_uart,"TimeOut");
        break;
        
    case -2:
        sprintf(str,"ID%dB%3.1f\nOERR",ParameterManager::machine_id,StatusManager::supply_voltage);
        
        sprintf(str_uart,"OERR");
        break;

    case -3:
        sprintf(str,"ID%dB%3.1f\nFERR",ParameterManager::machine_id,StatusManager::supply_voltage);
        sprintf(str_uart,"FERR");
        break;
 
    default:
    sprintf(str,"ID%dB%3.1f\n %d",ParameterManager::machine_id,StatusManager::supply_voltage, StatusManager::uart);
        break;
    }

    
    //sprintf(str,"ID%d EN: \n %s",ParameterManager::machine_id ,str_uart);
}
