
#include "mbed.h"
#include "comm.h"
#include "interface_manager.h"
#include "status_manager.h"
#include "parameter_manager.h"
#include "mode.h"
#include "normal_routine.h"

/* **mbedクラス** */
#ifdef LPC4088

#elif  STM32

#endif

/* **ローカル関数定義** */

/* **ローカル関数** */

/* **グルーバル関数** */

/* **クラス** */
class InterfaceManager;
//メンバ変数の初期化は、定義順（Ｗａｒｎｉｎｇになる）
ActMode::ActMode()
:mode(NORMAL_ROUTINE)
{    
}
 
void ActMode::run(void)
{
    selectMode();
        
}

void ActMode::selectMode(void)
{
    switch(InterfaceManager::button.getButtonStatus(MODE_SW)){
        case NORMAL_ROUTINE:
        normal_routine.run();
        break;
        
        case OPERATION_CHECK:
        operation_check.run();
        break;
       
        case PARAMETERS_SET:
        sprintf(str,"PARAMETERS_SET \nSW:%d%d%d%d",InterfaceManager::button.getButtonStatus(CROSS_UP),InterfaceManager::button.getButtonStatus(CROSS_DOWN),InterfaceManager::button.getButtonStatus(CROSS_LEFT),InterfaceManager::button.getButtonStatus(CROSS_RIGHT));
        InterfaceManager::i2c.setLCDMsg(str,sizeof(str));   
        break;
            
        default:
        sprintf(str,"NO MODE");
        InterfaceManager::i2c.setLCDMsg(str,sizeof(str));   
        break;
    }
   
    
}

