#include "mbed.h"
#include "DS1307.h"
#include "1wire.h"

DS1307 rtc(PTE0, PTE1);
OneWire ow(A4, A2, A3);

Serial pc(USBTX, USBRX, "pc");


int main() 
{
    Timer t;
    char c;

    pc.printf("\n\n\n\n*************************************\n");
    pc.printf("* r - reads the clock\n");
    pc.printf("* w - write the clock\n");
    pc.printf("* c - convert temperatures\n");
    pc.printf("* t - search 1wire and list read temperatures\n");
    pc.printf("*************************************\n\n");
    
    while (1) 
    {
        c = pc.getc();
        if (c == 'r') {
            //  perform read
            t.reset();
            t.start();
            time_t m_time = rtc.now();
            t.stop();

            struct tm *now;
            now = localtime(&m_time);
            
            pc.printf("Current time is %lu, %02d:%02d:%02d, %d.%d.%04d\n", 
                m_time, 
                now->tm_hour, now->tm_min, now->tm_sec, 
                now->tm_mday, now->tm_mon+1, now->tm_year+1900
            );
            pc.printf("Internal datetime format is %s\n", asctime(now));
            pc.printf("Read complete, elapsed %uus\n", t.read_us());
            
        }
        else if (c == 'w') {
            //  perform write
            int date, month, year, hours, minutes, seconds;
            pc.printf("Enter the date (date 1..31)\n"); pc.scanf("%d", &date);
            pc.printf("Enter the date (month 1..12)\n"); pc.scanf("%d", &month);
            pc.printf("Enter the date (year >2000)\n"); pc.scanf("%d", &year);
            pc.printf("Enter the time (hours 0..23)\n"); pc.scanf("%d", &hours);
            pc.printf("Enter the time (minutes 0..59)\n"); pc.scanf("%d", &minutes);
            pc.printf("Enter the time (seconds 0..59)\n"); pc.scanf("%d", &seconds);
            
            struct tm now = {seconds, minutes, hours, date, month-1, year-1900};
            time_t m_time = mktime(&now);
                
            t.reset();
            t.start();
            bool b = rtc.set_time(m_time);
            t.stop();
            
            pc.printf("Write complete (UNIX %lu, result %d), elapsed %uus\n", m_time, b, t.read_us());
        }
        else if (c == 'c') {
            ow.ConvertAll(true);
            pc.printf("Convert done\n");
        }
        else if (c == 't') {
            int result, temp;
            uint8_t rom[8];
            
            memset(rom, 0, sizeof(rom));
            result = ow.First(rom);
            while (result == OW_FOUND) {
                for (int i = 0; i < 8; i++) pc.printf("%.2X", rom[i]);
                
                t.reset();
                t.start();
                int b = ow.ReadTemperature(rom, &temp);
                t.stop();
                if (b) pc.printf(": read failed, code 0x%.4x, elapsed %uus\n", b, t.read_us());
                else pc.printf(": read ok, temperature %.2f'C, elapsed %uus\n", temp / 100., t.read_us());
                
                result = ow.Next(rom);
            }
            pc.printf("Done\n");
        }
        else {
            pc.printf("Syntax error\n");
        }
        pc.printf("\n");
    }
}
