#ifndef _1WIRE_H
#define _1WIRE_H

/* Dallas 1-wire driver with DS18B20 temperature sensor support
 *
 * Copyright (c) 2014 Ales Povalac, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

class OneWire
{
public:
    OneWire(PinName OwUp, PinName OwDn, PinName OwIn);

    void ConvertAll(bool wait);
    int ReadTemperature(uint8_t *ROMID, int *result);
    
    int First(uint8_t *ROMID);
    int Next(uint8_t *ROMID);

    void WriteByte(uint8_t data);
    uint8_t ReadByte(void);
    void SendCmd(uint8_t *ROMID, uint8_t cmd);
    void CRC(uint8_t x, uint8_t *crc);
    
private:
    DigitalOut _OwUp;
    DigitalOut _OwDn;
    DigitalIn _OwIn;

    uint8_t OW_LastDevice;
    uint8_t OW_LastDiscrepancy;
    uint8_t OW_LastFamilyDiscrepancy;

    int Reset(void);
    void WriteBit(int bit);
    int ReadBit(void);
};
        

/* INTERNAL CONSTANTS everything below this line */

#define ERR_BADCRC      0x8000
#define ERR_BADFAMILY   0x8001

/* Return codes for OWFirst()/OWNext() */
#define OW_BADWIRE      -3
#define OW_BADCRC       -2
#define OW_NOPRESENCE   -1
#define OW_NOMODULES    0
#define OW_FOUND        1

/* General 1 wire commands */
#define OW_SEARCH_ROM_CMD   0xF0
#define OW_READ_ROM_CMD     0x33
#define OW_MATCH_ROM_CMD    0x55
#define OW_SKIP_ROM_CMD     0xCC

/* DS1820 commands */
#define OW_CONVERT_T_CMD    0x44
#define OW_RD_SCR_CMD       0xBE
#define OW_WR_SCR_CMD       0x4E


/* 1-wire delays */
#define DELAY_A() wait_us(6)
#define DELAY_B() wait_us(64)
#define DELAY_C() wait_us(60)
#define DELAY_D() wait_us(10)
#define DELAY_E() wait_us(9)
#define DELAY_F() wait_us(55)
#define DELAY_G()
#define DELAY_H() wait_us(480)
#define DELAY_I() wait_us(70) 
#define DELAY_J() wait_us(410)

/* Other */
#define CONVERT_T_DELAY 750

#endif
