#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "Websocket.h"

extern "C" void mbed_mac_address(char *mac) 
{
    mac[0] = 0x00;
    mac[1] = 0x02;
    mac[2] = 0xF7;
    mac[3] = 0xFE;
    mac[4] = 0xEC;
    mac[5] = 0x85;
}

EthernetInterface eth;
Serial pc(USBTX, USBRX);
DigitalOut led(PTE26, 1);

bool command(TCPSocketConnection *client, Websocket *ws, char *cmd)
{
    if (strcmp(cmd, "help") == 0) {
        char s[] = "Napoveda s prikazy\r\nTak ruzne\r\n";
        client->send_all(s, strlen(s));
        return true;
    }
    else if (strcmp(cmd, "start") == 0) {
        led = 0;
        char s[] = "Zapnuto\r\n";
        client->send_all(s, strlen(s));
        return true;
    }
    else if (strcmp(cmd, "stop") == 0) {
        led = 1;
        char s[] = "Vypnuto\r\n";
        client->send_all(s, strlen(s));
        return true;
    }
    else if (strcmp(cmd, "exit") == 0) {
        return false;
    }
    else if (strcmp(cmd, "quit") == 0) {
        return false;
    }
    else if (strncmp(cmd, "ws ", 3) == 0) {
        char s[100];
        sprintf(s, "%s rika: '%s'", eth.getIPAddress(), &cmd[3]);
        ws->send(s);
        return true;
    }
    else {
        char s[] = "Neznamy prikaz\r\n";
        client->send_all(s, strlen(s));
        return true;
    }
}
    

int main (void) 
{
    char mac[6];
    pc.baud(115200);

    mbed_mac_address(mac);
    printf("MAC is %02x:%02x:%02x:%02x:%02x:%02x\r\n", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);

    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());
    
    TCPSocketServer server;
    server.bind(23);
    server.listen();
    
    while (true) {
        TCPSocketConnection client;
        server.accept(client);
        printf("Connection from: %s\n", client.get_address());

        char s1[] = "\e[2j\aInicializace WS...\r\n";
        char s2[] = "\aVitejte v programu, pro napovedu prosim help.\r\n";
        client.send_all(s1, strlen(s1));

        Websocket ws("ws://sockets.mbed.org/ws/mpoa/wo");
        ws.connect();
        
        client.send_all(s2, strlen(s2));
        
        char cmd[100];
        int pos = 0;
        bool quit = false;
        while (true) {
            char c;
            int n = client.receive(&c, 1);
            if (n <= 0) break;
            switch (c) {
                case 0x04: 
                    quit = true;
                    break;
                case 0x0A:
                    break;
                case 0x0D:
                    cmd[pos] = '\0';
                    quit = not command(&client, &ws, cmd);
                    pos = 0;
                    break;
                default:
                    cmd[pos++] = c;
                    break;
            }
            if (quit) break;
        }
        client.close();
        ws.close();
    }
}

