#include "mbed.h"
#include "rtos.h"
#include "DS1307.h"
#include "rtc.h"

DS1307 rtc(I2C_SDA, I2C_SCL);
Mutex rtc_mutex;

time_t get_rtc()
{
    rtc_mutex.lock();
    time_t m_time = rtc.now();
    rtc_mutex.unlock();
    set_time(m_time);
    return m_time;
}

bool set_rtc(time_t time)
{
    rtc_mutex.lock();
    bool b = rtc.set_time(time);
    rtc_mutex.unlock();
    set_time(time);
    return b;
}
