#include "mbed.h"
#include "rtos.h"
#include "1wire.h"
#include "sensor.h"
#include "sd.h"

uint8_t sensor_roms[MAX_SENSORS][8];
int16_t sensor_temps[MAX_SENSORS];
int sensor_count;

Mutex sensor_mutex;

void sensor_thread(void const *args)
{
    OneWire ow(A4, A2, A3);
    int result, temp;
    uint8_t rom[8];
    
    while (1) {
        ow.ConvertAll(false);
        Thread::wait(CONVERT_T_DELAY);

        sensor_mutex.lock();
        sensor_count = 0;
        memset(rom, 0, sizeof(rom));
        result = ow.First(rom);
        while (result == OW_FOUND && sensor_count < MAX_SENSORS) {
            if (ow.ReadTemperature(rom, &temp) == 0) {
                memcpy(sensor_roms[sensor_count], rom, sizeof(rom));
                sensor_temps[sensor_count] = temp;
                sensor_count++;
                
                int id = get_sensor_cfg(rom, NULL);
                log_temperature(id, temp);
            }
            result = ow.Next(rom);
        }
        sensor_mutex.unlock();
    }
}

