#include "mbed.h"
#include "mbed_debug.h"
#include "rtos.h"
#include "sensor.h"
#include "comm.h"
#include "sd.h"

DigitalOut ledR(LED_RED, 1);
DigitalOut ledG(LED_GREEN, 1);
//DigitalOut ledB(LED_BLUE, 1);

DigitalOut OUT1(D2, 0);
DigitalOut OUT2(D3, 0);
DigitalOut OUT3(D4, 0);
DigitalOut OUT4(D5, 0);

DigitalIn  IN1(D8, PullUp);
DigitalIn  IN2(D9, PullUp);

extern "C" void HardFault_Handler() 
{
    mbed_die();
}

int main(void)
{
    debug("\n\n\nEMIRv2 compiled " __DATE__ " " __TIME__ "\n");
    
    debug("Initializing SD... ");
    sd_init();

    debug("Starting threads... ");
    Thread sensor(sensor_thread, NULL, osPriorityNormal, DEFAULT_STACK_SIZE);
    Thread comm(comm_thread, NULL, osPriorityNormal, DEFAULT_STACK_SIZE);
    debug("done\n");

    OUT1 = 1;
    OUT2 = 1;
    OUT3 = 1;
    OUT4 = 1;
    wait(0.5);
    OUT1 = 0;
    OUT2 = 0;
    OUT3 = 0;
    OUT4 = 0;

    int i = 0;
    while (1) 
    {
        ledG = !ledG;
        Thread::wait(100);
        
        if (i++ >= 100) {
            write_config();
            i = 0;
        }
    }

}

