#include "mbed.h"
#include "rtos.h"
#include "USBSerial.h"
#include "rtc.h"
#include "sensor.h"
#include "comm.h"

void comm_thread(void const *args)
{
    USBSerial usb(0x1f00, 0x2012, 0x0001, false);
    Timer t;
    char c;
    
    while (1) 
    {
        c = usb.getc();

        if (c == 'r') {
            //  perform read
            t.reset();
            t.start();
            time_t m_time = get_rtc();
            t.stop();

            struct tm *now;
            now = localtime(&m_time);
            
            usb.printf("Current time is %lu, %02d:%02d:%02d, %d.%d.%04d\n", 
                m_time, 
                now->tm_hour, now->tm_min, now->tm_sec, 
                now->tm_mday, now->tm_mon+1, now->tm_year+1900
            );
            usb.printf("Internal datetime format is %s\n", asctime(now));
            usb.printf("Read complete, elapsed %uus\n", t.read_us());
            
        }
        else if (c == 'i') {
            //  perform read
            time_t m_time = time(NULL);

            struct tm *now;
            now = localtime(&m_time);
            
            usb.printf("Internal datetime format is %s\n", asctime(now));
        }
        else if (c == 'w') {
            //  perform write
            int date, month, year, hours, minutes, seconds;
            usb.printf("Enter the date (date 1..31)\n"); usb.scanf("%d", &date);
            usb.printf("Enter the date (month 1..12)\n"); usb.scanf("%d", &month);
            usb.printf("Enter the date (year >2000)\n"); usb.scanf("%d", &year);
            usb.printf("Enter the time (hours 0..23)\n"); usb.scanf("%d", &hours);
            usb.printf("Enter the time (minutes 0..59)\n"); usb.scanf("%d", &minutes);
            usb.printf("Enter the time (seconds 0..59)\n"); usb.scanf("%d", &seconds);
            
            struct tm now = {seconds, minutes, hours, date, month-1, year-1900};
            time_t m_time = mktime(&now);
                
            t.reset();
            t.start();
            bool b = set_rtc(m_time);
            t.stop();
            
            usb.printf("Write complete (UNIX %lu, result %d), elapsed %uus\n", m_time, b, t.read_us());
        }
        else if (c == 't') {
            sensor_mutex.lock();
            for (int j = 0; j < sensor_count; j++) {
                for (int i = 0; i < 8; i++) usb.printf("%.2X", sensor_roms[j][i]);
                usb.printf(": temperature %.2f'C\n", sensor_temps[j] / 100.);
            }
            sensor_mutex.unlock();
            usb.printf("Done\n");
        }
        else {
            usb.printf("Syntax error, use {r|i|w|t}\n");
        }

        usb.printf("\n");
    }
    
}

