/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __BLE_BUTTON_SERVICE_H__
#define __BLE_BUTTON_SERVICE_H__

class ButtonService
{
public:
    const static uint16_t BUTTON_SERVICE_UUID              = 0xA000;
    const static uint16_t BUTTON_STATE_CHARACTERISTIC_UUID = 0xA001;

    ButtonService(BLE &_ble, bool buttonPressedInitial) :
        ble(_ble), buttonState(BUTTON_STATE_CHARACTERISTIC_UUID,
                               (uint8_t []) {
        0,0
    },
    GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY) {
        GattCharacteristic *charTable[] = {&buttonState};
        GattService         buttonService(ButtonService::BUTTON_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.gattServer().addService(buttonService);
    }

    void updateButtonState(float roll, float pitch, float yaw, float gx, float gy, float gz) {
        uint8_t sensorValues[12] = {0};

        uint16_t rollValue = (uint16_t)roll;
        uint16_t pitchValue = (uint16_t)pitch;
        uint16_t yawValue = (uint16_t)yaw;

        uint16_t gxValue = (uint16_t)gx;
        uint16_t gyValue = (uint16_t)gy;
        uint16_t gzValue = (uint16_t)gz;
        sensorValues[0]= rollValue & 0xff;
        sensorValues[1]= (rollValue >> 8);

        sensorValues[2]= pitchValue & 0xff;
        sensorValues[3]= (pitchValue >> 8);

        sensorValues[4]= yawValue & 0xff;
        sensorValues[5]= (yawValue >> 8);

        sensorValues[6]= gxValue & 0xff;
        sensorValues[7]= (gxValue >> 8);

        sensorValues[8]= gyValue & 0xff;
        sensorValues[9]= (gyValue >> 8);

        sensorValues[10]= gzValue & 0xff;
        sensorValues[11]= (gzValue >> 8);

        ble.gattServer().write(buttonState.getValueHandle(), (uint8_t *)sensorValues, sizeof(sensorValues));
        //ble.updateCharacteristicValue(buttonState.getValueHandle(), (uint8_t *)v ,sizeof(v));
    }

private:
    BLE                              &ble;
    ReadOnlyArrayGattCharacteristic<uint8_t, sizeof(uint8_t[12])>  buttonState;
};

#endif /* #ifndef __BLE_BUTTON_SERVICE_H__ */
