#include "mbed.h"

DigitalOut myled(LED1);
DigitalIn giro(D2);
DigitalIn modo(D3);
AnalogIn pot(A0);
BusOut stepper(D5, D6, D7, D8);
Timer t1;
Timer t2;
int valbot1;
int valbot2;
int caso;
float pwm;
Serial pc (USBTX,USBRX);

int main() {
        valbot1 = 0;
        valbot2 = 0;
        myled = 0;
        wait(0.4);
        myled = 1;
        wait(0.4);
        float x;
        
        
        stepper = 8;
        wait(0.5);      
        t1.start();
        t2.start();
    while(1) {
        
        x= pot;
        pwm = ((x/0.004348)+20);
        
        if (t1.read() == 0) {
            t1.start();
        }
        if (t2.read() == 0) {
            t2.start();
        }
        
        switch (caso){ 
                
                case 1:
                if (stepper == 0) { //como el corrimiento de bits se fue a 0, ya no me sirve y los reinicio a 8 (osea 1000)
                    stepper = 8;
                }    
                break;
                
                case 2:
                if (stepper == 0) { // al igual que en el caso 1 pero ahora se inicializa en 1 (0001)
                    stepper = 1;   
                }
                break;
                
                case 3:
                if (stepper == 1) { //en este caso ya no llega a desaparecer el bit con (0000) pero cuando en vez de 2 bits se visualiza 1 solo (0001) ya es error y se coniverte en el requerido (1001)
                    stepper = 9;     
                }
                if (stepper == 4) { //aquí cuando hay un (0100 porque el corrimiento asi se llevo 1 bit este se convierte en (0110))
                    stepper = 12;    
                }             
                break;
                
                case 4:
                if (stepper == 8) {
                    stepper = 9;    
                }
                if (stepper == 2) {
                    stepper = 3;   
                }
                break;
            }
        
        pc.printf("%d \n",t1.read_ms()); // para checar la lectura si esta llegando al valor deseado y reiniciandose antes de entrar al if
        if (t1.read_ms() >= pwm ){
            switch (caso){ //abro un switch case dependiendo de las 4 combinaciones posibles de los 2 botones
                
                case 1:
                stepper = stepper >> 1; //hago un corrimiento hacia la derecha
                t1.reset();
                break;
                
                case 2:
                stepper = stepper << 1; //se hace un corrimiento hacia la izquierda
                t1.reset();
                break;
                
                case 3:           
                stepper = stepper >> 1; //corrimiento hacia la derecha
                t1.reset();
                break;
                
                case 4:
                stepper = stepper << 1; //corrimiento hacia la izquierda
                t1.reset(); // se pone el reset dentro de los case ya que sino se vera interrumpido por el break;
                break;
            }
                                        
                            
        }
            
            if (giro == 0){ // es cero porque es pullup
                valbot1 = !valbot1; //cambio de estado entre valbot1 y 2
            }
            if (modo == 0){
                valbot2 = !valbot2;
            }
       
            if (valbot1 ==0 && valbot2 == 0){
                
                caso = 1;
            } else if (valbot1 == 1 && valbot2 == 0){
                caso = 2;
            } else if (valbot1 == 0 && valbot2 == 1){
                caso = 3;
            } else if (valbot1 == 1 && valbot2 == 1){
                caso = 4;
            }
          
        
        }
    }  
    
