#include "LineFollower.h"
#include "mbed.h"
#include <stdint.h>

    /** Create a Line Follower interface for an IR Sensor Array
    *
    * @param ir1  IR Sensor 1
    * @param ir2  IR Sensor 2
    * @param ir3  IR Sensor 3
    * @param ir4  IR Sensor 4
    * @param ir5  IR Sensor 5
    * @param ir6  IR Sensor 6
    * @param ir7  IR Sensor 7
    * @param ir8  IR Sensor 8
    */   
    LineFollower::Linefollower(DigitalIn ir1, DigitalIn ir2, DigitalIn ir3, DigitalIn ir4,
                DigitalIn ir5, DigitalIn ir6, DigitalIn ir7, DigitalIn ir8):
                _ir1(ir1), _ir2(ir2), _ir3(ir3), _ir4(ir4), _ir5(ir5), _ir6(ir6),
                _ir7(ir7), _ir8(ir8){
                    
        array[0] = _ir1;
        array[1] = _ir2;
        array[2] = _ir3;
        array[3] = _ir4;
        array[4] = _ir5;
        array[5] = _ir6;
        array[6] = _ir7;
        array[7] = _ir8;
    }
                
                
    /** Read the value of a LineFollower object
    * 
    * @return The value of the Sensor
    */                    
    uint8_t LineFollower::read(){
        uint8_t binary = 0;
        int multi = 1;
        for(int i=0; i<8; i++){
               binary += array[i]*multi;
               multi = multi*2;
        }
        return binary;
    }
    
    /** Follow a line
    * 
    * @param    l left drive motor
    * @param    r  right drive motor
    */                    
    void followLine(Motor l, Motor r){
           int count = 0;
           for(int i = 0; i<8; i++){
                count += array[i];  
            }
            
            switch(count){
                
                case 1: if(this->read() == 0b10000000){
                            l.speed(-(0.75 * MAXSPEED));
                            r.speed(MAXSPEED);
                        }
                        else if(this->read() == 0b00000001){
                            l.speed(MAXSPEED);
                            r.speed(-(0.75 * MAXSPEED));
                        }
                        break;
                        
                case 2: if(this->read() == 0b00011000){
                            l.speed(MAXSPEED);
                            r.speed(MAXSPEED);
                        }
                        else if(this->read() == 0b11000000){
                            l.speed(-(0.5 * MAXSPEED));
                            r.speed(MAXSPEED);
                        }
                        else if(this->read() == 0b00000011){
                            l.speed(MAXSPEED);
                            r.speed(-(0.5 * MAXSPEED));
                        }
                        else if(this->read() == 0b01100000){
                            l.speed(0);
                            r.speed(MAXSPEED);
                        }
                        else if(this->read() == 0b00000110){
                            l.speed(MAXSPEED);
                            r.speed(0);
                        }
                        else if(this->read() == 0b00110000){
                            l.speed(0.5*MAXSPEED);
                            r.speed(MAXSPEED);
                        }
                        else if(this->read() == 0b00001100){
                            l.speed(MAXSPEED);
                            r.speed(0.5*MAXSPEED);
                        }
                        break;
                        
                case 3: if(this->read() == 0b11100000){
                            l.speed(-(0.25*MAXSPEED));
                            r.speed(MAXSPEED);
                        }
                        else if(this->read() == 0b00000111){
                            l.speed(MAXSPEED);
                            r.speed(-(0.25*MAXSPEED));
                        }
                        else if(this->read() == 0b01110000){
                            l.speed(0.25*MAXSPEED);
                            r.speed(MAXSPEED);
                        }
                        else if(this->read() == 0b00001110){
                            l.speed(MAXSPEED);
                            r.speed(0.25*MAXSPEED);
                        }
                        else if(this->read() == 0b00111000){
                            l.speed(0.5*MAXSPEED);
                            r.speed(MAXSPEED);
                        }
                        else if(this->read() == 0b00011100){
                            l.speed(MAXSPEED);
                            r.speed(0.5*MAXSPEED);
                        }
                        break
              default:  break;
            }
        
    }