/* This is a mbed program for EE202A, hm1. written by Yujing Qian's team
   Main idea:
   Use interrupt to change the default configuration of the analog output.
   The corresponding GUI is Analog_outpt_control.py
   All the commented-out code is for debugging use, please ignore them 
   Author: Yujing Qian, Tianlei Tang                      Feb.12/2014
*/
#include "mbed.h"
#include "math.h"
#define BUFFER_SIZE 20
#define PI 3.14159265359

AnalogOut analogout(PTE30);
Serial pc(USBTX,USBRX);

bool received;
int buff = 0;
char rx_buffer[BUFFER_SIZE]; 
void receive_handler(){
    while (pc.readable() && buff< BUFFER_SIZE){
        rx_buffer[buff] = pc.getc();
        if (rx_buffer[buff] == '#'){
            rx_buffer[buff] = '\0';
            /*
            rx_buffer[12] = '\0';
            buff=13;
            rx_buffer[0]=0;
            rx_buffer[1]=0;
            int tag=16;
            char* testx=(char*)&(tag);
            rx_buffer[2]=(*testx);
            rx_buffer[3]=0;
            rx_buffer[4]=0;
            rx_buffer[5]=0;
            tag=32;
            testx=(char*)&(tag);
            rx_buffer[6]=(*testx);
            rx_buffer[7]=0;           
            rx_buffer[8]=0;
            rx_buffer[9]=0;
            tag=16;
            testx=(char*)&(tag);
            rx_buffer[10]=(*testx);
            rx_buffer[11]=0;
            */
            buff++;
            received = true; 
            //pc.printf("done!");
            break;
        }
        buff++;
    }
    return;
}





int main() {
 pc.baud(9600);
pc.attach(&receive_handler,Serial::RxIrq); 
 //set interrupt
float freq=0.25;
float amp=0.5; 
float bias=0.5;
int *read;
char* select;
int count=0;
     while (true) { 
     if (received) {
         //pc.printf("yeah");
         select=rx_buffer;
         read=(int*)select;
         amp=read[0]/10000.0;
         freq=read[1]/10000.0;
         bias=read[2]/10000.0;
         buff=0;
         received=false;}
     //float tmp;
     for(count=0; count<120; count++){
         analogout.write(amp*(sin(2*PI*count/120.0))+bias);
        // tmp=amp*(sin(2*PI*count/120.0))+bias;
       // pc.printf("ans=%f\n",tmp);
         wait((1/(120.0*freq)));
         }//one cirle
     
     }
}

 