/* This is a mbed program for EE202A, hm1. written by Yujing Qian's team
 Main idea:
 Use interrupt to change the default configuration of the device and choose different channels and different sampling rate.
 The corresponding GUI is host_command.py
 All the commented-out code is for debugging use, please ignore them
 Author: Yujing Qian, Tianlei Tang                      Feb.12/2014
 */
#include "mbed.h"
#include "MMA8451Q.h"
#include "MAG3110.h"
#include "TSISensor.h"
#define MMA8451_I2C_ADDRESS (0x1d<<1)
#define BUFFER_SIZE 200
#define BAUDRATE 9600

AnalogIn lightsensor(PTE22);
AnalogIn analoginput(PTB0);
Serial pc(USBTX,USBRX);
char rx_buffer[BUFFER_SIZE];
int buff=0;
bool received;
Timer timer;
 
void receive_handler(){
    while (pc.readable() && buff< BUFFER_SIZE){

        rx_buffer[buff] = pc.getc();
        //pc.printf(& rx_buffer[buff]);
        if (rx_buffer[buff] == '#'){
            rx_buffer[buff] = '\0';
            /*
            rx_buffer[14] = '\0';
            int tag=1;
            char *testx=(char*)&tag;
            buff=14;
            rx_buffer[0]=(*testx);
            tag=3;
            testx=(char*)&tag;
            rx_buffer[1]=(*testx);
            rx_buffer[2]=0;
            rx_buffer[3]=0;
            rx_buffer[4]=0;
            tag=100;
            testx=(char*)&tag;
            rx_buffer[5]=(*testx);
            rx_buffer[6]=0;
            rx_buffer[7]=0;
            rx_buffer[8]=0;
            tag=100;
            testx=(char*)&(tag);
            rx_buffer[9]=(*testx);
            rx_buffer[10]=0;
            rx_buffer[11]=0;
            rx_buffer[12]=0;
            tag=100;
            testx=(char*)&(tag);
            rx_buffer[13]=(*testx);
            */
           //pc.printf(rx_buffer);pc.printf("\n");
            //pc.printf("testmode_loaded\n");
            received = true; 
            //pc.printf("received=%d\n",received);
            break;
        }
        buff++;
    }
    return;
}

int main() {
buff = 0;
received=false;
 pc.baud(BAUDRATE);
 //pc.printf("hello to the magic world\n");
 //pc.printf("minimumnum=%f\n",1.0/BAUDRATE);
 
 //set interrupt
 MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
 MAG3110 mag(PTE25, PTE24);
 TSISensor tsi;
 //int aaattt=0;
int accx,accy,accz;
int magx,magy,magz;
int light;
int tsiPerc;
int tsiDis;
int analogin;
char* select;
int enable=32767;
int tmpf=0;
int i,j;
int interval[15];
int count[15];
int tmptime;
for(i=0;i<15;i++)interval[i]=1000;//default:1ms
for(i=0;i<15;i++)count[i]=0;
bool output_en=0;
char *tmp;
//int fl2in;
char* output;
output=new char;
pc.attach(&receive_handler,Serial::RxIrq);
//pc.printf("enable=%d",enable); 
timer.start();
tmptime=timer.read_us();
for(i=0;i<15;i++)count[i]=tmptime;
//pc.printf("time_written");  
       
     while (true) { 
     if (received) {
         select=rx_buffer;
         //pc.printf("command=");
         //pc.printf(select);
         //pc.printf("\n");
         enable=0;
         enable=(int)(select[1]<<8)+(int)select[0];//record the command
         
         i=2;
         int k=15;//indicate which channel
         while(i<buff){
            tmpf=0;
            for( j=0;j<4;j++){
             tmpf=(tmpf<<8)|select[i+j];  
            }
            while(!((enable>>(15-k))&1)){
                k=k-1;
                }
                k=k-1;
 
            interval[14-k]=1000000/tmpf;//interval us per sample
            i=i+4;
         }
         //for (i=0;i<15;i++)count[i]=0;
         
         //for(int o=0;o<15;o++){pc.printf("count=%d",count[o]);pc.printf("interval=%d\n",interval[o]);}
         //pc.printf("enable=%d\n",enable&1);
         //pc.putc('$');pc.putc('c');pc.putc('d');pc.putc('_');pc.putc('r');pc.putc('v');pc.putc('d');
         buff=0;
         tmptime=timer.read_us();
         for(i=0;i<15;i++)count[i]=tmptime;
         received=false;
         //pc.printf("command,received\n");
         }
     int output_map=0;
     output_en=false;
     

         
     int opt=0;
//pc.printf("nscanning\n");
//for(int o=0;o<15;o++){pc.printf("count=%d",count[o]);pc.printf("interval=%d\n",interval[o]);}
//pc.getc();
     if((enable&(1))&&(timer.read_us()>=(count[0]+interval[0]))){
         count[0]=timer.read_us();
         output_map=output_map|(1);
         output_en=true;//output
         light=(int)(lightsensor.read()*10000);
         tmp=(char*)&light;//pc.printf("opt=%d",opt);
         output[opt]=(*(tmp+3));
         output[opt+1]=(*(tmp+2));
         output[opt+2]=(*(tmp+1));
         output[opt+3]=(*tmp);
         
         opt=opt+4; }
     //else count[0]++;    
          
     //light sensor
     if((enable&(1<<1))&&(timer.read_us()>=(count[1]+interval[1]))){
         count[1]=timer.read_us();
         output_map=output_map|(1<<1);
         output_en=true;//output
         accx=(int)(acc.getAccX()*10000);
         tmp=(char*)&accx;//pc.printf("opt=%d",opt);
         output[opt]=(*(tmp+3));
         output[opt+1]=(*(tmp+2));
         output[opt+2]=(*(tmp+1));
         output[opt+3]=(*tmp);
         opt=opt+4;}
     //else count[1]++;    
     //accx  

     if((enable&(1<<2))&&(timer.read_us()>=(count[2]+interval[2]))){
         count[2]=timer.read_us();
         output_map=output_map|(1<<2);
         output_en=true;//output
         accy=(int)(acc.getAccY()*10000);
         tmp=(char*)&accy;//pc.printf("opt=%d",opt);
         output[opt]=(*(tmp+3));
         output[opt+1]=(*(tmp+2));
         output[opt+2]=(*(tmp+1));
         output[opt+3]=(*tmp);
         
         opt=opt+4;} 
    // else count[2]++;   
     //accy 
     if((enable&(1<<3))&&(timer.read_us()>=(count[3]+interval[3]))){
         count[3]=timer.read_us();
         output_map=output_map|(1<<3);
         output_en=true;//output
         accz=(int)(acc.getAccZ()*10000);
         tmp=(char*)&accz;//pc.printf("grav=%float",accz);
         output[opt]=(*(tmp+3));
         output[opt+1]=(*(tmp+2));
         output[opt+2]=(*(tmp+1));
         output[opt+3]=(*tmp);
         opt=opt+4;}
    //else count[3]++;      
     //accz
     if((enable&(1<<4))&&(timer.read_us()>=(count[4]+interval[4]))){
         count[4]=timer.read_us();
         output_map=output_map|(1<<4);
         output_en=true;//output
         magx=(int)(mag.getX()*10000);
         tmp=(char*)&magx;//pc.printf("opt=%d",opt);
         output[opt]=(*(tmp+3));
         output[opt+1]=(*(tmp+2));
         output[opt+2]=(*(tmp+1));
         output[opt+3]=(*tmp);
         //count[4]=1;
         opt=opt+4;}
    // else count[4]++;    
     //magx  
     if((enable&(1<<5))&&(timer.read_us()>=(count[5]+interval[5]))){
         count[5]=timer.read_us();
         output_map=output_map|(1<<5);
         output_en=true;//output
         magy=(int)(mag.getY()*10000);
         tmp=(char*)&magy;//pc.printf("opt=%d",opt);
         output[opt]=(*(tmp+3));
         output[opt+1]=(*(tmp+2));
         output[opt+2]=(*(tmp+1));
         output[opt+3]=(*tmp);
         //count[5]=1;
         opt=opt+4;} 
         //else count[5]++;   
     //magy 
     if((enable&(1<<6))&&(timer.read_us()>=(count[6]+interval[6]))){
         count[6]=timer.read_us();
         output_map=output_map|(1<<6);
         magz=(int)(mag.getZ()*10000);
         output_en=true;//output
         tmp=(char*)&magz;//pc.printf("7");
         output[opt]=(*(tmp+3));
         output[opt+1]=(*(tmp+2));
         output[opt+2]=(*(tmp+1));
         output[opt+3]=(*tmp);
         opt=opt+4;}
         //else count[6]++;             
     //magz 
     if((enable&(1<<7))&&(timer.read_us()>=(count[7]+interval[7]))){
         count[7]=timer.read_us();
         output_map=output_map|(1<<7);
         tsiPerc=(int)(tsi.readPercentage()*10000); 
         output_en=true;//output
         tmp=(char*)&tsiPerc;//pc.printf("7");
         output[opt]=(*(tmp+3));
         output[opt+1]=(*(tmp+2));
         output[opt+2]=(*(tmp+1));
         output[opt+3]=(*tmp);
         //count[7]=1;
         opt=opt+4;}
         //else count[7]++;             
     //TIS_perc
     if((enable&(1<<8))&&(timer.read_us()>=(count[8]+interval[8]))){
         count[8]=timer.read_us();
         output_map=output_map|(1<<8);
         tsiDis=(int)(tsi.readDistance()*10000); 
         output_en=true;//output
         tmp=(char*)&tsiDis;//pc.printf("8");
         output[opt]=(*(tmp+3));
         output[opt+1]=(*(tmp+2));
         output[opt+2]=(*(tmp+1));
         output[opt+3]=(*tmp);
         //count[8]=1;
         opt=opt+4;}
         //else count[8]++;             
     //TIS_perc     
     //touchs1=touch1.read();
     //touchs2=touch2.read();
     
     if((enable&(1<<9))&&(timer.read_us()>=(count[9]+interval[9]))){
         count[9]=timer.read_us();
         output_map=output_map|(1<<9);
         analogin=(int)(analoginput.read()*10000);
         output_en=true;//output
         tmp=(char*)&analogin;//pc.printf("opt=%d",opt);
         output[opt]=(*(tmp+3));
         output[opt+1]=(*(tmp+2));
         output[opt+2]=(*(tmp+1));
         output[opt+3]=(*tmp);
         //count[9]=1;
         opt=opt+4;}
     //else count[9]++;      

     
     //analog channel 1#
     //----------OUTPUT----------
      if(output_en){
        //aaattt++;
        //if(aaattt==960){pc.printf("get960");aaattt=1;}
        //pc.printf("ok\n");
        //pc.printf("map=%d",output_map);
        pc.putc('#');//begin of a data
        //for(int o=0;o<15;o++)pc.printf("a=%d\n",output_map&(1<<o));
        
        //pc.printf(output);
        
        tmp=(char*)&output_map;
        pc.putc(*(tmp));
        pc.putc(*(tmp+1));
        for (int l=0;l<opt;l++) pc.putc(output[l]);
        
        /*
        pc.printf("\n");
        pc.printf("c0=%d",count[0]);pc.printf("c1=%d",count[1]);pc.printf("c9=%d",count[9]);
        pc.printf("time=%d\n",timer.read_us());
        pc.printf("translate=%d",(int)(*(tmp+1)));
        pc.printf("translate=%d",(int)(*(tmp)));
        pc.printf("\n");
        int inttmp;
        for (i=0;i<8;i++){
            inttmp=0;
            for(int k=0;k<4;k++){
                inttmp=(inttmp<<8);
                inttmp+=((int)(output[4*i+k]));
                }
            pc.printf("output=%d\n",inttmp);
            }
        
        */
        
        //
       // pc.printf("finish\n");
      }   
     //pc.printf("ck=%d",count[0]);
     //wait_us(1000000/BAUDRATE);
     } 

}
