#include "mbed.h"
#include "platform/mbed_thread.h"
#include "UserButton.h"
#include "sMotor.h" 
#include "lis3mdl_class.h"
#include "QuadDisplay2.h"

/****************************************************************
*                           Definitions 
****************************************************************/

// Blinking rate in milliseconds
#define step_speed 1500
#define POINTS 1
#define M_PI 3.14159265358979323846
#define RADIAN M_PI/180.0

/****************************************************************
*                          Prototypes   
*****************************************************************/

void Ini();
void HowManyClicks();
void proximityR_isr();
void proximityF_isr();
//-----------------------
void polling_sensors_isr();
void sensors_task();
void FrameTimeoutCW_isr();
void FrameTimeoutCCW_isr();
void BounceTimeoutCW_isr();
void BounceTimeoutCCW_isr();
void CW_switch_isr();
void CCW_switch_isr();
//-----------------------
//void clk_speed_isr();
/*****************************************************************
*                           Interface
******************************************************************/

DigitalOut led1(LED1);
InterruptIn CW_switch(D10);
InterruptIn CCW_switch(D11);
//---
RawSerial pc(USBTX, USBRX);
DevI2C devI2c(D14,D15);
LIS3MDL magnetometer(&devI2c,LIS3MDL_M_MEMS_ADDRESS_LOW);
DigitalOut led2(A0);
SPI spi(D4, D5, D3);
QuadDisplayMy display(&spi,D6);
//---
sMotor motor(A5, A4, A3, A2); // creates new stepper motor: IN1, IN2, IN3, IN4
InterruptIn BlueBatton(USER_BUTTON);

/*****************************************************************
 *                            Time
******************************************************************/
Ticker polling_sensors;
//Ticker clk_speed;
Timeout FrameTimeoutCW;
Timeout BounceTimeoutCW;
Timeout FrameTimeoutCCW;
Timeout BounceTimeoutCCW;

/****************************************************************
*                           Threads  
****************************************************************/
Thread sensor_daemon;

/*****************************************************************
*                             Global variables
******************************************************************/


//----------------
uint8_t button_event;
uint8_t mode=0;
uint8_t RotateDir;
uint16_t RotateSpeed;

//----------------
uint8_t SensorsEn=1;

int16_t M[3];
uint8_t point;
uint32_t rotate_cnt;
//---------
uint8_t DebounceCW=0;
uint8_t cntCW=0;
uint8_t NewCWMode=0;
uint8_t DebounceCCW=0;
uint8_t cntCCW=0;
uint8_t NewCCWMode=0;
//------------------

/******************************************************************
 *                              Main 
******************************************************************/
int main()
{
    // Initialise the digital pin LED1 as an output
    
    Ini();
    
    while (true) {
        //led = !led;
        HowManyClicks();
        if (mode){
            
        }
        if (point){
            motor.step(POINTS, RotateDir, RotateSpeed);
        }else
           wait_us(step_speed);
             
        //thread_sleep_for(BLINKING_RATE_MS);
    }
}

/**********************************************************
*                              Functions  
***********************************************************/
void Ini()
{
 pc.baud(115200);
 ButtonIni(&BlueBatton);
 //button_event_ind=button_event=0;
 
 
//--------------

sensor_daemon.start(sensors_task);
SensorsEn=1;
polling_sensors.attach(&polling_sensors_isr, 0.4);
//clk_speed.attach(&clk_speed_isr, 0.01);
mode=0;
point=0;
RotateSpeed=step_speed;
rotate_cnt=0;
CW_switch.fall(&CW_switch_isr);
CCW_switch.fall(&CCW_switch_isr);
}

//------------------
void HowManyClicks()
{
    WhatButtonMode(&button_event);
    if(button_event) {
        switch (button_event) {
            case 1:
                mode=0;
                point=0;
                break;
            case 2:
                mode=1;
                point=1;
                RotateDir=0;
                RotateSpeed=step_speed;
                break;                    
            case 3:
                mode=2;
                point=0;
                //RotateDir=0;
                //RotateSpeed=step_speed;
                break;
            case 4:
                mode=3;
                point=0;
                //RotateDir=1;
                //RotateSpeed=step_speed;
                break;
            case 5:
                mode=4;
                point=0;
                //RotateSpeed=step_speed*2;
                //RotateDir=0;
                break;
            case 6:
                mode=5; 
                point=1;
                RotateSpeed=step_speed*2;
                RotateDir=1; 
                break;
             case 7:
                
                break;               
                
            default:
                break;                                                                                                   
        }     
        button_event=0;            
    }  
}

//-----------------
void sensors_task()
{
 int status;
 char text[5];
 int32_t dif; 
 
    while (true) {
        ThisThread::flags_wait_any(0x1,true);
        SensorsEn=0;                 
        
        switch(mode){
            case 0:
               // sprintf(text,"c%3d",distance_c);  
                break;
            case 1:
                //sprintf(text,"l%3d", distance_l);                        
                break;  
            case 2:      
                //sprintf(text,"r%3d", distance_r);
                break;    
            case 3:
                    
                break;   
            case 4:      
                //sprintf(text,"%d",G[0]);
                break;
            case 5:      
                //sprintf(text,"%d",dur_time);
                break;                 
            default: 
                sprintf(text,"----");                    
                break;                      
        }                         
        SensorsEn=1;
   }         
}

/**********************************************************
*                    Interrupt Service Routines 
***********************************************************/
void FrameTimeoutCW_isr()
{
    NewCWMode=cnt;
    cntCW=0;                   
}

//---------------------
void BounceTimeoutCW_isr()
{
  DebounceCW=0;
  
}  

void FrameTimeoutCCW_isr()
{
    NewCCWMode=cnt;
    cntCCW=0;                   
}

//---------------------
void BounceTimeoutCCW_isr()
{
  DebounceCCW=0;
  
}      
//---------------------
void polling_sensors_isr()
{
 if (SensorsEn){
    sensor_daemon.flags_set(0x1);
    led1 = !led1; 
 }    
}
void CW_switch_isr()
{
     if(DebounceCW==0){
        DebounceCW=1;
        cntCW++;
        FrameTimeoutCW.detach();
        FrameTimeoutCW.attach(FrameTimeoutCW_isr,1.0);          
        BounceTimeoutCW.attach(BounceTimeoutCW_isr,0.2);
    }
}
void CCW_switch_isr()
{
     if(DebounceCCW==0){
        DebounceCCW=1;
        cntCCW++;
        FrameTimeoutCCW.detach();
        FrameTimeoutCCW.attach(FrameTimeoutCCW_isr,1.0);          
        BounceTimeoutCCW.attach(BounceTimeoutCCW_isr,0.2);
    }
}
//---------------------------------
/*void clk_speed_isr()
{
    rotate_cnt++; 
    if (rotate_cnt>10)
        dur_time_en=1;
}*/
