#include "mbed.h"
#include "lut.h"

SPI spi(p11, p12, p13);
DigitalOut latchpin(p10);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
InterruptIn hall(p7);

#define LEDS 96
#define MAX_BRIGHTNESS 4095

void HSVtoRGB( int  *r, int *g,int *b, int h, int s, int v );


void hall_fall() {
    led1 = 1;
}

void hall_rise() {
    led1 = 0;
}

void latch() {
    latchpin = 1;
    latchpin = 1;
    latchpin = 1;
    latchpin = 1;
    latchpin = 1;
    latchpin = 1;
    latchpin = 0;
}

int main() {
    // When magnet goes near Hall-effect sensor, its output will go LOW
    hall.fall(&hall_fall);
    hall.rise(&hall_rise);

    spi.format(12, 0);
    spi.frequency(16 * 1000 * 1000);

    int brightness = 0;
    int dir = 0;
    int r, g, b;

    latchpin = 0;
    while (1) {
        for (int h = 3599; h >= 0; h--) {
            for (int i = LEDS-1; i >= 0; i--) {
                HSVtoRGB(&r, &g, &b, h + i*150/4, 4095, brightness / 4);

                spi.write(gamma[b]);
                spi.write(gamma[g]);
                spi.write(gamma[r]);
            }
            latch();

            if (dir == 0) {
                brightness += 1;
                if (brightness >= 4096) {
                    brightness = 4095;
                    dir = 1;
                }
            } else {
                brightness -= 1;
                if (brightness < 0) {
                    brightness = 0;
                    dir = 0;
                }
            }
        }
    }
}

void HSVtoRGB( int  *r, int *g,int *b, int h, int s, int v ) {
    int f;
    int p, q, t;

    if ( s == 0 ) {
        *r = *g = *b = v;
        return;
    }

    h = h % 3600;

    f = ((h%600)*4095)/600;
    h /= 600;

    p = (v * (4096-s))/4096;
    q = (v * (4096 - (s*f)/4096))/4096;
    t = (v * (4096 - (s*(4096-f))/4096))/4096;

    switch ( h ) {
        case 0:
            *r = v;
            *g = t;
            *b = p;
            break;
        case 1:
            *r = q;
            *g = v;
            *b = p;
            break;
        case 2:
            *r = p;
            *g = v;
            *b = t;
            break;
        case 3:
            *r = p;
            *g = q;
            *b = v;
            break;
        case 4:
            *r = t;
            *g = p;
            *b = v;
            break;
        default:        // case 5:
            *r = v;
            *g = p;
            *b = q;
            break;
    }
}