/*
*   LPC812HandsOn
*   Allan K Liu
*   2013-11-27
*
*   Works on LPC812MAX (with hardware modification), LPC812MiniKit
*   
*   LPC812MAX/mBed
*   Direct download, change SJ1/SJ4
*
*   LPC812MiniKit
*   P04/P00 as TX/RX, as same as bootloader does, Use Flash Magic to download.
*   Before download, use BIN2HEX (from Keil) to convert binary to hex format
*   You may rename your *.bin to standard DOS 8+3 file name format before bin2hex.
*   
*   mBed/LPC812MAX uses IRC 12MHz, PLL to 24MHz
*   LPC812MiniKit uses external 12MHz, PLL to 24MHz
*
*   So code built for MAX can run in MiniKit.
*/
#include "mbed.h"
#include "Serial.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);

Serial pc(P0_4, P0_0); // tx, rx

void setup(){
    pc.baud(57600);
    pc.printf("\r\nLPC812 Mini-Kit\r\n");
}

void loop(){
    while(1) {
        myled1 = 1;
        wait(0.2);
        myled1 = 0;
        wait(0.2);
    }
}

int main() {
    setup();
    loop();
}

