#include "mbed.h"
#include "ssd1606.h"
#include "_24LCXXX.h"
#include "rom_image.h"
//#include "eeprom.h"

// Check mbed LPC1114 LPCXpresso board at mbed.org
//  http://mbed.org/users/okano/notebook/pinout-picture/
// Check LPCXpresso LPC1114 schematics at embeddedartists.com
//  http://www.embeddedartists.com/sites/default/files/docs/schematics/LPCXpressoLPC1114revA.pdf

// WARNING: xp5/xp6/xp7 (P0_9/P0_8/P2_11) are reserved for SPI
// Check source code at github.com
//  https://github.com/mbedmicro/mbed/blob/master/libraries/mbed/targets/hal/TARGET_NXP/TARGET_LPC11XX_11CXX/spi_api.c

// In LPC1114FN28, SPI uses dp2/dp1/dp6 (P0_9/P0_8/P0_6) with different SCK pin

// naked LPC1114 on breadboard, install LED pin28, pasive piezo-buzzer pin1
DigitalOut myled(dp28);  // LED ... P0_7 (pin 28)
Serial uart(dp16, dp15); // UART .. P1_7: TX (pin 16), P1_6: RX (pin 15)
//PwmOut pwm(dp1);         // PWM ... P0_8: CT16B0_MAT0 (pin1); sorry, blocking SPI!  

// EPD interface: CS | RST | DC | BUSY | MOSI | SCK
// Consider move P2_3 & P2_1 (xp37, xp13) for MOSI & SCK as 2nd SPI
// Don't follow schematics from EA, since its silkscreen is wrong for SPI1
//SSD1606 epd(P0_6,P0_7,P2_0,P1_5,P2_3,P2_1);
SSD1606 epd(P0_6,P2_2,P2_0,P1_5,P2_3,P2_1);

//SSD1606 epd(P0_6,P0_7,P2_0,P1_5,P1_11,P1_10);
//SSD1606 epd2(xp23,xp11,xp12,xp21,xp38,xp39);


I2C i2c(xp42, xp41);    // I2C ... P0_5: SDA, P0_4: SCL
_24LCXXX nvmem(&i2c, 0x50);

//enum EEPROM::TypeEeprom T24C256;
//EEPROM nvmem(P0_5,P0_4,0xA0,T24C256);

char c = '0';
unsigned char sbuf[128];

void setup()
{
    
  //pwm.period(0.001);  // PWM period 1ms (1kHz)   
  uart.baud(115200);  // Baud rate
  //uart.puts("E-Badge MiniNote LPC1114 Demo Start.\n\r");
    //nvmem.write(0x10,0x55);
    epd.reset();
    epd.initialize();
    epd.rom_image(gImage_one);
    epd.set_command_between_images();
    wait(5);
    epd.rom_image(gImage_sushi);
    epd.set_command_between_images();
    wait(5);

    nvmem.byte_write(0,1);
    nvmem.byte_write(1,2);
    nvmem.byte_write(2,3);
    nvmem.byte_write(3,4);
    nvmem.nbyte_read(0x00,sbuf,16);


}

void loop()
{
    /*
    myled = 0;  // LED on
    //pwm = 0.5;  // PWM duty cycle 50%, tone 1kHz
    wait(0.5);
    uart.putc(c++); if (c > '9') c = '0';  // Put Character & rotate 0,1,2,... 9
    myled = 1;  // LED off
    //pwm = 0;    // PWM stop, silent
    wait(0.5);
    */
    uart.putc(c++); if (c > '9') c = '0';  // Put Character & rotate 0,1,2,... 9
}

int main() {
    
    setup();
  while(1) {    // repeat (period 1sec)
        loop();
    }
}
