#ifndef __SSD1606_H__
#define __SSD1606_H__

#include "mbed.h"
#define MODE1

/*
    The width/height parameters depend on different vendor. The max is 180x128
    http://www.solomon-systech.com.cn/cn/product/advanced-display/bistable-display-driver-controller/
 */
#define SSD1606_WIDTH 172
#define SSD1606_HEIGHT 72

#define GREY_BPP            2   // [1:2], 1bpp or 2bpp

#define COLBUF_SIZE     (SSD1606_HEIGHT / 8 * GREY_BPP) // 72/8*2=18 Byte for 2bpp
#define FRAMEBUF_SIZE   (SSD1606_WIDTH * COLBUF_SIZE)   // 172 * 18 = 3096B

#define IRAM_8KB

#define ROM2BPP_SIZE    3096
#define ROM1BPP_SIZE    1548

//ROM IMAGE INDEX
#define PIC_ONE                 1
#define PIC_NOKIA               2
#define PIC_SUNING          3
#define PIC_SUSHI           4
#define PIC_20OFF           5
#define PIC_CHESSBOARD  6
#define PIC_ROYALTY         7
#define PIC_FU                  8
#define PIC_GC4                 9
#define PIC_SAVE                10
#define PIC_RUSSIAN         11
#define PIC_COMPANY         12
#define PIC_KOREAN          13
#define PIC_OED                 14
#define PIC_OEDBOOK         15
#define PIC_JAPANESE        16
#define PIC_RECT                17

//FUNCTION IMAGE INDEX
#define TEST_GREY1          1
#define TEST_GREY2          2
#define TEST_BLK                3
#define TEST_WHT                4
#define TEST_HALF               5
#define TEST_STRIP1         6
#define TEST_STRIP2         7

#define SPI_BUS_DELAY       5

class SSD1606
{
    public:
        SSD1606(PinName cs, PinName rst, PinName dc, PinName busy, PinName data, PinName clk);
        void reset();
        void initialize();
        void update();
        void off();
        void on();
        void deepsleep();
        void sleep();
        void wake();
        void set_inverse();
        void set_lut();
        void set_command_between_images();
        void set_display_start_line(unsigned char val);
        void nop();
        void set_charge_pump_enable(unsigned char enable);
        void clear();
        void set_pixel(int x, int y);
        void clear_pixel(int x, int y);
        void set_font(unsigned char *font, unsigned char width);
        void set_double_height_text(unsigned int double_height);
        void putc(unsigned char c);
        void printf(const char *format,...);
        void read_busy(void);
        void rom_image(const unsigned char *bitmap);
        void test_image(unsigned char idx);
        
    private:
        //SPI &_mspi;   //Software SPI used
        DigitalOut _cs, _reset, _dc;        
        DigitalIn _busy;
        DigitalOut _data, _clk;
        //unsigned char _screen[3096];
        unsigned char _screen[1548];
        //unsigned char _buf[128];
    int _cursor_x, _cursor_y;

    void _send_command(unsigned char code);
    void _send_data(unsigned char value);
        void _send_data_1bpp(unsigned char value);
        void _vspi_write(unsigned char value);
        void _draw_pattern(unsigned char value, unsigned int pix);
    
    unsigned char *_console_font_data;  
    unsigned int _console_font_width;
    unsigned int _double_height_text;   
};


#endif
