/*
 * Code ported from EDP-MSP430 and IAR-STM32-SK
 * Allan K Liu
 */
 
#include "mbed.h"
#include "ssd1606.h"
//#include "font.h"
#include "rom_image.h"
#include "rom_font.h"

#include <stdarg.h>

const unsigned char init_data[]={
0x82,0x00,0x00,0x00,0xAA,0x00,0x00,0x00,
0xAA,0xAA,0x00,0x00,0xAA,0xAA,0xAA,0x00,
0x55,0xAA,0xAA,0x00,0x55,0x55,0x55,0x55,
0xAA,0xAA,0xAA,0xAA,0x55,0x55,0x55,0x55,
0xAA,0xAA,0xAA,0xAA,0x15,0x15,0x15,0x15,
0x05,0x05,0x05,0x05,0x01,0x01,0x01,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x41,0x45,0xF1,0xFF,0x5F,0x55,0x01,0x00,
0x00,0x00,};


SSD1606::SSD1606(PinName cs, PinName rst, PinName dc, PinName busy, PinName data, PinName clk)
    : _cs(cs),
        _reset(rst),
        _dc(dc),
        _busy(busy),
        _data(data),
        _clk(clk)
{
    _cursor_x = 0;
    _cursor_y = 0;
    _cs = DigitalOut(cs);
    _reset = DigitalOut(rst);
    _dc = DigitalOut(dc);
    _busy = DigitalIn(busy);
    _data = DigitalOut(data);
    _clk = DigitalOut(clk);
}

void SSD1606::reset()
{
    _reset = 1;
    wait_ms(1);
    _reset = 0;
    wait_ms(1);
    _reset = 1;
    wait_ms(1);
}

void SSD1606::read_busy()
{
    while(1)
    {
        asm("nop");
        if(_busy==0)
            break;
    }
}

void SSD1606::initialize()
{
  _send_command(0x10);
  _send_data(0x00);
#ifdef MODE3
  _send_command(0x11);
  _send_data(0x03);
  _send_command(0x44);
  _send_data(0x00);
  _send_data(0x11);
  _send_command(0x45);
  _send_data(0x00);
  _send_data(0xAB);
  _send_command(0x4E);
  _send_data(0x00);
  _send_command(0x4F);
  _send_data(0x00);
#endif
#ifdef MODE2
  _send_command(0x11);
  _send_data(0x02);
  _send_command(0x44);
  _send_data(0x11);
  _send_data(0x00);
  _send_command(0x45);
  _send_data(0x00);
  _send_data(0xAB);
  _send_command(0x4E);
  _send_data(0x11);
  _send_command(0x4F);
  _send_data(0x00);
#endif  
#ifdef MODE1
  _send_command(0x11);
  _send_data(0x01);
  _send_command(0x44);
  _send_data(0x00);
  _send_data(0x11);
  _send_command(0x45);
  _send_data(0xAB);
  _send_data(0x00);
  _send_command(0x4E);
  _send_data(0x00);
  _send_command(0x4F);
  _send_data(0xAB);
#endif
#ifdef MODE0
  _send_command(0x11);
  _send_data(0x00);
  _send_command(0x44);
  _send_data(0x11);
  _send_data(0x00);
  _send_command(0x45);
  _send_data(0xAB);
  _send_data(0x00);
  _send_command(0x4E);
  _send_data(0x11);
  _send_command(0x4F);
  _send_data(0xAB);
#endif
  _send_command(0xF0);
  _send_data(0x1F);
  _send_command(0x21);
  _send_data(0x03);
  _send_command(0x2C);
  _send_data(0xA0);
  _send_command(0x3C);
  _send_data(0x63);
  _send_command(0x22);
  _send_data(0xC4);
    
    set_lut();
}



void SSD1606::rom_image(const unsigned char *bitmap)
{
    int i=0;
    _send_command(0x24);
    
    for (i=0; i <3096; i++)
        _send_data(bitmap[i]);
    
    _send_command(0x20);
    wait_ms(1);
    read_busy();    
}

void SSD1606::update(void)
{
    int i = 0;
    _send_command(0x24);
    
    for (i=0; i<3096; i++)
        //_send_data(_screen[i]);
        //_send_data(buf[i]);
    
    wait_ms(1);
    read_busy();
}

/*  Hardware Switch off Power Supply for EPD mode (MOSFET)
 */
void SSD1606::off()
{
}

void SSD1606::deepsleep()
{
}

void SSD1606::sleep()
{
    _send_command(0x10);
    _send_data(0x01);
}

void SSD1606::wake()
{
    _send_command(0x10);
    _send_data(0x00);   
}

void SSD1606::set_command_between_images()
{
    _send_command(0x22);
    _send_data(0xC7);
    _send_command(0x21);
    _send_data(0x03);
}

void SSD1606::clear()
{
    for (int i=0; i<3096; i++)
        _send_data(0xFF);
    _cursor_x = 0;
    _cursor_y = 0;
}

void SSD1606::_vspi_write(unsigned char value)
{
    unsigned char tmp;
    tmp = value;
    
    for (int i=0; i<8; i++)
    {
        if(tmp & 0x80)
        {
            _data = 1;          
        }else{
            _data = 0;
        }
        _clk = 1;
        wait_us(SPI_BUS_DELAY);
        _clk = 0;
        tmp = tmp<<1;
    }
}

void SSD1606::_send_command(unsigned char code)
{
    _cs = 1; wait_us(SPI_BUS_DELAY);
    _cs = 0; wait_us(SPI_BUS_DELAY);    // Maybe _cs set low before _dc set low?
    _clk = 0; wait_us(SPI_BUS_DELAY);
    _dc = 0; wait_us(SPI_BUS_DELAY);

    //_spi.write(code);
    _vspi_write(code);
     wait_us(SPI_BUS_DELAY);
    _cs = 1; wait_us(SPI_BUS_DELAY);
}

void SSD1606::_send_data(unsigned char value)
{
    _cs = 1; wait_us(SPI_BUS_DELAY);
    _cs = 0; wait_us(SPI_BUS_DELAY);
    _clk = 0; wait_us(SPI_BUS_DELAY);
    _dc = 1; wait_us(SPI_BUS_DELAY);    // Maybe _cs set low before _dc set high?
    //_spi.write(value);
    _vspi_write(value);
     wait_us(SPI_BUS_DELAY);
    _cs = 1; wait_us(SPI_BUS_DELAY);
}

void SSD1606::set_lut(void)
{
    unsigned char i;
    _send_command(0x32);
    for(i=0; i<90; i++)
    {
        _send_data(init_data[i]);
    }
}

void SSD1606::_draw_pattern(unsigned char value, unsigned int pix)
{
    int i = 0;
    unsigned char x, y;
    for (x=0; x<SSD1606_WIDTH; x++)
    {
        for (y=0; y<COLBUF_SIZE; y++)
        {
            i++;
            if (i<pix)
                _send_data(value);
            else
                _send_data(0xFF);
        }
    }   
}

void SSD1606::test_image(unsigned char idx)
{
    switch(idx){
        case TEST_GREY1:
            break;
        case TEST_GREY2:
            break;
        case TEST_BLK:
            break;
        case TEST_WHT:
            clear();
            break;
        case TEST_HALF:
            break;
        case TEST_STRIP1:
            break;
        case TEST_STRIP2:
            break;
        default:
            break;
    }
}


void SSD1606::set_font(unsigned char *font, unsigned char width)
{
}

void SSD1606::_send_data_1bpp(unsigned char value)
{
    unsigned char temp;
    temp = EPD_2bpp_LUT[value & 0x0F];
    _send_data(temp);
    temp = EPD_2bpp_LUT[value>>4 & 0x0F];
    _send_data(temp);
}
