/*************************************************************************
 *
 *    Used with ICCARM and AARM.
 *
 *    (c) Copyright IAR Systems 2013
 *
 *    File name   : image.h
 *    Description : image bitmap for E-Paper Device
 *
 *    History :
 *    1. Date        : 9, March 2013
 *       Author      : Allan K Liu
 *       Description : Create
 *
 *  Do not enable all image data, if you are using evaluation version of ICC
 *  You can save it in flash memory by other means and read them in driver.
 *
 *  IO Used:
 *
 *    $Revision:  $
 **************************************************************************/
#ifndef _IMAGE_H_
#define _IMAGE_H_

const unsigned char gImage_one[3096] = { /* 0X01,0X02,0XAC,0X00,0X48,0X00, */
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X02,0XB8,0XFF,0XCF,0XFF,0XFF,0XFF,
0XFF,0XFC,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X14,0X07,0XF8,0XFC,0X00,0X00,
0X3F,0XFF,0XFF,0XFC,0X00,0X30,0XFF,0XFF,0XFF,0XFF,0X00,0X6B,0XFE,0X07,0XF8,0XF3,
0XFF,0XFF,0X3F,0XFF,0XFF,0XFC,0X00,0X30,0XFF,0XFF,0XFF,0XFF,0X0F,0XFF,0XFF,0X07,
0XF8,0XFF,0X33,0XCF,0X3F,0XFF,0XFF,0XFF,0XF0,0X30,0XFC,0X3F,0XFF,0XFF,0X2F,0XFF,
0XFF,0X07,0XF8,0XFF,0X33,0XCF,0X3F,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XFF,0XFF,
0X3F,0XFF,0XFF,0X07,0XF8,0XFF,0X33,0XCF,0X3F,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,
0XFF,0XFF,0X3F,0XFA,0XFF,0X07,0XF8,0XF0,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XF0,0X30,
0XFC,0X3F,0XFF,0XFF,0X3F,0XD1,0XFF,0X07,0XF8,0XFF,0X33,0XCF,0X3F,0XFF,0XFF,0XFC,
0X00,0X30,0XFF,0XFF,0XFF,0XFF,0X3F,0XC1,0XFF,0X07,0XF8,0XFF,0X33,0XCF,0X3F,0XFF,
0XFF,0XFC,0X00,0X30,0XFF,0XFF,0XFF,0XFF,0X3F,0XC1,0XFF,0X07,0XF8,0XFF,0X33,0XCF,
0X3F,0XFF,0XFF,0XFC,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XC1,0XFF,0X6F,0XF8,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XC1,0XFF,0XFF,
0XF8,0XFC,0X30,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XC1,
0XFF,0XFF,0XF8,0XF3,0X33,0X33,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X3F,0XC1,0XFF,0XFF,0XF0,0XFF,0X33,0X33,0X3F,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,
0XFF,0XFF,0X3F,0XC1,0XFF,0XFA,0X40,0XFC,0X30,0X00,0X3F,0XFF,0XFF,0XFF,0XF0,0XFF,
0XFF,0XFF,0XFF,0XFF,0X3F,0XC0,0XA9,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0X00,0X3F,0XFF,0XFF,0X3F,0X80,0X00,0X05,0XA0,0XF0,0X03,0X00,0X3F,0XFF,
0XFF,0XFF,0X00,0X00,0X00,0X3F,0XFF,0XFF,0X14,0X00,0X16,0XFF,0XF8,0XFF,0X33,0XCF,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X1A,0XFF,0XFF,0XF8,0XFF,
0X33,0XCF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X1B,0XFF,0XFF,0XFF,
0XF8,0XFC,0XF3,0X3F,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,
0XFF,0XFF,0XF8,0XFF,0X03,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X3F,0XFF,0XFF,0X9B,0XF8,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X3F,0XFE,0X94,0X07,0XF8,0XF3,0X3C,0XCF,0X3F,0XFF,0XFF,0XFF,0XFC,0X03,
0XC3,0XFF,0XFF,0XFF,0X2E,0X50,0X00,0X07,0XF8,0XFC,0X33,0XC3,0X3F,0XFF,0XFF,0XFF,
0X00,0X03,0XC0,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X07,0XF8,0XFF,0X0F,0X0C,0XFF,0XFF,
0XFF,0XFF,0X03,0XCF,0XFC,0X3F,0XFF,0XFF,0X00,0X00,0X00,0X07,0XF8,0XF0,0X00,0XCC,
0XFF,0XFF,0XFF,0XFF,0X0F,0XCF,0XFC,0X3F,0XFF,0XFF,0X00,0X00,0X01,0X6F,0XF8,0XFC,
0X33,0XC0,0XFF,0XFF,0XFF,0XFF,0X0F,0XCF,0XFC,0X3F,0XFF,0XFF,0X00,0X01,0XAF,0XFF,
0XF8,0XF3,0X3C,0XCF,0X3F,0XFF,0XFF,0XFF,0X0F,0XC0,0X00,0XFF,0XFF,0XFF,0X06,0XBF,
0XFF,0XFF,0XF8,0XFF,0XC3,0XFF,0X3F,0XFF,0XFF,0XFF,0X0F,0XF0,0X03,0XFF,0XFF,0XFF,
0X2F,0XFF,0XFF,0XFF,0XF0,0XF0,0X3C,0X3C,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X3F,0XFF,0XFF,0XFA,0X40,0XFF,0X3F,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X0F,0XFF,0XFF,0XFF,0X3F,0XFF,0XF9,0X40,0X00,0XFF,0X00,0X3C,0XFF,0XFF,0XFF,0XFF,
0XFF,0XF0,0X0F,0XFF,0XFF,0XFF,0X3F,0XE5,0X00,0X01,0X64,0XFF,0X3F,0XFF,0X3F,0XFF,
0XFF,0XFF,0XFF,0XC3,0X0F,0XFF,0XFF,0XFF,0X14,0X00,0X01,0XAF,0XF8,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFC,0X0F,0X0F,0XFF,0XFF,0XFF,0X00,0X06,0XBF,0XFF,0XF8,0XF3,
0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0XFF,0X0F,0XFF,0XFF,0XFF,0X16,0XFF,0XFF,0XFF,
0XF8,0XF0,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X3F,0XFF,0XFF,0X3F,0XFF,
0XFF,0XFF,0XF8,0XF3,0XF3,0XF3,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X3F,0XFF,0XFF,
0X3F,0XFF,0XFF,0XE9,0X00,0XF3,0XF0,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0XFF,
0XFF,0XFF,0X3F,0XFF,0XFE,0X00,0X00,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XE0,0X00,0XF3,0XFC,0XCF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X1B,0XFF,0XFF,0XFE,0X40,0XF3,0X00,0XCF,0XFF,0XFF,
0XFF,0XFF,0XFC,0X03,0XC3,0XFF,0XFF,0XFF,0X00,0X6F,0XFF,0XFF,0XF4,0XF3,0XFC,0XCF,
0X3F,0XFF,0XFF,0XFF,0X00,0X03,0XC0,0XFF,0XFF,0XFF,0X00,0X01,0XBF,0XFF,0XF8,0XF3,
0XFC,0XCF,0X3F,0XFF,0XFF,0XFF,0X03,0XCF,0XFC,0X3F,0XFF,0XFF,0X00,0X00,0X5F,0XFF,
0XF8,0XF0,0X00,0XFF,0X3F,0XFF,0XFF,0XFF,0X0F,0XCF,0XFC,0X3F,0XFF,0XFF,0X00,0X6B,
0XFF,0XFF,0XF8,0XFF,0XFC,0X00,0XFF,0XFF,0XFF,0XFF,0X0F,0XCF,0XFC,0X3F,0XFF,0XFF,
0X2F,0XFF,0XFF,0XFF,0XF8,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0XC0,0X00,0XFF,
0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XA4,0XFF,0XCF,0XC3,0XFF,0XFF,0XFF,0XFF,0X0F,0XF0,
0X03,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0X90,0X00,0XFF,0XCC,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFE,0X50,0X00,0X14,0XF0,0X00,0X00,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X2A,0X40,0X00,0X5B,0XF8,0XFF,0XCC,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X01,0X6F,0XFF,0XF8,0XFF,
0XCF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X01,0XAF,0XFF,0XFF,
0XF8,0XFF,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0X2F,0XFF,
0XFF,0XFF,0XF8,0XFC,0X00,0X00,0X3F,0X00,0X00,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,
0X3F,0XFF,0XFF,0XFE,0X50,0XFC,0XF3,0X3C,0XFF,0X3F,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X3F,0XFF,0XFA,0X40,0X00,0XFC,0XF3,0X3C,0XFF,0X3F,0XFC,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X3F,0XE9,0X40,0X00,0X54,0XFC,0XF3,0X3C,0XFF,0XC0,0X03,0XFF,
0XF0,0X00,0X03,0XFF,0XFF,0XFF,0X15,0X00,0X00,0X6B,0XF8,0XFC,0X00,0X00,0X3F,0XFF,
0XFF,0XFF,0XC0,0X00,0X00,0X3F,0XFF,0XFF,0X00,0X01,0XAF,0XFF,0XF8,0XFF,0XFF,0XCF,
0XFF,0XC0,0XFF,0XFF,0X0F,0XFF,0XFC,0X3F,0XFF,0XFF,0X05,0XBF,0XFF,0XFF,0XF8,0XFF,
0X3C,0X3F,0XFF,0X3F,0X30,0XFF,0X0F,0XFF,0XFC,0X3F,0XFF,0XFF,0X2F,0XFF,0XFF,0XFF,
0XF8,0XF0,0X00,0X00,0X3F,0X3F,0X3C,0XFF,0X0F,0XFF,0XFC,0X3F,0XFF,0XFF,0X3F,0XFF,
0XFF,0XFA,0X40,0XFF,0X3C,0XFF,0X3F,0X3F,0X3C,0XFF,0XC0,0X00,0X00,0XFF,0XFF,0XFF,
0X3F,0XFF,0XFE,0X40,0X00,0XFF,0X3F,0X3C,0XFF,0XC0,0X03,0XFF,0XF0,0X00,0X03,0XFF,
0XFF,0XFF,0X3F,0XFF,0XFF,0X90,0X00,0XFC,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X1F,0XFF,0XFF,0XFE,0X40,0XFC,0XFF,0XFF,0XFF,0XC0,0X03,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X01,0XBF,0XFF,0XFF,0XF4,0XFC,0XFF,0XFF,0XFF,0X3F,
0XFC,0XFF,0XF0,0X00,0X03,0XFF,0XFF,0XFF,0X00,0X06,0XFF,0XFF,0XF8,0XFC,0X00,0X00,
0X3F,0X3F,0XFC,0XFF,0XC0,0X00,0X00,0X3F,0XFF,0XFF,0X00,0X00,0X2F,0XFF,0XF8,0XFF,
0XFF,0XFF,0X3F,0X3F,0XFC,0XFF,0X0F,0XFF,0XFC,0X3F,0XCF,0XFF,0X00,0X1A,0XFF,0XFF,
0XF8,0XFF,0XFF,0XF0,0X3F,0XC0,0X03,0XFF,0X0F,0XFF,0XFC,0X3F,0X3F,0XFF,0X1B,0XFF,
0XFF,0XFF,0XF8,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0XFF,0XFC,0X3C,0X00,0X0F,
0X3F,0XFF,0XFF,0XFF,0XE4,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0XFF,
0XFF,0XFF,0X3F,0XFF,0XFF,0XE5,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,
0X03,0XFF,0XFF,0XFF,0X3F,0XFF,0X94,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X2E,0X90,0X00,0X1A,0XF4,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X6B,0XFF,0XF8,0XFF,0XFF,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0XFF,0X01,0X6F,0XFF,0XFF,0XF8,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X1F,0XFF,0XFF,0XFF,
0XF8,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0XFF,0X2F,0XFF,
0XFF,0XFF,0XF8,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X3F,0XFF,0XFE,0X5B,0XF8,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X3F,0XFA,0X40,0X07,0XF8,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X3F,0XFF,0XFF,0X3F,0XD0,0X00,0X07,0XF8,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X3F,0XCF,0X3F,0XC0,0X6A,0X07,0XF8,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0X0F,0X3F,0XC1,0XFF,0X07,0XF8,0XFF,0XFF,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3C,0XFC,0XCF,0X3F,0XC1,0XFF,0X1B,0XF8,0XFF,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3C,0XF3,0XCF,0X3F,0XC1,0XFF,0XFF,
0XF8,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0XCF,0X3F,0XC1,
0XFF,0XFF,0XF8,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,
0X3F,0XC1,0XFF,0XFF,0XF8,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,
0X3F,0X3F,0X3F,0XC1,0XFF,0XFE,0X50,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X3C,0XFF,0XCF,0X3F,0XC1,0XF9,0X40,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X3C,0XF3,0XCF,0X3F,0XC0,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XF3,0XCF,0X15,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0X0C,0X3F,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,
0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0XFF,0X00,0X00,
0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XCC,0XFF,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,
0X3C,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X3C,0XFC,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X3F,0XFC,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3C,0X0F,0X0F,0X00,0X00,0X00,0X00,
0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3C,0XCF,0XCF,0X00,0X00,
0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XCF,0XCF,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0XF0,0X3F,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X3F,0X00,0X3F,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XCF,0XCF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XCF,0XCF,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XCF,0XCF,0X00,0X00,0X00,0X00,
0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X30,0X3F,0X00,0X00,
0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X3C,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0XF0,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XCF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3C,0X3F,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,
0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,
0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X0F,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,
0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0X00,0X00,
0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X3F,0X0C,0X3F,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0XF3,0XCF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XF3,0XCF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XF3,0XCF,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0X0C,0X3F,0X00,0X00,0X00,0X00,
0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0X00,0X00,
0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0X03,0X3F,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0XFC,0XCF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X3C,0XFC,0XCF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0XFC,0XCF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X3F,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0X00,0X00,0X00,0X00,
0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0X00,0X00,
0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3C,
0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X3F,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X3F,0X00,0X3F,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3C,0XFF,0XCF,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3C,0XFF,0XCF,0X00,0X00,0X00,0X00,
0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XCF,0X00,0X00,
0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X3F,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,
0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X3F,0XCF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X3F,0X3F,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,
0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0X00,0X00,
0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0X03,0X3F,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0XFC,0XCF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X3C,0XFC,0XCF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X3C,0XFC,0XCF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X3F,0X00,0X3F,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0X00,0X00,0X00,0X00,
0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X0F,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X0F,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,};

const unsigned char gImage_nokia[3096] = { /* 0X81,0X02,0XAC,0X00,0X48,0X00, */
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0XFF,0XFF,0XFC,0X00,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X03,0X00,0XC0,0X30,0X0C,0X00,0XF0,0XFF,0XFF,0XFF,0X3C,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XC0,0X30,0X0C,0X00,0XF0,0XFF,0XFF,
0XFF,0X3C,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0XC0,0X30,0X0C,0X00,0XF0,
0X00,0X00,0X00,0X3C,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X00,
0X00,0XFC,0X00,0X00,0X00,0X3C,0X3F,0XFF,0XFF,0XFF,0XF0,0XFF,0X0F,0XF0,0X00,0XF0,
0X00,0X00,0X00,0XFF,0X00,0XFF,0XFF,0X3C,0X3F,0XFF,0XFF,0XFF,0XCF,0X3F,0XF3,0XF0,
0X00,0X0F,0XF0,0X00,0X00,0XFF,0XC0,0X3F,0XFF,0X3C,0X3F,0XFF,0XFF,0XFF,0X3F,0XCF,
0XFC,0XF0,0X00,0X00,0X0F,0XF0,0X00,0XFF,0XF0,0X0F,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,
0X3F,0XCF,0XFC,0XF0,0X00,0X00,0X00,0X3C,0X00,0XFF,0XFF,0X03,0XFF,0XFC,0X3F,0XFF,
0XFF,0XFF,0X3F,0XF3,0XFC,0XF0,0X00,0X00,0X0F,0XC0,0X00,0XFF,0XFF,0XC0,0XFF,0XFC,
0X3F,0XFF,0XFF,0XFF,0X3F,0XF3,0XFC,0XF0,0X00,0X0F,0XF0,0X00,0X00,0XFF,0XFF,0XF0,
0X0F,0XFC,0X3F,0XFF,0XFF,0XFF,0XCF,0XF3,0XF3,0XF0,0X00,0XF0,0X00,0X00,0X00,0XF0,
0XFF,0XFC,0X03,0XFC,0X3F,0XFF,0XFF,0XFF,0XF3,0XFC,0X0F,0XF0,0X00,0X00,0X00,0X00,
0X00,0XF0,0XFF,0XFF,0X00,0XFC,0X3C,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0XFF,
0XFF,0XFC,0X00,0XF0,0X00,0X00,0X00,0X3C,0X3C,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XF0,
0X00,0XC0,0X30,0X0C,0X00,0XF0,0X00,0X00,0X00,0X3C,0X3F,0XFF,0XFC,0X03,0X3F,0XFF,
0XFF,0XF0,0X00,0XC0,0X30,0X0C,0X00,0XF0,0XFF,0XFF,0XFF,0XFC,0X3C,0XFF,0X03,0XFF,
0XC3,0XFF,0XFF,0XF0,0X00,0XC0,0X30,0X0C,0X00,0XFF,0XFC,0X00,0XFF,0XFC,0X3C,0X00,
0XFF,0XFF,0XFC,0X3F,0XFF,0XF0,0X00,0X00,0X00,0X00,0X00,0XFF,0XC0,0X00,0X0F,0XFC,
0X3C,0XFF,0X03,0XFF,0XFF,0XC0,0X00,0XF0,0X00,0X00,0X00,0X00,0X00,0XFF,0X00,0X00,
0X03,0XFC,0X3F,0XFF,0XFC,0X03,0XFC,0X3F,0XFF,0XF0,0X00,0XFF,0XFF,0XFC,0X00,0XFC,
0X03,0XFF,0X00,0XFC,0X3C,0X00,0X03,0XFF,0XC3,0XFF,0XFF,0XF0,0X00,0XC0,0X30,0X00,
0X00,0XF0,0X3F,0XFF,0XFC,0X3C,0X3C,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XF0,0X00,0XC0,
0X30,0X00,0X00,0XF0,0XFF,0XFF,0XFC,0X3C,0X3F,0XF0,0X00,0XFF,0XFF,0XFF,0XFF,0XF0,
0X00,0XC0,0XFF,0X00,0X00,0XF0,0XFF,0XFF,0XFF,0X0C,0X3F,0XCF,0XFF,0X0F,0XFF,0XFF,
0XFF,0XF0,0X00,0X3F,0XC0,0XF0,0X00,0XF0,0XFF,0XFF,0XFF,0X0C,0X3F,0X3F,0XFF,0XF3,
0X00,0X00,0X00,0XF0,0X00,0XC0,0X00,0X0C,0X00,0XF0,0XFF,0XFF,0XFF,0X0C,0X3C,0XFF,
0XFF,0XF3,0XC0,0X3F,0XFF,0XF0,0X00,0X3F,0X00,0X00,0X00,0XF0,0XFF,0XFF,0XFC,0X3C,
0X3C,0XFF,0XFF,0XF3,0XFF,0XC0,0X0F,0XF0,0X00,0X00,0XF0,0X00,0X00,0XF0,0X3F,0XFF,
0XF0,0X3C,0X3C,0XFF,0XFF,0XF3,0XFF,0XFF,0XF0,0XF0,0X00,0X00,0X3F,0XFC,0X00,0XFC,
0X00,0XFF,0X00,0XFC,0X3F,0X3F,0XFF,0XCF,0XFF,0XC0,0X0F,0XF0,0X00,0X0F,0XC0,0X00,
0X00,0XFF,0X00,0X00,0X03,0XFC,0X3C,0X0F,0XFC,0X3F,0XC0,0X3F,0XFF,0XF0,0X00,0XF0,
0X00,0X00,0X00,0XFF,0XC0,0X00,0X0F,0XFC,0X3F,0XFF,0XFF,0XFF,0X00,0X00,0X00,0XF0,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X03,0XFF,0X3C,0X3C,0XFF,0XFF,0XF3,0XFF,0XFF,
0XFF,0XF0,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0XFF,0X3C,0X3C,0X00,0X00,0X03,
0X00,0X00,0X00,0XF0,0X00,0X00,0X00,0X00,0X00,0XF0,0X00,0X00,0X00,0X3C,0X3C,0XFF,
0XFF,0XF3,0X3F,0XCF,0XFC,0XF0,0X00,0X00,0X00,0X00,0X00,0XF0,0X00,0X00,0X00,0X3C,
0X3C,0XFF,0XFF,0XF3,0X3F,0XCF,0XFC,0XF0,0X00,0X00,0X00,0X00,0X00,0XF0,0X00,0X00,
0X00,0X3C,0X3C,0XFF,0XFF,0XF3,0X3F,0XCF,0XFC,0XF0,0X00,0XFF,0XFF,0XFC,0X00,0XF0,
0XFF,0X03,0XFF,0X3C,0X3F,0X3F,0XFF,0XCF,0X3F,0XCF,0XFC,0XF0,0X00,0XC0,0X00,0X0C,
0X00,0XFF,0XFC,0X00,0XFF,0X3C,0X3F,0XCF,0XFF,0X3F,0X3F,0XCF,0XFC,0XF0,0X00,0XC0,
0X00,0X0C,0X00,0XFF,0XF0,0XF0,0X3F,0XFC,0X3F,0XF0,0X00,0XFF,0XCF,0X33,0XF3,0XF0,
0X00,0XC0,0X00,0X0C,0X00,0XF0,0X03,0XFC,0X0F,0X3C,0X3F,0XFF,0XFF,0XFF,0XF0,0XFC,
0X0F,0XF0,0X00,0X3C,0X00,0XF0,0X00,0XF0,0X0F,0XFF,0X00,0X3C,0X3C,0XFF,0XFF,0XF3,
0XFF,0XFF,0XFF,0XF0,0X00,0X03,0XFF,0X00,0X00,0XF0,0X3F,0XFF,0XC0,0X3C,0X3C,0X00,
0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3C,0X00,0XF0,0XFF,0XFF,0XF0,0X3C,
0X3C,0X03,0XFF,0XF3,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X3F,0XC0,0X00,0XF0,0XFF,0XFF,
0XFC,0X3C,0X3F,0XFC,0X03,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X3F,0XF3,0X00,0X00,0XFF,
0XFF,0XFF,0XFC,0X3C,0X3F,0XFF,0XF0,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0XF0,0X03,0X00,
0X00,0XFF,0XFF,0XFF,0XFF,0X3C,0X3F,0XFC,0X03,0XFF,0X00,0X00,0X00,0XF0,0X00,0X0F,
0XF3,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X3C,0X3C,0X03,0XFF,0XF3,0XFF,0XFF,0XFF,0XF0,
0X00,0X00,0X3F,0XC0,0X00,0XF0,0XFF,0XFF,0XFF,0X3C,0X3C,0X00,0X00,0X03,0XFF,0XFF,
0XFF,0XF0,0X00,0XC0,0X00,0X3C,0X00,0XF0,0X00,0X00,0X00,0X3C,0X3C,0XFF,0XFF,0XF3,
0XFF,0XFF,0XFF,0XF0,0X00,0X3F,0X00,0X00,0X00,0XF0,0X00,0X00,0X00,0X3C,0X3F,0XFF,
0XFF,0XF3,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0XF0,0X00,0X00,0XF0,0X00,0X00,0X00,0X3C,
0X3F,0XFF,0XFF,0X03,0XFF,0XFF,0XF0,0XF0,0X00,0X00,0X3F,0XFC,0X00,0XF0,0XFF,0XFF,
0XFF,0X3C,0X3F,0XFF,0X00,0XF3,0XFF,0XF0,0X0F,0XF0,0X00,0X0F,0XC0,0X00,0X00,0XFF,
0XFF,0XFF,0XFF,0X3C,0X3F,0XC0,0XF3,0XFF,0XF0,0X0C,0XFF,0XF0,0X00,0XF0,0X00,0X00,
0X00,0XFF,0XFF,0XFF,0XFF,0X3C,0X3C,0X3F,0XF3,0XFF,0X0F,0XFC,0XFF,0XF0,0X00,0X00,
0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFC,0X3C,0X3F,0XC0,0XF3,0XFF,0X0F,0XFC,0XFF,0XF0,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XC0,0X3C,0X3F,0XFF,0X00,0XF3,0XF0,0X0C,
0XFF,0XF0,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XF0,0X00,0X3C,0X3F,0XFF,0XFF,0X03,
0XFF,0XF0,0X0F,0XF0,0X00,0X00,0X00,0X00,0X00,0XFF,0XFC,0X00,0X3F,0X3C,0X3F,0XFF,
0XFF,0XF3,0XFF,0XFF,0XF0,0XF0,0X00,0XFF,0XFF,0XFC,0X00,0XFF,0X00,0X0C,0X3F,0XFC,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X0C,0X00,0XF0,0X03,0XFC,
0X3F,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X0C,0X00,0XF0,
0X00,0XFC,0X3F,0XFC,0X3F,0XFF,0XFF,0XFF,0X00,0X00,0X00,0XF0,0X00,0X00,0X00,0X0C,
0X00,0XFF,0X00,0X00,0X3F,0XFC,0X3F,0XFF,0XFF,0XFF,0XC3,0XFF,0XFF,0XF0,0X00,0X0F,
0XFF,0XC0,0X00,0XFF,0XFC,0X00,0X3F,0X3C,0X3F,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XF0,
0X00,0X3C,0X00,0XF0,0X00,0XFF,0XFF,0XC0,0X00,0X3C,0X3F,0XFF,0XFF,0XFF,0XFF,0XC3,
0XFF,0XF0,0X00,0XC0,0X00,0X0C,0X00,0XFF,0XFF,0XFF,0X00,0X3C,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFC,0X3F,0XF0,0X00,0XC0,0X00,0X0C,0X00,0XFF,0XFF,0XFF,0XF0,0X3C,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XC3,0XF0,0X00,0XC0,0X00,0X0C,0X00,0XFF,0XFF,0XFF,0XFC,0X3C,
0X3F,0XFF,0XFF,0XFF,0X00,0X00,0X00,0XF0,0X00,0X30,0X00,0XF0,0X00,0XFF,0XFF,0XFF,
0XFF,0X3C,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X0F,0XFF,0XC0,0X00,0XFF,
0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X00,
0X00,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,
0XC0,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X03,
0X00,0X00,0X3F,0XC0,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0X00,0X3C,0X00,0XFF,0XF0,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XC0,0X00,0XFF,0X00,0X00,0X03,0XFF,0XFF,0XFF,
0XFF,0XFF,0XF0,0X0F,0XFF,0XFF,0X00,0X0F,0X00,0X00,0X00,0XFC,0X00,0X00,0X00,0XFF,
0XFF,0XFF,0XFF,0XFF,0X03,0XC0,0XFF,0XFF,0X00,0XFF,0X00,0X00,0X00,0XF0,0X3F,0XFF,
0XF0,0X3F,0XFF,0XFF,0XFF,0XF0,0X3C,0X3C,0X0F,0XFF,0X00,0X0F,0XFF,0XC0,0X00,0XF0,
0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XC3,0XC0,0X03,0XC3,0XFF,0X00,0X00,0X03,0XFC,
0X00,0XF0,0XFF,0XFF,0XFC,0X0F,0XFF,0XFF,0XFC,0X0F,0X00,0X00,0XF0,0X3F,0X00,0X03,
0XFF,0X00,0X00,0XF0,0XFF,0XFF,0XFF,0X0F,0XFF,0XFF,0XC0,0XF0,0X00,0X00,0X0F,0X03,
0X00,0XFC,0X00,0X00,0X00,0XF0,0XFF,0XFF,0XFF,0X0F,0XFF,0XFF,0XCF,0X00,0X00,0X00,
0X00,0XF3,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XCC,0X00,
0X00,0X00,0X00,0X33,0X00,0X00,0X00,0X00,0X00,0XFC,0X3F,0XFF,0XFC,0X3F,0XFF,0XFF,
0XCC,0X00,0X00,0X00,0X00,0X33,0X00,0X00,0X00,0X00,0X00,0XF0,0X03,0XFF,0XF0,0XFF,
0XFF,0XFF,0XCC,0X00,0X00,0X00,0X00,0X33,0X00,0X00,0X00,0X00,0X00,0XF0,0X03,0XFF,
0XC3,0XFF,0XFF,0XFF,0XCC,0X00,0X00,0X00,0X00,0X33,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCC,0X00,0X00,0X00,0X00,0X33,0X00,0XFF,0XFF,0XFC,
0X00,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XCC,0X00,0X00,0X00,0X00,0X33,0X00,0XC0,
0X0C,0X00,0X00,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XCC,0X00,0X00,0X00,0X00,0X33,
0X00,0XC0,0X0C,0X00,0X00,0XFF,0X00,0X3F,0XFC,0X3F,0XFF,0XFF,0XCC,0X00,0X00,0X00,
0X00,0X33,0X00,0XF0,0X3C,0X00,0X00,0XFC,0X00,0X3F,0XFC,0X3F,0XFF,0XFF,0XCC,0X00,
0X00,0X00,0X00,0X33,0X00,0X3F,0XF0,0X00,0X00,0XF0,0X30,0X3F,0XFC,0X3F,0XFF,0XFF,
0XCC,0X00,0X00,0X00,0X00,0X33,0X00,0X00,0X00,0X00,0X00,0XF0,0X30,0X0F,0XFC,0X3F,
0XFF,0XFF,0XCC,0X00,0X00,0X00,0X00,0X33,0X00,0XFF,0XFF,0XFC,0X00,0XF0,0X3C,0X00,
0X00,0XFF,0XFF,0XFF,0X0F,0XC0,0X00,0X00,0X03,0XC3,0X00,0XC0,0X30,0X00,0X00,0XF0,
0X3F,0X00,0X03,0XFF,0XFF,0XF0,0X3F,0XF0,0X00,0X00,0X0F,0X0F,0X00,0XC0,0X30,0X00,
0X00,0XFF,0XFF,0XC0,0X3F,0XFF,0XFF,0X03,0XFF,0XFF,0X00,0X00,0XF0,0X3F,0X00,0XC0,
0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XF0,0X0F,0X03,0XFF,
0X00,0X3F,0XC0,0XF0,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XF0,0XFF,0XC3,0XFC,0X30,
0X3F,0XFF,0X00,0X00,0X00,0X0C,0X00,0XFF,0XFF,0XFF,0XFF,0XFC,0X0F,0XCF,0XFF,0X33,
0XFF,0XC3,0XFF,0XFF,0X00,0XC0,0X00,0X0C,0X00,0XFF,0XFF,0XFF,0XFF,0XF0,0XFF,0X3F,
0XFC,0XF3,0XFF,0X0F,0XFF,0XFF,0X00,0XFF,0XFF,0XFC,0X00,0XFF,0XFF,0XFF,0XFF,0XF3,
0XFF,0X3F,0XF3,0XF3,0XFF,0X3F,0XFF,0XFF,0X00,0XC0,0X00,0X0C,0X00,0XFF,0XFF,0XFF,
0XFF,0XF3,0XFF,0X3F,0XCF,0XF3,0XFF,0X3F,0XFF,0XFF,0X00,0X03,0XFF,0XC0,0X00,0XFF,
0XFF,0XFF,0XFF,0XF3,0XFF,0XCF,0X3F,0XF3,0XFF,0X3F,0XFF,0XFF,0X00,0X3C,0X00,0XF0,
0X00,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XF0,0XFF,0XF3,0XFF,0X3F,0XFF,0XFF,0X00,0XF0,
0X00,0X0C,0X00,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,
0X00,0XC0,0X00,0X0C,0X00,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,
0XFF,0XFF,0X00,0XC0,0X00,0X0C,0X00,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XF0,0X00,0X3F,
0XFF,0X3F,0XFF,0XFF,0X00,0X30,0X00,0X30,0X00,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XCF,
0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XF3,
0XFF,0X3F,0XFF,0XF3,0XFF,0X3F,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,
0XFF,0XF3,0XFF,0X3F,0XFF,0XF3,0XFF,0X3F,0XFF,0XFF,0X00,0XFF,0XFF,0XFC,0X00,0XFF,
0XFF,0XFF,0XFF,0XF3,0XFF,0X3F,0XCF,0XF3,0XFF,0X3F,0XFF,0XFF,0X00,0XC0,0X30,0X0C,
0X00,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XCF,0XCF,0XCF,0XFC,0X3F,0XFF,0XFF,0X00,0XC0,
0X30,0X0C,0X00,0XFF,0XFF,0XFF,0XFF,0XF0,0X3F,0XF0,0XC0,0X03,0XF0,0XFF,0XFF,0XFF,
0X00,0XC0,0X30,0X0C,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0XFF,0XFF,0XFF,0X03,0XFF,
0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XFF,0XFF,0XF0,
0X3F,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X0F,
0XFF,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XC0,0XFC,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X3C,0X0F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X0C,0X03,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X03,0XFF,0X00,
0X0F,0XC0,0XFF,0XFF,0XFF,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X03,
0XFC,0X0F,0X03,0XF0,0XFF,0XFF,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,
0X00,0X03,0XC0,0X00,0X00,0X00,0X03,0XF0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,
0XC0,0X00,0X00,0X03,0XC0,0X00,0X00,0X00,0X03,0X00,0X00,0X00,0X03,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0X00,0X03,0XFC,0X0F,0XC3,0XF0,0XFC,0X00,0X00,0X00,0X03,0XFF,
0XFF,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X03,0XFF,0X00,0XC0,0X00,0XF0,0X00,0X00,0X00,
0X03,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X03,0XFF,0XC0,0XF0,0X03,0XC0,0X00,
0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X03,0XFF,0XFF,0XFC,0X0F,
0X00,0X00,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X00,0X03,0XFF,0XFF,
0XFF,0XFC,0X00,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X00,0X03,
0XFF,0XFF,0XFF,0XFC,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X0C,
0X00,0X03,0XFF,0XFF,0XFF,0XFC,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0X00,0XFC,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X00,0X00,0X03,0XFC,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XF0,0X00,0X00,0X0F,0XFC,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X0F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X3F,0XFC,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0XFF,0XFC,0X00,0X03,0XFF,0XFF,0XFF,0XF0,
0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X03,0XFF,0XFC,0X00,0X03,0XFF,0XFF,
0XFF,0XF0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X00,0X0F,0XFF,0XFC,0X00,0X03,
0XFF,0XFF,0XFF,0XF0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X3F,0XFF,0XFC,
0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0XFF,
0XFF,0XFC,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X0F,0XFF,0XFF,0XFF,0XFC,0X00,0X00,
0X03,0XFF,0XFF,0XFC,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X03,0XFF,0XFF,0XFF,0XF0,
0X00,0X00,0X0F,0XFF,0XFF,0XFC,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0XFF,0XFF,
0XFF,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,
0X03,0XFF,0XC0,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFC,0X00,0X03,0XFF,0XFF,0XFF,0XFC,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFC,0X00,0X03,0XFF,0XFF,
0XFF,0XFC,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XFC,0X00,0X03,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFC,
0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,
0XFF,0XFC,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X03,0XFF,
0XFF,0XFF,0XFF,0XFC,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X00,0X00,
0X0F,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X03,0XFF,0XFC,0X3F,0XFF,0XFF,0X00,0X00,0X00,
0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X03,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,
0X00,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X03,0XFF,0XFC,0X3F,0XFF,
0XFF,0XFF,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X03,0XFF,0XF0,
0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X03,
0XFF,0XC0,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X3F,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XF0,0X00,0X03,0XC0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XC0,0X00,0X03,0XC0,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0XC0,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0XFF,0XC0,0XFC,0X0F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X03,0XFF,0XC0,0XFC,0X0F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0XFF,0XC0,0XFC,0X0F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X0F,0X00,
0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,
0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,};

const unsigned char gImage_suning[3096] = { /* 0X81,0X02,0XAC,0X00,0X48,0X00, */
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X02,0XB8,0XFF,0XCF,0XFF,0XFF,0XFF,
0XFF,0XFC,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X14,0X07,0XF8,0XFC,0X00,0X00,
0X3F,0XFF,0XFF,0XFC,0X00,0X30,0XFF,0XFF,0XFF,0XFF,0X00,0X6B,0XFE,0X07,0XF8,0XF3,
0XFF,0XFF,0X3F,0XFF,0XFF,0XFC,0X00,0X30,0XFF,0XFF,0XFF,0XFF,0X0F,0XFF,0XFF,0X07,
0XF8,0XFF,0X33,0XCF,0X3F,0XFF,0XFF,0XFF,0XF0,0X30,0XFC,0X3F,0XFF,0XFF,0X2F,0XFF,
0XFF,0X07,0XF8,0XFF,0X33,0XCF,0X3F,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XFF,0XFF,
0X3F,0XFF,0XFF,0X07,0XF8,0XFF,0X33,0XCF,0X3F,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,
0XFF,0XFF,0X3F,0XFA,0XFF,0X07,0XF8,0XF0,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XF0,0X30,
0XFC,0X3F,0XFF,0XFF,0X3F,0XD1,0XFF,0X07,0XF8,0XFF,0X33,0XCF,0X3F,0XFF,0XFF,0XFC,
0X00,0X30,0XFF,0XFF,0XFF,0XFF,0X3F,0XC1,0XFF,0X07,0XF8,0XFF,0X33,0XCF,0X3F,0XFF,
0XFF,0XFC,0X00,0X30,0XFF,0XFF,0XFF,0XFF,0X3F,0XC1,0XFF,0X07,0XF8,0XFF,0X33,0XCF,
0X3F,0XFF,0XFF,0XFC,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XC1,0XFF,0X6F,0XF8,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XC1,0XFF,0XFF,
0XF8,0XFC,0X30,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XC1,
0XFF,0XFF,0XF8,0XF3,0X33,0X33,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X3F,0XC1,0XFF,0XFF,0XF0,0XFF,0X33,0X33,0X3F,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,
0XFF,0XFF,0X3F,0XC1,0XFF,0XFA,0X40,0XFC,0X30,0X00,0X3F,0XFF,0XFF,0XFF,0XF0,0XFF,
0XFF,0XFF,0XFF,0XFF,0X3F,0XC0,0XA9,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0X00,0X3F,0XFF,0XFF,0X3F,0X80,0X00,0X05,0XA0,0XF0,0X03,0X00,0X3F,0XFF,
0XFF,0XFF,0X00,0X00,0X00,0X3F,0XFF,0XFF,0X14,0X00,0X16,0XFF,0XF8,0XFF,0X33,0XCF,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X1A,0XFF,0XFF,0XF8,0XFF,
0X33,0XCF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X1B,0XFF,0XFF,0XFF,
0XF8,0XFC,0XF3,0X3F,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,
0XFF,0XFF,0XF8,0XFF,0X03,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X3F,0XFF,0XFF,0X9B,0XF8,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X3F,0XFE,0X94,0X07,0XF8,0XF3,0X3C,0XCF,0X3F,0XFF,0XFF,0XFF,0XFC,0X03,
0XC3,0XFF,0XFF,0XFF,0X2E,0X50,0X00,0X07,0XF8,0XFC,0X33,0XC3,0X3F,0XFF,0XFF,0XFF,
0X00,0X03,0XC0,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X07,0XF8,0XFF,0X0F,0X0C,0XFF,0XFF,
0XFF,0XFF,0X03,0XCF,0XFC,0X3F,0XFF,0XFF,0X00,0X00,0X00,0X07,0XF8,0XF0,0X00,0XCC,
0XFF,0XFF,0XFF,0XFF,0X0F,0XCF,0XFC,0X3F,0XFF,0XFF,0X00,0X00,0X01,0X6F,0XF8,0XFC,
0X33,0XC0,0XFF,0XFF,0XFF,0XFF,0X0F,0XCF,0XFC,0X3F,0XFF,0XFF,0X00,0X01,0XAF,0XFF,
0XF8,0XF3,0X3C,0XCF,0X3F,0XFF,0XFF,0XFF,0X0F,0XC0,0X00,0XFF,0XFF,0XFF,0X06,0XBF,
0XFF,0XFF,0XF8,0XFF,0XC3,0XFF,0X3F,0XFF,0XFF,0XFF,0X0F,0XF0,0X03,0XFF,0XFF,0XFF,
0X2F,0XFF,0XFF,0XFF,0XF0,0XF0,0X3C,0X3C,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X3F,0XFF,0XFF,0XFA,0X40,0XFF,0X3F,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X0F,0XFF,0XFF,0XFF,0X3F,0XFF,0XF9,0X40,0X00,0XFF,0X00,0X3C,0XFF,0XFF,0XFF,0XFF,
0XFF,0XF0,0X0F,0XFF,0XFF,0XFF,0X3F,0XE5,0X00,0X01,0X64,0XFF,0X3F,0XFF,0X3F,0XFF,
0XFF,0XFF,0XFF,0XC3,0X0F,0XFF,0XFF,0XFF,0X14,0X00,0X01,0XAF,0XF8,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFC,0X0F,0X0F,0XFF,0XFF,0XFF,0X00,0X06,0XBF,0XFF,0XF8,0XF3,
0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0XFF,0X0F,0XFF,0XFF,0XFF,0X16,0XFF,0XFF,0XFF,
0XF8,0XF0,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X3F,0XFF,0XFF,0X3F,0XFF,
0XFF,0XFF,0XF8,0XF3,0XF3,0XF3,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X3F,0XFF,0XFF,
0X3F,0XFF,0XFF,0XE9,0X00,0XF3,0XF0,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0XFF,
0XFF,0XFF,0X3F,0XFF,0XFE,0X00,0X00,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XE0,0X00,0XF3,0XFC,0XCF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X1B,0XFF,0XFF,0XFE,0X40,0XF3,0X00,0XCF,0XFF,0XFF,
0XFF,0XFF,0XFC,0X03,0XC3,0XFF,0XFF,0XFF,0X00,0X6F,0XFF,0XFF,0XF4,0XF3,0XFC,0XCF,
0X3F,0XFF,0XFF,0XFF,0X00,0X03,0XC0,0XFF,0XFF,0XFF,0X00,0X01,0XBF,0XFF,0XF8,0XF3,
0XFC,0XCF,0X3F,0XFF,0XFF,0XFF,0X03,0XCF,0XFC,0X3F,0XFF,0XFF,0X00,0X00,0X5F,0XFF,
0XF8,0XF0,0X00,0XFF,0X3F,0XFF,0XFF,0XFF,0X0F,0XCF,0XFC,0X3F,0XFF,0XFF,0X00,0X6B,
0XFF,0XFF,0XF8,0XFF,0XFC,0X00,0XFF,0XFF,0XFF,0XFF,0X0F,0XCF,0XFC,0X3F,0XFF,0XFF,
0X2F,0XFF,0XFF,0XFF,0XF8,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0XC0,0X00,0XFF,
0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XA4,0XFF,0XCF,0XC3,0XFF,0XFF,0XFF,0XFF,0X0F,0XF0,
0X03,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0X90,0X00,0XFF,0XCC,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFE,0X50,0X00,0X14,0XF0,0X00,0X00,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X2A,0X40,0X00,0X5B,0XF8,0XFF,0XCC,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X01,0X6F,0XFF,0XF8,0XFF,
0XCF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X01,0XAF,0XFF,0XFF,
0XF8,0XFF,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0X2F,0XFF,
0XFF,0XFF,0XF8,0XFC,0X00,0X00,0X3F,0X00,0X00,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,
0X3F,0XFF,0XFF,0XFE,0X50,0XFC,0XF3,0X3C,0XFF,0X3F,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X3F,0XFF,0XFA,0X40,0X00,0XFC,0XF3,0X3C,0XFF,0X3F,0XFC,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X3F,0XE9,0X40,0X00,0X54,0XFC,0XF3,0X3C,0XFF,0XC0,0X03,0XFF,
0XF0,0X00,0X03,0XFF,0XFF,0XFF,0X15,0X00,0X00,0X6B,0XF8,0XFC,0X00,0X00,0X3F,0XFF,
0XFF,0XFF,0XC0,0X00,0X00,0X3F,0XFF,0XFF,0X00,0X01,0XAF,0XFF,0XF8,0XFF,0XFF,0XCF,
0XFF,0XC0,0XFF,0XFF,0X0F,0XFF,0XFC,0X3F,0XFF,0XFF,0X05,0XBF,0XFF,0XFF,0XF8,0XFF,
0X3C,0X3F,0XFF,0X3F,0X30,0XFF,0X0F,0XFF,0XFC,0X3F,0XFF,0XFF,0X2F,0XFF,0XFF,0XFF,
0XF8,0XF0,0X00,0X00,0X3F,0X3F,0X3C,0XFF,0X0F,0XFF,0XFC,0X3F,0XFF,0XFF,0X3F,0XFF,
0XFF,0XFA,0X40,0XFF,0X3C,0XFF,0X3F,0X3F,0X3C,0XFF,0XC0,0X00,0X00,0XFF,0XFF,0XFF,
0X3F,0XFF,0XFE,0X40,0X00,0XFF,0X3F,0X3C,0XFF,0XC0,0X03,0XFF,0XF0,0X00,0X03,0XFF,
0XFF,0XFF,0X3F,0XFF,0XFF,0X90,0X00,0XFC,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X1F,0XFF,0XFF,0XFE,0X40,0XFC,0XFF,0XFF,0XFF,0XC0,0X03,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X01,0XBF,0XFF,0XFF,0XF4,0XFC,0XFF,0XFF,0XFF,0X3F,
0XFC,0XFF,0XF0,0X00,0X03,0XFF,0XFF,0XFF,0X00,0X06,0XFF,0XFF,0XF8,0XFC,0X00,0X00,
0X3F,0X3F,0XFC,0XFF,0XC0,0X00,0X00,0X3F,0XFF,0XFF,0X00,0X00,0X2F,0XFF,0XF8,0XFF,
0XFF,0XFF,0X3F,0X3F,0XFC,0XFF,0X0F,0XFF,0XFC,0X3F,0XCF,0XFF,0X00,0X1A,0XFF,0XFF,
0XF8,0XFF,0XFF,0XF0,0X3F,0XC0,0X03,0XFF,0X0F,0XFF,0XFC,0X3F,0X3F,0XFF,0X1B,0XFF,
0XFF,0XFF,0XF8,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0XFF,0XFC,0X3C,0X00,0X0F,
0X3F,0XFF,0XFF,0XFF,0XE4,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0XFF,
0XFF,0XFF,0X3F,0XFF,0XFF,0XE5,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,
0X03,0XFF,0XFF,0XFF,0X3F,0XFF,0X94,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X2E,0X90,0X00,0X1A,0XF4,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X6B,0XFF,0XF8,0XFF,0XFF,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0XFF,0X01,0X6F,0XFF,0XFF,0XF8,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X1F,0XFF,0XFF,0XFF,
0XF8,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0XFF,0X2F,0XFF,
0XFF,0XFF,0XF8,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X3F,0XFF,0XFE,0X5B,0XF8,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X3F,0XFA,0X40,0X07,0XF8,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X3F,0XFF,0XFF,0X3F,0XD0,0X00,0X07,0XF8,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X3F,0XCF,0X3F,0XC0,0X6A,0X07,0XF8,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0X0F,0X3F,0XC1,0XFF,0X07,0XF8,0XFF,0XFF,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3C,0XFC,0XCF,0X3F,0XC1,0XFF,0X1B,0XF8,0XFF,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3C,0XF3,0XCF,0X3F,0XC1,0XFF,0XFF,
0XF8,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0XCF,0X3F,0XC1,
0XFF,0XFF,0XF8,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,
0X3F,0XC1,0XFF,0XFF,0XF8,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,
0X3F,0X3F,0X3F,0XC1,0XFF,0XFE,0X50,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X3C,0XFF,0XCF,0X3F,0XC1,0XF9,0X40,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X3C,0XF3,0XCF,0X3F,0XC0,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XF3,0XCF,0X15,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0X0C,0X3F,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,
0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0XFF,0X00,0X00,
0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XCC,0XFF,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,
0X3C,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X3C,0XFC,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X3F,0XFC,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3C,0X0F,0X0F,0X00,0X00,0X00,0X00,
0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3C,0XCF,0XCF,0X00,0X00,
0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XCF,0XCF,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0XF0,0X3F,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X3F,0X00,0X3F,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XCF,0XCF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XCF,0XCF,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XCF,0XCF,0X00,0X00,0X00,0X00,
0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X30,0X3F,0X00,0X00,
0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X3C,0XFF,0X0F,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0XF0,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XCF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3C,0X3F,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,
0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,
0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X0F,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,
0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0X00,0X00,
0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X3F,0X0C,0X3F,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0XF3,0XCF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XF3,0XCF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XF3,0XCF,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0X0C,0X3F,0X00,0X00,0X00,0X00,
0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0X00,0X00,
0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0X03,0X3F,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0XFC,0XCF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X3C,0XFC,0XCF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0XFC,0XCF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X3F,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0X00,0X00,0X00,0X00,
0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0X00,0X00,
0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3C,
0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X3F,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X3F,0X00,0X3F,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3C,0XFF,0XCF,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3C,0XFF,0XCF,0X00,0X00,0X00,0X00,
0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XCF,0X00,0X00,
0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X3F,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,
0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X3F,0XCF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X3F,0X3F,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X0F,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,
0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0X00,0X00,
0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0X03,0X3F,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0XFC,0XCF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X3C,0XFC,0XCF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X3C,0XFC,0XCF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X3F,0X00,0X3F,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0X00,0X00,0X00,0X00,
0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X0F,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X0F,0XFF,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,};


const unsigned char gImage_sushi[3096] = { /* 0X81,0X02,0XAC,0X00,0X48,0X00, */
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XF3,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X0C,0XFF,0XFF,0XFF,0XCF,0XFF,0XC3,0XFF,0XCF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0XC3,0X3F,0XFF,0XFF,0XCF,0XFF,0XC3,0XFF,0XCF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0X30,0XFF,0XFF,0XFF,0XCF,0XFF,0X0F,0XFF,
0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCC,0X0F,0XFF,0XFF,0XFF,0XCF,0XFF,
0X0F,0XFF,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X33,0XFF,0XFC,0X00,
0X00,0X00,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0XC3,0X0F,0XFF,
0XFC,0X00,0X00,0X00,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0C,0X30,
0XCF,0XFF,0XFC,0XFF,0X0F,0XF0,0XFF,0XFF,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,
0XC0,0XC0,0X0F,0XFF,0XFF,0XFF,0X0F,0XF3,0XFF,0XF0,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFC,0XCF,0X30,0X03,0X03,0XFF,0XFF,0XFF,0X0F,0XF3,0XF0,0X00,0XCF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XF0,0X3C,0X0C,0X00,0XCF,0XFF,0XFC,0X00,0X00,0X00,0X00,0X0F,0XCF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X0C,0XC0,0X00,0X30,0X33,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,
0XCF,0XFF,0XFF,0XFF,0XFF,0XFC,0X33,0XC3,0X00,0X00,0XCF,0XFF,0XFF,0X3F,0X3C,0XFF,
0X3F,0XCF,0XCF,0XFF,0XFF,0XFF,0XFF,0XC0,0XCC,0X30,0XCC,0X0C,0X0F,0XFF,0XFF,0X3F,
0X3C,0XFF,0X0F,0XCF,0XCF,0XFF,0XFF,0XFF,0XFF,0X0F,0X33,0X0F,0X33,0X03,0X3F,0XFF,
0XFF,0X3F,0X3C,0XFF,0X0F,0XCF,0XCF,0XFF,0XFF,0XFF,0XFC,0X30,0XCC,0XC0,0XCC,0X00,
0X0F,0XFF,0XFF,0X3F,0X3C,0XF0,0X3F,0XCF,0XCF,0XFF,0XFF,0XFF,0XF0,0XC3,0X33,0X33,
0X33,0XC0,0XC3,0XFF,0XFF,0X3F,0X3C,0X00,0X0F,0XCF,0XCF,0XFF,0XFF,0XFF,0X03,0X3C,
0XCC,0XCF,0X3C,0XCC,0X3F,0XFF,0XFF,0X3F,0X3C,0X0C,0X00,0X00,0X0F,0XFF,0XFF,0XFF,
0X3C,0X03,0X30,0X3C,0XFF,0X33,0X03,0XFF,0XFF,0X3F,0X3C,0XFC,0XF0,0X00,0X0F,0XFF,
0XFF,0XFC,0XC3,0X3C,0X33,0XCF,0XF3,0XCC,0X3F,0XFF,0XFF,0X3F,0X3C,0XFC,0XFF,0XCF,
0XCF,0XFF,0XFF,0XF0,0X30,0XC3,0XCF,0XF3,0X0C,0XC3,0X03,0XFF,0XFF,0X3F,0X3C,0XCC,
0XFF,0XCF,0XCF,0XFF,0XFF,0XCF,0X0F,0X33,0X00,0XFF,0XFF,0X30,0XCC,0XFF,0XFF,0X3F,
0X3C,0XC0,0XFF,0XCF,0XCF,0XFF,0XFF,0XC3,0XC3,0X0C,0XF3,0XFF,0XF3,0XCC,0X33,0XFF,
0XFF,0X3F,0X3C,0XF0,0XFF,0X0F,0XCF,0XFF,0XFF,0X30,0X30,0XC3,0X0F,0XCF,0XFF,0XF3,
0X0C,0XFF,0XFC,0X00,0X30,0XFC,0X0F,0X0F,0XCF,0XFF,0XFC,0XCC,0XCF,0X3C,0XFF,0XFC,
0XFF,0XC0,0X03,0X3F,0XFC,0X00,0X30,0XFC,0X0F,0X0F,0X0F,0XFF,0XFC,0X33,0X33,0X33,
0X3F,0XFF,0XFF,0XFC,0XC0,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,0XCF,0X0F,0XFF,0XFC,0XCC,
0X0C,0XCF,0XCF,0XFF,0XFF,0XF0,0X33,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0XFF,
0XF3,0X30,0XC3,0X03,0XFC,0XFF,0XFF,0XFC,0X0C,0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XCF,0XFF,0XF0,0XCF,0X30,0XF0,0XCF,0XFF,0XF3,0XCF,0X00,0X0C,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XCF,0X00,0X0C,0X0F,0X3C,0XFF,0XFF,0XF0,0XFF,0X0F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC3,0X3C,0XC3,0X3C,0XFF,0XFF,0XF3,0XFC,0XCC,0XC0,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3C,0XC3,0X33,0X0F,0X3F,0XFC,0XFC,0XC3,
0X00,0XCC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0X30,0XCC,0XCF,0XF3,0XFF,
0X3F,0X0F,0X33,0X33,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XCF,0X03,0X30,
0XFF,0XF3,0XCC,0XF0,0XFC,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0C,0X00,
0X30,0X0C,0XFF,0XCF,0XF0,0XF3,0X00,0XC0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0XF3,0XF3,0X0C,0XF3,0X3F,0XFF,0X33,0X03,0XC3,0X0F,0XFF,0XFF,0XFF,0X00,0X3F,0XFF,
0XFF,0XFC,0XC3,0X0C,0XCF,0X0C,0XCF,0XF3,0XCC,0XCC,0X30,0XF0,0XFF,0XFC,0X00,0X00,
0X0F,0XFF,0XFF,0XFC,0X3C,0X33,0X30,0X33,0XFF,0XFF,0X03,0X33,0X0F,0XC3,0XFC,0X00,
0X00,0X00,0X0F,0XFF,0XFF,0XFC,0XC3,0XCC,0XC3,0XCF,0XFF,0XCF,0X30,0XC0,0XF0,0X0C,
0XFC,0X00,0XC0,0X03,0XFF,0XFF,0XFF,0XFC,0XCC,0X30,0X3C,0X3C,0XFF,0XF0,0XCF,0X0C,
0XCC,0X30,0XFF,0X3F,0X03,0XFF,0XFF,0XFF,0XF3,0XFC,0XF3,0X0F,0X0C,0XCF,0XFF,0XFC,
0X3C,0X33,0X03,0XC3,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XC3,0XFC,0X0C,0XC0,0XC3,0XFF,
0XFF,0X03,0XC3,0X0C,0XC3,0X0C,0XFF,0XC0,0XFF,0XFF,0XFF,0XFF,0X0F,0XF3,0XCC,0X33,
0X33,0X3F,0XFF,0XCC,0XC0,0XCF,0X30,0X03,0XFF,0XC3,0XFF,0XFF,0XFF,0XFC,0X3F,0XF0,
0X33,0X0C,0XCC,0XC3,0XFF,0X33,0X0C,0X30,0XC3,0X3C,0XFF,0X0F,0XFF,0XFF,0XFF,0XF0,
0XFF,0XFC,0XC0,0XF0,0X33,0XFF,0XF0,0X3C,0XF3,0XF0,0X3C,0XC3,0XFF,0X3F,0XFF,0XFF,
0XFF,0X03,0XFF,0XF3,0X3F,0X03,0X00,0X33,0XFC,0XCC,0X0C,0X0C,0X00,0XC3,0XFF,0X0F,
0XFF,0XFF,0XF0,0X0F,0XFF,0XFC,0XC3,0X3C,0XCC,0XCC,0XC3,0X30,0XC3,0X0C,0XC3,0X30,
0XFF,0XC0,0XFF,0XFC,0X00,0X3F,0XFF,0XF0,0X30,0XF0,0X33,0X33,0X0C,0XFC,0XFC,0XF3,
0X3C,0X30,0XFF,0XF0,0X00,0X00,0X03,0XFF,0XFF,0XF3,0X0C,0X0C,0XC0,0XCC,0XF3,0X33,
0X0F,0X03,0X0F,0X0F,0XFF,0XFC,0X00,0X00,0X3F,0XFF,0XFF,0XF0,0XCF,0X33,0X03,0X33,
0X0F,0XF0,0XC0,0X0C,0X3C,0X30,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0X30,0XC0,
0XCC,0X0C,0XFC,0X3C,0XF0,0XF0,0XF3,0XCC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,
0XC3,0X3C,0X30,0XF0,0X30,0XC3,0X33,0X0C,0XC3,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XF3,0X3C,0XC3,0X00,0XC3,0XF3,0XCF,0XCC,0X33,0X3C,0XC3,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0XC3,0X30,0X0C,0X3F,0X0C,0X33,0X0C,0XCF,0X0C,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X30,0XC3,0X0C,0X0C,0XC3,0X0F,0XF3,0X00,0XC3,0XCC,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0X0C,0X30,0XC3,0XCF,0XFF,0XFC,0X30,0X3F,
0X3C,0X33,0XFF,0XFF,0XFF,0X3F,0XCF,0XFF,0X3F,0XF0,0XF3,0X0C,0X00,0X3F,0X00,0XF0,
0X0C,0XF0,0XC3,0XCF,0XFF,0XCF,0XFF,0X3F,0XCF,0XFF,0X3F,0XFC,0X30,0XC3,0X0C,0X3C,
0X3C,0XFF,0XC3,0X03,0X0C,0XFC,0XFF,0XCF,0XCF,0X3F,0XCF,0XFC,0X3F,0XFC,0X30,0X30,
0X33,0XFF,0XF3,0X30,0XFF,0X30,0XCF,0X33,0XFF,0XCF,0XCF,0X3F,0XCF,0XF0,0XFF,0XFF,
0X0F,0X0C,0XC0,0XCC,0X33,0XCC,0X0C,0XFF,0XFC,0XFF,0XFF,0XCF,0XCF,0X3F,0XCF,0XC3,
0XFF,0XFF,0X30,0XF0,0X0F,0XCF,0X0C,0XC3,0XC0,0XC0,0XF0,0XCC,0XFF,0XCF,0XCF,0X3F,
0XCF,0X03,0XFF,0XFF,0XCC,0X03,0X30,0XF3,0XF3,0XCC,0X3F,0X0F,0X33,0XF3,0XFF,0XCF,
0XCF,0X3F,0XCC,0X0F,0XFF,0XFF,0X0C,0X3C,0XC3,0X0C,0X3F,0X3C,0XC3,0X3C,0XCF,0X3F,
0XFF,0XCF,0XCF,0X3F,0XC0,0X3F,0XFF,0XFF,0XC3,0X00,0X0F,0XCF,0XCF,0X33,0X00,0XC3,
0X0F,0XF3,0XFF,0XCF,0XCF,0X3C,0X00,0XFF,0XFF,0XFF,0XCC,0XC3,0X30,0XCC,0X3F,0X30,
0XF3,0X0F,0X3F,0XFF,0XFF,0XCF,0XCF,0X00,0X0F,0X3F,0XFF,0XFF,0XC3,0X3C,0XC3,0X33,
0XF0,0XF0,0XCF,0X0F,0XF3,0X3C,0XF0,0X00,0X00,0X00,0XCF,0X0F,0XFF,0XFF,0XF0,0X00,
0X3C,0XCC,0X3F,0XFF,0X33,0XF0,0XCF,0XFF,0XF0,0X00,0X00,0X3F,0XCF,0X00,0XFF,0XFF,
0XCC,0XC3,0X03,0X03,0XCC,0X0C,0XC3,0XCC,0XFF,0XCF,0XF0,0X00,0XCF,0X3F,0XCF,0XC0,
0XCF,0XFF,0XF3,0X3C,0XCC,0XFC,0X33,0XF0,0X30,0X03,0XFC,0XF3,0XFF,0XCF,0XCF,0X3F,
0XCF,0XF3,0XCF,0XFF,0XF0,0XC3,0X03,0X03,0XC0,0XFF,0X0C,0XCF,0X3F,0XFF,0XFF,0XCF,
0XCF,0X3F,0XCF,0XFF,0XCF,0XFF,0XFC,0X00,0XF3,0XCC,0X3C,0X03,0XC3,0X33,0XCF,0X33,
0XFF,0XCF,0XCF,0X3F,0XCF,0XFF,0XCF,0XFF,0XFF,0XF3,0X0F,0X30,0X03,0XC0,0X30,0XCF,
0XFF,0XC0,0XFF,0XCF,0XCF,0X3F,0XCF,0XFF,0XC3,0XFF,0XFF,0XFC,0X30,0XFF,0XF0,0X3C,
0XCC,0XCF,0XF3,0X3C,0XFF,0XCF,0XCF,0X3F,0XCF,0XFF,0XC3,0XFF,0XFF,0XFF,0X0F,0X33,
0X0F,0XFF,0XF3,0X30,0XCF,0XC3,0XFF,0XCF,0XCF,0X30,0X00,0X00,0X03,0XFF,0XFF,0XFF,
0XC3,0XCC,0XF0,0X00,0X00,0XCF,0X3F,0X30,0XFF,0XCF,0XCF,0X30,0X00,0X00,0X03,0XFF,
0XFF,0XFF,0XC0,0X33,0X0C,0X30,0XCF,0X3F,0XFF,0X0F,0XFF,0XCF,0X0F,0X30,0XCF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XCF,0X0C,0XF3,0XCC,0X30,0XF3,0XCC,0XC3,0XFF,0X0F,0X0F,0X3F,
0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0XC3,0X03,0X03,0XC3,0X0F,0X33,0X0C,0XFF,0X0F,
0X0C,0X3F,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XCC,0X30,0X30,0X3C,0XFF,0XFC,0X30,
0XFF,0X0F,0XCC,0X3F,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X33,0XCF,0X3C,0X03,0X33,
0X3C,0X0F,0XFF,0XCF,0XFC,0X3F,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0XC0,0X30,0XC3,
0XC0,0XCF,0XCC,0XF0,0XFF,0XFF,0XFF,0X3F,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XCC,
0X0C,0X3C,0X3C,0XF3,0X30,0X0C,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFC,0X33,0XC3,0X30,0X00,0XF3,0XFC,0X33,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0X0C,0X3C,0X0F,0X3C,0X3F,0XCF,0X0C,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFC,0XC3,0X03,0XC3,0X0F,0XCF,0XFF,0XC3,0XFF,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X33,0XCC,0X30,0XC0,0XF0,0XF0,0X33,0XFF,0X3F,
0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X30,0XCF,0X3C,0X3C,0X03,0X3F,
0XFF,0X3F,0XCF,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XC3,0X0F,0X00,0XC3,0XC3,
0X33,0XFF,0XFF,0X3F,0XCF,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XC0,0XF3,
0X0F,0XF0,0XC3,0XFF,0XFF,0X3F,0XCF,0XCF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,
0X3C,0X3C,0XFF,0XF0,0X3F,0XFF,0XFF,0X3F,0XCF,0XCF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XF3,0X03,0X00,0XCF,0XF3,0XFF,0XFF,0XFF,0X3F,0XCF,0XCF,0XFC,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0XCC,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XCF,0XCF,0XFC,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X33,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XCF,0XCF,
0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,
0XCF,0XCF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0X3F,0XCF,0XCF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0X3F,0XCF,0XCF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XCF,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0X0F,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0X0F,0XCF,0XFF,0XFF,0XCF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0X0F,0XFF,0XFF,0XFF,
0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0X0F,0XFF,
0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,
0XCF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,
0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,
0X00,0X00,0X00,0X00,0XFC,0X00,0X00,0X00,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,
0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XC0,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0XC0,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0XC0,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,
0XC0,0X0F,0XFC,0X00,0X03,0XFF,0XF0,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XC0,0X3F,0XFC,0X00,0X03,0XFF,0XFC,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XC0,0X3F,0XFC,0X00,0X03,0XFF,0XFF,0X00,0XFF,0XFF,0XFF,0XFF,
0XC0,0X00,0X00,0X00,0X00,0X00,0XC0,0XFF,0XFC,0X00,0X03,0XFF,0XFF,0X00,0XFF,0XFF,
0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0XC0,0XFF,0XFC,0X00,0X03,0XFF,0XFF,0XC0,
0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0XC0,0XFF,0XFC,0X3F,0XC3,0XFF,
0XFF,0XC0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XFF,0X00,0X3F,
0XC0,0X00,0X3F,0XC0,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0XC0,0XFF,
0X00,0X3F,0XF0,0X00,0X3F,0XC0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XC0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,
0X00,0X00,0XC0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,
0X00,0X00,0X00,0X00,0XC0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X3F,0XFF,0XF3,0XFF,0XFF,0XFF,0X00,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X0F,0XFF,0XF3,0XFF,0XFF,0XFC,0X00,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X03,0XFF,0XC0,0XFF,0XFF,
0XC0,0X00,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0XC0,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XC0,0X00,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XC0,0X0F,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0XFF,0XFF,0XFF,0XFF,
0XC0,0X00,0X00,0X00,0X00,0X00,0XC0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,
0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0XC0,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XC0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XC0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XFF,
0X00,0X00,0X00,0X00,0X3F,0XC0,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,
0XC0,0XFF,0X00,0X00,0X00,0X00,0X3F,0XC0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XC0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XC0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0XFF,0XFF,
0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0XC0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X0F,0XFF,0XFF,0XFF,0XFF,
0XFC,0X00,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0XC0,0X00,0XFF,0XFF,
0XFF,0XFF,0XC0,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,
0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,
0X00,0X00,0X00,0X00,0XC0,0X00,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X0F,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,
0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0XC0,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XC0,0XFF,0XFF,0XFC,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XFF,0XF0,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XC0,0XFF,0X00,0X00,0X00,0X00,0X3F,0XC0,0XF0,0X00,0X03,0XFF,0XC0,0X00,0X00,0X00,
0X00,0X00,0XC0,0XFF,0X00,0X00,0X00,0X00,0X3F,0XC0,0XF0,0X03,0XFF,0XFF,0XC0,0X00,
0X00,0X00,0X00,0X00,0XC0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XFF,0XFF,0XFF,0XFF,
0XC0,0X00,0X00,0X00,0X00,0X00,0XC0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,
0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0XC0,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X0F,0XFF,0XFF,
0XFF,0XFF,0XFC,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,
0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0XFC,0X03,0XFF,0X03,0XC0,0X00,0X00,0X00,0X00,0X00,
0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X03,0XF0,0X03,0XC0,0X00,0X00,0X00,
0X00,0X00,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0XFF,0X00,0X03,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X00,0X00,0XC3,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X00,
0X0F,0XC3,0XC0,0X00,0X00,0X00,0X00,0X00,};


const unsigned char gImage_20off[3096] = { /* 0X01,0X02,0XAC,0X00,0X48,0X00, */
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XAA,0XFE,0X0B,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFD,0X00,0X3D,0X01,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XF8,0X00,0X1F,0X00,0X7F,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X18,0X0B,0XE0,0X3F,0XFF,0XF0,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X3D,0X07,0XF8,0X2F,0XFF,0XF0,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X7E,0X07,0XF8,0X2F,0XFF,
0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X3F,0X42,0XF8,
0X2F,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFE,0X95,0X56,0XAB,0XFF,0XFF,0XFF,0XF4,0X07,
0X40,0XA0,0X3F,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XD0,0X00,0X00,0X00,0X5B,0XFF,0XFF,
0XFC,0X03,0XC0,0X00,0X7F,0XFF,0XE1,0X1F,0XFF,0XFF,0XF8,0X00,0X00,0X00,0X00,0X00,
0X6F,0XFF,0XFF,0X42,0XE0,0X01,0XFF,0XFF,0XD2,0X0F,0XFF,0XFF,0X80,0XAE,0X00,0X00,
0X00,0X00,0X0F,0XFF,0XFF,0XFB,0XF9,0X59,0XBF,0XFF,0XF0,0X2F,0XFF,0XF4,0X1B,0XFF,
0X00,0X00,0X00,0X00,0X07,0XFF,0XFF,0XFF,0XFF,0X54,0X2F,0XFF,0XF0,0X3F,0XFE,0X41,
0XFF,0XFF,0X80,0X00,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XE9,0X00,0X3F,0XFF,0XF0,0X3F,
0XD0,0X1F,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X03,0XFF,0XFF,0XFA,0X40,0X01,0XBF,0XFF,
0XF0,0X3D,0X02,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X02,0XFF,0XFF,0X90,0X00,0X1F,
0XFF,0XFF,0XF0,0X10,0X7F,0XFF,0XFF,0XFF,0XD0,0X00,0X00,0X00,0X01,0XFF,0XF8,0X00,
0X10,0X3F,0XFF,0XFF,0XF0,0X02,0XFF,0XFF,0XFF,0XFF,0XE0,0X00,0X00,0X00,0X00,0XFF,
0XF0,0X02,0XB4,0X3F,0XFF,0XFF,0XE0,0X1F,0XFF,0XFF,0XFF,0XFF,0XE0,0X00,0X00,0X00,
0X00,0XFF,0XF0,0X02,0XF4,0X3F,0XFF,0XFF,0X40,0X3F,0XFF,0XFF,0XFF,0XFF,0XE0,0X00,
0X00,0X00,0X00,0XFF,0XF4,0X00,0X10,0X3F,0XFF,0XFF,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,
0XD0,0X00,0X00,0X00,0X00,0XBF,0XFF,0X90,0X00,0X2F,0XFF,0XFF,0X40,0X3F,0XFF,0XFF,
0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0XBF,0XFF,0XFE,0X40,0X01,0XBF,0XFF,0XD0,0X2F,
0XFF,0XFF,0XFF,0XFF,0X40,0X00,0X00,0X00,0X00,0XBF,0XFF,0XFF,0XF4,0X00,0X2F,0XFF,
0XF0,0X0B,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0XBF,0XFF,0XFF,0XFF,0XD0,
0X2F,0XFF,0XF0,0X00,0XBF,0XFF,0XFF,0XFD,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,
0XFF,0XFE,0X6F,0XFF,0XF0,0X28,0X1F,0XFF,0XFF,0XFD,0X00,0X00,0X00,0X00,0X00,0XFF,
0XF0,0X00,0X00,0X00,0X2F,0XFF,0XF0,0X3F,0X41,0XFF,0XFF,0XFD,0X00,0X00,0X00,0X00,
0X00,0XFF,0XF0,0X00,0X00,0X00,0X2F,0XFF,0XF0,0X3F,0XFC,0X0F,0XFF,0XFC,0X00,0X00,
0X00,0X00,0X02,0XFF,0XFA,0XAA,0XAA,0XA4,0X2F,0XFF,0XF0,0X3F,0XFF,0XD0,0X6F,0XF8,
0X00,0X00,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XF8,0X2F,0XFF,0XF0,0X3F,0XFF,0XFF,
0X40,0XA0,0X00,0X00,0X00,0X00,0X07,0XFF,0XFF,0XFF,0XFF,0XF8,0X2F,0XFF,0XF0,0X3F,
0XFF,0XFF,0XFD,0X40,0X00,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XF8,0X2F,0XFF,
0XF0,0X3F,0XFF,0XFF,0XFF,0XFD,0X50,0X00,0X00,0X00,0X7F,0XFF,0XFF,0XFF,0XFF,0XF8,
0X2F,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XF8,0X2F,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFD,0X7F,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFA,0XAA,0XAA,0XAA,0XBF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X2F,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X2F,0XFF,0XF0,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X2B,0X02,0XA4,0X2F,0XFF,0XF0,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X7F,0X43,0XF8,0X2F,0XFF,
0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X7F,0X43,0XF8,
0X2F,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X7F,
0X43,0XF8,0X2F,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XF0,0X7F,0X43,0XF8,0X2F,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XF0,0X7F,0X43,0XF8,0X2F,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XF0,0X7F,0X47,0XF8,0X2F,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF5,0XBF,0XEF,0XF8,0X6F,0XFF,0XF0,0X3F,0XFF,0XFF,
0XFF,0XF9,0X00,0X00,0X00,0X16,0XFF,0XFF,0XFF,0XFF,0XFF,0XAF,0XFF,0XFF,0XF0,0X3F,
0XFF,0XFF,0XFF,0XD0,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0X91,0XBD,0X07,0XFF,0XFF,
0XF0,0X3F,0XFF,0XFF,0XFF,0X80,0X00,0X00,0X00,0X00,0XBF,0XFF,0XFC,0X00,0X2E,0X00,
0XBF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X7F,0XFF,0XF4,0X00,
0X0B,0X80,0X7F,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X7F,0XFF,
0XF4,0X2D,0X0B,0XF0,0X3F,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,
0X7F,0XFF,0XF0,0X7E,0X07,0XF8,0X2F,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0X00,0X00,0X00,
0X00,0X00,0X3F,0XFF,0XF0,0X7F,0X03,0XF8,0X2F,0XFF,0XF0,0X3F,0XFF,0XFF,0XFD,0X00,
0X00,0X00,0X00,0X00,0X2F,0XFF,0XF0,0X2F,0X42,0XF8,0X2F,0XFF,0XF0,0X3F,0XFF,0XFF,
0XF0,0X00,0X00,0X00,0X00,0X00,0X2F,0XFF,0XF8,0X07,0X40,0XE0,0X3F,0XFF,0XF0,0X3F,
0XFF,0XE5,0X00,0X00,0X00,0X00,0X00,0X00,0X2F,0XFF,0XFC,0X02,0XC0,0X00,0XBF,0XFF,
0XF0,0X3E,0X60,0X00,0X90,0X00,0X00,0X00,0X00,0X00,0X2F,0XFF,0XFF,0X42,0XE0,0X01,
0XFF,0XFF,0X90,0X01,0X7F,0XFF,0XFE,0X00,0X00,0X00,0X00,0X00,0X2F,0XFF,0XFF,0XFF,
0XFE,0X5B,0XFF,0XFF,0X40,0X3F,0XFF,0XFF,0XFF,0X40,0X00,0X00,0X00,0X00,0X2F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X80,0X3F,0XFF,0XFF,0XFF,0X40,0X00,0X00,0X00,0X00,
0X2F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X3F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,
0X00,0X00,0X2F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X07,0XFF,0XFF,0XFF,0XC0,
0X00,0X00,0X00,0X00,0X2F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X10,0X7F,0XFF,
0XFF,0XC0,0X00,0X00,0X00,0X00,0X2F,0XFF,0XFF,0XFE,0XBF,0XFE,0XFF,0XFF,0XF0,0X2D,
0X06,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X2F,0XFF,0XFF,0XFC,0X3F,0XF8,0XBF,0XFF,
0XF0,0X3F,0XD0,0X1F,0XFF,0X80,0X00,0X00,0X00,0X00,0X2F,0XFF,0XFF,0XF4,0XBA,0XF8,
0XBF,0XFF,0XF0,0X3F,0XFE,0X00,0XBF,0X40,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XE2,
0XF5,0XF8,0XBF,0XFF,0XF0,0X3F,0XFF,0XE4,0X05,0X00,0X00,0X00,0X00,0X00,0X7F,0XFF,
0XFF,0X82,0XF5,0XF8,0XBF,0XFF,0XF0,0X3F,0XFF,0XFF,0X40,0X00,0X00,0X00,0X00,0X00,
0X7F,0XFF,0XFD,0X25,0XF5,0XF8,0XBF,0XFF,0XF0,0X3F,0XFF,0XFF,0XE0,0X00,0X00,0X00,
0X00,0X00,0X7F,0XFF,0XE4,0XB9,0XB1,0XF4,0XBF,0XFF,0XF0,0X3F,0XFF,0XFF,0XF4,0X00,
0X00,0X00,0X00,0X00,0X7F,0XFF,0XC2,0XF8,0X00,0X00,0XBF,0XFF,0XF0,0X3F,0XFF,0XFF,
0XFC,0X00,0X00,0X00,0X00,0X00,0XBF,0XFF,0XE4,0XB9,0X60,0XA4,0XBF,0XFF,0XF0,0X3F,
0XFF,0XFF,0XFD,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFD,0X29,0XF5,0XF8,0XBF,0XFF,
0XF0,0X3F,0XFF,0XFF,0XFD,0X00,0X00,0X00,0X00,0X00,0XBF,0XFF,0XFF,0X42,0XF5,0XF8,
0XBF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFE,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XD2,
0XF5,0XF8,0XBF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X01,0XFF,0XFF,
0XFF,0XF1,0XF5,0XF8,0XBF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X02,
0XFF,0XFF,0XFF,0XF4,0XBF,0XF8,0XBF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0X40,0X00,0X00,
0X00,0X03,0XFF,0XFF,0XFF,0XF8,0XBF,0XF9,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XC0,
0X00,0X00,0X00,0X07,0XFF,0XFF,0XFF,0XFB,0XFF,0XFF,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,
0XFF,0XFA,0X55,0X40,0X00,0X0B,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFA,0XAA,0XBF,0XFF,0XFF,0XFF,0XD7,0XFF,0X9F,0XFF,0XFF,
0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC3,0XFF,0X0F,
0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XE5,0X41,
0X54,0X2F,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XE0,0X00,0X00,0X7F,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XC7,0XFC,0X7F,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XC7,0XF4,0XAF,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF7,0XFF,0XFF,0X4B,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XF8,0X3D,0X2E,0XFF,0XFF,0XF0,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XF0,0X51,0XF4,0XBF,0XFF,
0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XE4,0X02,0XFF,0XFF,0XF3,0XD0,0X1B,0XD1,
0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFE,0XAA,0XAA,0X40,0X00,0X00,0XBF,0XFF,0XF3,0X8C,
0XBD,0X0B,0XFF,0XFF,0XF0,0X3F,0XFF,0XA4,0X00,0X00,0X00,0X00,0X00,0X00,0X7F,0XFF,
0XF1,0X2C,0X00,0X7E,0XFF,0XFF,0XF0,0X3F,0XE4,0X00,0X16,0X90,0X00,0X00,0X00,0X00,
0X3F,0XFF,0XF0,0X78,0X1B,0XF8,0XBF,0XFF,0XF0,0X3D,0X00,0X1B,0XFF,0XFC,0X00,0X00,
0X00,0X00,0X2F,0XFF,0XF0,0XF8,0XBE,0XB4,0XBF,0XFF,0XF0,0X10,0X0B,0XFF,0XFF,0XFC,
0X00,0X00,0X00,0X00,0X1F,0XFF,0XE6,0XF8,0X00,0X01,0XFF,0XFF,0XF0,0X01,0XBF,0XFF,
0XFF,0XFD,0X00,0X00,0X00,0X00,0X1F,0XFF,0XFF,0XFD,0X6A,0XAB,0XFF,0XFF,0XF0,0X1F,
0XFF,0XFF,0XFF,0XFD,0X00,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XF0,0X3F,0XFF,0XFF,0XFF,0XFE,0X00,0X00,0X00,0X00,0X0B,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X0B,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XC0,0X3F,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X0B,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X80,0X3F,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,
0X07,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X40,0X3F,0XFF,0XFF,0XFF,0XFF,0X40,0X00,
0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X40,0X3F,0XFF,0XFF,0XFF,0XFF,
0X80,0X00,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X3F,0XFF,0XFF,
0XFF,0XFF,0X80,0X00,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X3F,
0XFF,0XFF,0XFF,0XFF,0X80,0X00,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XE2,0XFF,0XFF,
0X80,0X3F,0XFF,0XFF,0XFF,0XFF,0X80,0X00,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XD3,
0XFF,0XFF,0X80,0X3F,0XFF,0XFF,0XFF,0XFF,0X80,0X00,0X00,0X00,0X03,0XFF,0XFF,0XFF,
0XFF,0X82,0XFF,0XFF,0XC0,0X3F,0XFF,0XFF,0XFF,0XFF,0X80,0X00,0X00,0X00,0X03,0XFF,
0XFF,0XFF,0XFF,0X41,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0X80,0X00,0X00,0X00,
0X03,0XFF,0XFF,0XFF,0XFE,0X01,0XFF,0XFF,0XF0,0X2F,0XFF,0XFF,0XFF,0XFF,0X80,0X00,
0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFD,0X01,0XFF,0XFF,0XF0,0X07,0XFF,0XFF,0XFF,0XFF,
0X80,0X00,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFD,0X00,0XFF,0XFF,0XF0,0X00,0XBF,0XFF,
0XFF,0XFF,0X80,0X00,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF8,0X00,0XBF,0XFF,0XF0,0X20,
0X02,0XFF,0XFF,0XFF,0X80,0X00,0X00,0X00,0X07,0XFF,0XFF,0XFF,0XF4,0X00,0XBF,0XFF,
0XF0,0X3D,0X00,0X1B,0XFF,0XFF,0X40,0X00,0X00,0X00,0X0B,0XFF,0XFF,0XFF,0XE0,0X01,
0XFF,0XFF,0XF0,0X3F,0XC0,0X00,0X0A,0XFF,0X00,0X00,0X00,0X00,0X0B,0XFF,0XFF,0XFF,
0X80,0X02,0XFF,0XFF,0XF0,0X3F,0XF9,0X00,0X00,0X19,0X00,0X00,0X00,0X00,0X0F,0XFF,
0XFF,0XFF,0X40,0X0B,0XFF,0XFF,0XF0,0X3F,0XFF,0XE5,0X00,0X00,0X50,0X00,0X00,0X00,
0X1F,0XFF,0XFF,0XFD,0X00,0X2F,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XD4,
0X00,0X00,0X7F,0XFF,0XFF,0XF4,0X00,0XBF,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XF5,0X57,0XFF,0XFF,0XFF,0XE0,0X00,0XBF,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X80,0X00,0X6F,0XFF,0XFF,0XF0,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X80,0X07,0XFF,0XFF,0XFF,
0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XE4,0X2F,0XFF,
0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XF5,0X7F,0XFF,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XD0,0X0B,0XFF,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X80,0X01,0X6F,0XFF,0XFF,0XF0,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X2F,0XFF,0XFF,
0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0XBF,
0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X00,0X7F,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFE,0X00,0X0B,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFE,0X80,0X00,0X00,0X01,
0XBF,0XFF,0XFF,0XFF,0X80,0X02,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XF0,0X00,0X00,
0X00,0X00,0X0B,0XFF,0XFF,0XFF,0XD0,0X01,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XD0,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XF0,0X00,0XBF,0XFF,0XF0,0X3F,0XFF,0XFF,
0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XF8,0X00,0XBF,0XFF,0XF0,0X3F,
0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X2F,0XFF,0XFF,0XFD,0X00,0XBF,0XFF,
0XF0,0X3F,0XFF,0XFF,0XFF,0X80,0X00,0X00,0X00,0X00,0X00,0X2F,0XFF,0XFF,0XFE,0X00,
0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0X40,0X00,0X00,0X00,0X00,0X00,0X2F,0XFF,0XFF,
0XFE,0X01,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFE,0X00,0X00,0X00,0X00,0X00,0X00,0X2F,
0XFF,0XFF,0XFF,0X41,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XF4,0X00,0X00,0X00,0X00,0X00,
0X00,0X2F,0XFF,0XFF,0XFF,0X81,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0X40,0X00,0X00,0X00,
0X00,0X00,0X00,0X2F,0XFF,0XFF,0XFF,0XD3,0XFF,0XFF,0XF0,0X3F,0XFF,0X94,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X2F,0XFF,0XFF,0XFF,0XE2,0XFF,0XFF,0XF0,0X3F,0XE4,0X01,
0XAF,0X00,0X00,0X00,0X00,0X00,0X00,0X2F,0XFF,0XFF,0XFF,0XF6,0XFF,0XFF,0XF0,0X14,
0X01,0X6F,0XFF,0X40,0X00,0X00,0X00,0X00,0X00,0X2F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XF0,0X00,0X7F,0XFF,0XFF,0X40,0X00,0X00,0X00,0X00,0X00,0X2F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XC0,0X2F,0XFF,0XFF,0XFF,0X40,0X00,0X00,0X00,0X00,0X00,0X2F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X80,0X3F,0XFF,0XFF,0XFF,0X40,0X00,0X00,0X00,0X00,0X00,0X2F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X3F,0XFF,0XFF,0XFF,0X40,0X00,0X00,0X00,0X00,
0X00,0X2F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X3F,0XFF,0XFF,0XFF,0X00,0X00,0X00,
0X00,0X00,0X00,0X2F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X3F,0XFF,0XFF,0XFF,0X00,
0X00,0X00,0X00,0X00,0X00,0X2F,0XFF,0XBF,0XFB,0XFF,0XFF,0XFF,0X40,0X05,0X1A,0XFF,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X2F,0XFF,0X1F,0XD3,0XFE,0XFF,0XFF,0XE0,0X00,
0X00,0X15,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X2F,0XFF,0X1F,0XC7,0XF8,0XFF,0XFF,
0XF0,0X00,0X00,0X00,0X05,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XD1,0X01,0X01,0X50,
0XBF,0XFF,0XF0,0X2A,0X40,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XC0,0X00,
0X00,0X02,0XFF,0XFF,0XF0,0X3F,0XFE,0X40,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,
0XFF,0X0E,0X1F,0XFF,0XFF,0XFF,0XF0,0X3F,0XFF,0XFA,0X40,0X00,0X00,0X00,0X00,0X00,
0X00,0X3F,0XFF,0X1F,0X6F,0XF4,0X7F,0XFF,0XF0,0X3F,0XFF,0XFF,0XE5,0X00,0X00,0X00,
0X00,0X00,0X00,0X3F,0XFF,0X9F,0XAE,0X41,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0X00,
0X00,0X00,0X00,0X00,0X00,0X3F,0XF8,0X00,0X00,0X1B,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,
0XFF,0X80,0X00,0X00,0X00,0X00,0X00,0XBF,0XF4,0X50,0X56,0XFF,0XFF,0XFF,0XF0,0X3F,
0XFF,0XFF,0XFF,0X80,0X00,0X00,0X00,0X00,0X00,0XBF,0XF1,0XF1,0XFF,0XFF,0XFF,0XFF,
0XF0,0X2F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0XFF,0XF1,0XF0,0XBF,0XFE,
0XBF,0XFF,0XD2,0X0F,0XFF,0XFF,0XFF,0XD0,0X00,0X00,0X00,0X00,0X00,0XFF,0XF1,0XF4,
0X55,0X50,0X7F,0XFF,0XE1,0X1F,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X00,0X02,0XFF,
0XF2,0XF0,0XAA,0XA8,0XBF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFD,0X00,0X00,0X00,0X00,
0X07,0XFF,0XE3,0XF0,0XFF,0XFF,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0X94,0X00,
0X00,0X00,0X6F,0XFF,0XFF,0XF5,0XFF,0XFF,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XAA,0X40,0X6B,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF8,0XBF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,};


const unsigned char gImage_chessboard[3096] = { /* 0X81,0X02,0XAC,0X00,0X48,0X00, */
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,
0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,
0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,
0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,
0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,
0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,
0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,
0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,
0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,
0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,
0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,
0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,
0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,
0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,
0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,
0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,
0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,
0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,
0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,
0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,
0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,
0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,
0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,
0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,
0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,
0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,
0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,
0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,
0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,
0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,
0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,
0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,
0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,
0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,
0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,
0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,
0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,
0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,
0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,
0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XC0,0X00,0X00,
0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,
0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,
0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,
0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,
0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,
0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,
0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,
0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,
0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,
0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,
0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,
0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,
0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,
0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,
0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,
0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,
0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,
0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,
0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,
0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,
0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,
0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,
0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,
0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,
0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,
0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,
0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,
0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,
0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,
0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,
0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,
0XFF,0XFF,0XC0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,
0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,
0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,
0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,
0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,
0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,
0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,
0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,
0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,
0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,
0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,
0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,
0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,
0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,
0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,
0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,
0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,
0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,
0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,
0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,
0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,
0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,
0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,
0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,
0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,
0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,
0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,
0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,
0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,
0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,
0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,
0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,
0X00,0X00,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,
0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,
0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,
0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,
0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,
0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,
0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,
0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,
0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,
0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,
0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,
0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,
0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,
0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,
0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,
0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,
0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,
0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,
0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,
0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,
0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,
0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,
0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,
0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,
0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,
0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,
0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,
0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,
0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,
0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,
0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,
0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,
0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X3F,0XFF,
0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,
0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,
0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,
0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,
0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,
0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,
0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,
0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,
0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,
0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,
0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,
0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,
0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,
0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,
0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X3F,
0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,
0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,
0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,
0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,
0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,
0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,
0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,
0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,
0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,
0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,
0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,
0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,
0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,
0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,
0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,
0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,
0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XC0,0X00,0X00,
0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,
0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,
0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,
0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,
0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,
0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,
0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,
0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,
0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,
0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,
0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,
0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,
0X3F,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0X00,
0X00,0X00,0X3F,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,};


const unsigned char gImage_royalty[3096] = { /* 0X01,0X02,0XAC,0X00,0X48,0X00, */
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0X33,0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X33,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X3C,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XCF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XF3,0X3F,0XCF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XF3,0XCF,0XCF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,
0X3F,0X3F,0XFF,0XFF,0XCF,0X3F,0XFF,0XFF,0XCF,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0X3F,0X30,0XFF,0XFF,0XFC,0XCF,0X3F,0XFF,0XFF,0XCF,0XFF,0XF3,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0X3F,0X3F,0XFF,0XFF,0XCC,0XCC,0XFF,0XFF,0XFF,0XC0,0X00,0X03,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0X3F,0XFF,0XFF,0XF0,0XC0,0X00,0XFF,0XFF,0XCF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0X30,0XFF,0XFF,0XFC,0X0C,0XFC,0XFF,0XFF,
0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X3F,0X0F,0XFF,0XC0,0XCC,0XCC,
0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0XCC,0XCC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XF0,0XC0,0X0C,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X3F,0XCF,0XFF,0XCC,0XCC,0XFC,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0XFF,0XCF,0XFF,0XFC,0XCF,0X30,0XFF,0XFF,0XF0,0X03,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XC3,0X3F,0X3F,0XFF,0XFF,0XCF,0X3F,0XFF,0XFF,0X33,0X33,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0X3C,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC3,0X33,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XF0,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XCF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XC3,0X33,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XCF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X33,0X33,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0X3F,0XCF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0X33,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC3,
0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X03,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X3F,0XFF,0XFF,0XFC,0X03,0XFF,0XFF,0XFF,
0X3F,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XCF,0X0F,0XFF,0XF3,0XFC,0XF0,
0XFF,0XFF,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XCF,0XCF,0XFF,0XF3,
0XFC,0XFC,0XFF,0XFF,0X3F,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XCF,0XCF,
0XFF,0XF3,0XFC,0XFC,0XFF,0XFF,0X3F,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,
0X3F,0X3F,0XFF,0XFC,0XF3,0XF3,0XFF,0XFF,0X3F,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XF0,0X00,0XFF,0XFF,0XFF,0X00,0X0F,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0XFF,0XFF,
0XFF,0X3C,0XCF,0X3F,0XFF,0XC0,0X3F,0XFF,0XFF,0XFC,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0X0C,0XC0,0XFF,0XFF,0X3F,0XCF,0X0F,0XFF,0XF3,0XFC,0XF0,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0X30,0XCF,0XCF,0XFF,0X3F,0XCF,0XCF,0XFF,0XF3,0XFC,0XFC,
0XFF,0XFF,0XF0,0X00,0XFF,0XFF,0XFC,0X3C,0X00,0X0F,0XFF,0X3F,0XCF,0XCF,0XFF,0XF3,
0XFC,0XFC,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0X00,0XC3,0XFF,0XFF,0XCF,0X3F,0X3F,
0XFF,0XFC,0XF3,0XF3,0XFF,0XFF,0X3F,0XFF,0XCF,0XFF,0XFF,0X3C,0XCC,0XCF,0XFF,0XF0,
0X00,0XFF,0XFF,0XFF,0X00,0X0F,0XFF,0XFF,0X3F,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0X00,
0X00,0XFF,0XFF,0XC0,0X3F,0XFF,0XFF,0XFC,0X03,0XFF,0XFF,0XFF,0XF0,0X00,0XFF,0XFF,
0XFF,0X3C,0XFF,0XFF,0XFF,0X3F,0XCF,0X0F,0XFF,0XF3,0XFC,0XF0,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFC,0XFC,0X00,0X0F,0XFF,0X3F,0XCF,0XCF,0XFF,0XF3,0XFC,0XFC,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFC,0XFC,0XFF,0XFF,0XFF,0X3F,0XCF,0XCF,0XFF,0XF3,0XFC,0XFC,
0XFF,0XFF,0XF0,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0X3F,0X3F,0XFF,0XFC,
0XF3,0XF3,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XF3,0XFC,0XFF,0XFF,0XF0,0X00,0XFF,
0XFF,0XFF,0X00,0X0F,0XFF,0XFF,0X3F,0XFF,0XCF,0XFF,0XFC,0X00,0X00,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XCF,0XFF,0XFF,0XF3,0XF3,0XFF,
0XFF,0XC0,0X3F,0XFF,0XFF,0XFC,0X03,0XFF,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XF3,
0XF3,0XFF,0XFF,0X3F,0XCF,0X0F,0XFF,0XF3,0XFC,0XF0,0XFF,0XFF,0XF0,0X00,0XFF,0XFF,
0XFF,0XC0,0X0F,0XFF,0XFF,0X3F,0XCF,0XCF,0XFF,0XF3,0XFC,0XFC,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFC,0XCF,0XC0,0X0F,0XFF,0X3F,0XCF,0XCF,0XFF,0XF3,0XFC,0XFC,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0X0C,0XCC,0XCF,0XFF,0XCF,0X3F,0X3F,0XFF,0XFC,0XF3,0XF3,
0XFF,0XFF,0XF0,0X00,0XFF,0XFF,0XFF,0XC0,0X0C,0XCF,0XFF,0XF0,0X00,0XFF,0XFF,0XFF,
0X00,0X0F,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0X0C,0XCC,0XCF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XCF,0XFF,0XFC,0XCF,0XC0,0X0F,0XFF,0XC0,
0X3F,0XFF,0XFF,0XFC,0X03,0XFF,0XFF,0XFF,0X3F,0XFF,0XCF,0XFF,0XFF,0XC0,0X0F,0XFF,
0XFF,0X3F,0XCF,0X0F,0XFF,0XF3,0XFC,0XF0,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0X3F,0XCF,0XCF,0XFF,0XF3,0XFC,0XFC,0XFF,0XFF,0XF0,0X00,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XCF,0XCF,0XFF,0XF3,0XFC,0XFC,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0X3F,0X3F,0XFF,0XFC,0XF3,0XF3,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0XFF,0XFF,0XFF,0X00,0X0F,
0XFF,0XFF,0XF0,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X3F,0XFF,
0XFF,0XFC,0X03,0XFF,0XFF,0XFF,0X3F,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,
0XCF,0X0F,0XFF,0XF3,0XFC,0XF0,0XFF,0XFF,0X3F,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0X3F,0XCF,0XCF,0XFF,0XF3,0XFC,0XFC,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0X3F,0XCF,0XCF,0XFF,0XF3,0XFC,0XFC,0XFF,0XFF,0XF0,0X00,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0X3F,0X3F,0XFF,0XFC,0XF3,0XF3,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0XFF,0XFF,0XFF,0X00,0X0F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XF0,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XF0,0X00,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XCC,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XCF,0XFF,0XFF,0XCC,0XFC,0XFF,0XFF,0XC3,
0XFF,0X0F,0XFF,0XFC,0X3F,0XF0,0XFF,0XFF,0X3F,0XFF,0XCF,0XFF,0XFF,0XCC,0XFC,0XFF,
0XFF,0X3F,0XFC,0XCF,0XFF,0XF3,0XFF,0XCC,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XCC,
0XFC,0XFF,0XFF,0X3F,0XF3,0XCF,0XFF,0XF3,0XFF,0X3C,0XFF,0XFF,0XF0,0X00,0XFF,0XFF,
0XFF,0XCC,0X00,0X3F,0XFF,0X3F,0X0F,0XCF,0XFF,0XF3,0XF0,0XFC,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XCF,0XFF,0XF3,0XFF,0XC0,0XFF,0X0F,0XFF,0XFC,0X0F,0XF0,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XF0,0X00,0XFF,0XFF,0XFF,0XC0,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X3F,
0XFF,0XFC,0X00,0X03,0XFF,0XFF,0X3F,0XFF,0XCF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0X3F,
0XFF,0XCF,0XFF,0XF3,0XFF,0XFC,0XFF,0XFF,0X3F,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0X3F,0XFF,0XCF,0XFF,0XF3,0XFF,0XFC,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,
0XFF,0XC3,0XFF,0X0F,0XFF,0X0F,0XFF,0XF0,0XFF,0XF0,0XFF,0XFF,0XF0,0X00,0XFF,0XFF,
0XFF,0X00,0X00,0X3F,0XFF,0XF0,0X00,0XFF,0XFF,0XFF,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0X3C,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0X3C,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XCF,0XFF,0XCF,0XFF,0XFF,0X3C,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XCF,0XFF,0XFF,0X00,0X00,0X03,0XFF,0XCF,0XFF,0XCF,
0XFF,0XFC,0XFF,0XFC,0XFF,0XFF,0X00,0X00,0X0F,0XFF,0XFF,0X3C,0XF3,0XFF,0XFF,0X00,
0X00,0X0F,0XFF,0XF0,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0X3C,0XF3,0XF3,
0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0X3C,
0XF3,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFC,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XCF,0XFF,0XCF,0XFF,0XF0,
0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X0F,0XFF,0X00,0X00,0X0F,
0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC3,0XFF,0XFF,0XFF,
0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X03,
0XFF,0XFF,0XFF,0XCF,0XF3,0XFF,0XFF,0XFF,0XFF,0X0F,0XFF,0XFF,0XFF,0XF0,0XFF,0XFF,
0XFC,0XF3,0XFF,0XFF,0XFF,0XCF,0XCF,0XFF,0XFF,0XFF,0XFF,0X0F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XF3,0XF3,0XCF,0XFF,0XFF,0XCF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X0F,0XFF,0XFF,0XCC,0X00,0X03,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XCF,0XFF,0XFF,0XC0,0XF3,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XCF,0XFF,0XFF,0X0C,0XF3,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCC,
0XF3,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XCC,0XF3,0X33,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFC,0XFF,0XFF,0XCF,0XFF,
0XCF,0XFF,0XFF,0XCC,0X00,0X03,0XFF,0XCF,0XFF,0XCF,0XFF,0XF0,0X00,0X00,0XFF,0XFF,
0XCF,0XFF,0XCF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XFC,
0XFF,0XFF,0X00,0X00,0X0F,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XF3,0XCF,0XF3,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0X3F,0XCF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X30,
0XF3,0X3F,0XFF,0XC0,0X00,0X3F,0XFF,0XF3,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XC3,0XFC,0XFF,0XFF,0X3F,0XFF,0XCF,0XFF,0XF3,0XFF,0XFC,0XFF,0XFF,0X03,0XFF,
0XFF,0XFF,0XFF,0XF0,0XC3,0X0F,0XFF,0X3F,0XFF,0XCF,0XFF,0XF0,0XFF,0XF0,0XFF,0XFF,
0X3F,0XFF,0XFF,0XFF,0XFF,0XF3,0X3F,0XF3,0XFF,0X0F,0XFF,0X0F,0XFF,0XFF,0X00,0X0F,
0XFF,0XFF,0X3F,0XC0,0X0F,0XFF,0XFF,0XFC,0XFF,0XCF,0XFF,0XF0,0X00,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X3C,0X3F,0XFF,0XFF,0XFF,0X00,0X03,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X03,0XFF,0XFF,0XFF,0XFF,0XF3,0XFC,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XF0,0X03,0XCF,
0XFF,0XFF,0XFF,0X0F,0XFF,0XFF,0XFF,0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,
0XFF,0XF3,0XFF,0XFF,0XFF,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XF0,
0X3F,0XFF,0XFF,0XCF,0XFC,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X3F,0X0F,0XCF,0XFF,0XFF,0X00,0X00,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X3F,0X3F,0XCF,0XFF,0XFF,0XCC,0XCC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X3F,0X3F,0XCF,0XFF,0XFF,0XCC,0XCC,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0X3F,0XF0,0XFF,0XFF,0X3F,0X0F,0XCF,0XFF,0XFF,0X00,0X00,0X3F,0XFF,0XC3,
0XFF,0X0F,0XFF,0XF3,0XFF,0XCC,0XFF,0XFF,0XC0,0XF0,0X3F,0XFF,0XFF,0XCF,0XFC,0XCF,
0XFF,0X3F,0XFC,0XCF,0XFF,0XF3,0XFF,0X3C,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XF3,0XFF,0X3F,0XF3,0XCF,0XFF,0XF3,0XF0,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0X00,0X00,0X0F,0XFF,0X3F,0X0F,0XCF,0XFF,0XFC,0X0F,0XF0,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0X3C,0XF3,0XFF,0XFF,0XC0,0XFF,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0X3C,0XF3,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X03,0XFF,0XFF,0XC3,0XFF,0XFF,0XFF,
0XC3,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X33,0XFF,
0XFF,0XFC,0X3F,0X3C,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,
0XF3,0XFF,0XFF,0XF0,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XCF,0XF3,0XCF,0XFF,0XFF,0XFF,0X3C,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,};


const unsigned char gImage_fu[3096] = { /* 0X01,0X02,0XAC,0X00,0X48,0X00, */
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XF3,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X33,0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X03,0XC3,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XC3,0X0F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XF0,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XC0,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XC0,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X0F,0XF0,0X00,
0X0F,0XFC,0X30,0XCF,0XFC,0XC3,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XCF,0XFF,
0XF3,0XCF,0XFF,0XF3,0X0C,0XCF,0XFC,0X03,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,
0XCF,0XFF,0XF3,0XCF,0XFF,0X0F,0X33,0X33,0XFC,0X33,0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XF3,0XC3,0XFF,0XF3,0XC3,0XFF,0XFC,0XF3,0XCF,0XFC,0XF3,0XFC,0XFF,0XFF,0X3F,
0XFF,0XFF,0XFF,0XF3,0XCC,0X3F,0XF3,0XCC,0X3F,0XC0,0X00,0X03,0XFF,0XF3,0XFC,0XFF,
0XFC,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XCF,0XFC,0X3F,0XCF,0XCC,0XCC,0XFF,0XFF,0XFF,
0XFF,0XFC,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCC,0XC0,0X0F,
0XFF,0XFF,0XFF,0XFF,0XCF,0XF3,0XFF,0XFF,0XFF,0XF0,0X00,0X0F,0XF0,0X00,0X0F,0X0C,
0XCC,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XCF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFC,0X3F,
0XFF,0XCC,0XC0,0X0F,0XFC,0X00,0X00,0X3F,0XCF,0X3F,0XFF,0XFF,0XFF,0XFF,0XC0,0XFF,
0XFF,0XC0,0XFF,0XCC,0XCC,0XF3,0XFC,0X00,0X00,0X3C,0X00,0X00,0X0F,0XFF,0XFF,0XFF,
0XFF,0X0F,0XFF,0XFF,0X0F,0XC0,0XC0,0X03,0XF0,0XF3,0XCF,0X3F,0XCF,0X3F,0XFF,0XFF,
0XFF,0XFF,0XC0,0XFF,0XFF,0XC0,0XFF,0XFF,0XFF,0XFF,0XC0,0XF3,0XCF,0X3F,0XCF,0XCF,
0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFC,0X3F,0XFF,0XFF,0XCF,0XFF,0XCC,0XF3,0XCF,0X3F,
0XCF,0XF3,0XFF,0XFF,0XFF,0XF0,0X00,0X0F,0XF0,0X00,0X0F,0XFF,0XCF,0XFF,0XFC,0XF3,
0XCF,0X3F,0XCF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0XCF,0XFF,
0XFC,0XF3,0XCF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X0F,0XF0,0X00,0X0F,0X3C,
0XC0,0XFF,0XFC,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XCF,0XCF,0XF3,0XCF,
0XCF,0X3C,0XCC,0XFF,0XFC,0X00,0X00,0X3C,0XC0,0X00,0X0F,0XFF,0XFF,0XF3,0XCF,0XCF,
0XF3,0XCF,0XCF,0X3C,0XCC,0XF3,0XFF,0XFF,0XFF,0XFF,0X3C,0XFC,0XFF,0XFF,0XFF,0XF3,
0XCF,0XCF,0XF3,0XCF,0XCF,0X3C,0XCC,0XF3,0XFF,0XFF,0XFF,0XFF,0XFC,0XF3,0XFF,0XFF,
0XFF,0XF3,0XCF,0XCF,0XF3,0XCF,0XCF,0X3C,0XCC,0XF3,0XFF,0XFF,0XFF,0XFC,0XFC,0XCF,
0XFF,0XFF,0XFF,0XFC,0X00,0X3F,0XFC,0X00,0X3F,0X00,0XCC,0X0F,0XFF,0XFF,0XFF,0XFC,
0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XF0,0X00,
0X00,0X3C,0XFC,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,
0XF0,0X00,0X00,0X3C,0XFC,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XF3,0X03,0XCF,0XFC,0XFC,0XFC,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XF0,0X30,0X0F,0XFC,0XFF,0XFF,0XCF,0XFF,0XFF,0XFC,0XFF,0XCF,
0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XF0,0XFC,0X3F,0XFC,0X00,0X00,0X0F,0XFF,0XFF,0XF3,
0XFF,0X0F,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XF3,0XFC,0XCF,0XF0,0X00,0X0F,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0XFF,0XC0,0XFF,
0XFF,0XFF,0XFF,0XF3,0XF3,0XCF,0XFF,0XFF,0XFF,0XF0,0XFC,0X3F,0XF3,0XF3,0XF3,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X0F,0XCF,0XFF,0XFF,0XFF,0XF0,0XFC,0X3F,0XF3,0XF3,
0XF3,0XFC,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XC0,0X00,0X00,0XFF,0XCF,0X3F,0XFF,0XFF,0XFF,0XFC,0X00,0X3F,0XFC,0X30,0X3F,0XFF,
0XFF,0XFF,0XC0,0X00,0X00,0XFF,0X33,0X00,0X0F,0XFF,0XFF,0XF3,0XFF,0XCF,0XF3,0XCF,
0XCF,0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,0X33,0X33,0X3F,0XFF,0XFF,0XF3,0XFF,0XCF,
0XF3,0XCF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X33,0X33,0X3F,0XFF,0XFF,0XF3,
0XFF,0XCF,0XF3,0XCF,0XCF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0X3C,0X00,0X33,0X3F,0XFF,
0XFF,0XFC,0X00,0X3F,0XFC,0X30,0X3F,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0X3F,0X33,0X33,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XCF,0XF3,0XF3,0XFC,0X3F,
0X33,0X00,0X0F,0XFF,0XFF,0XFC,0X00,0X3F,0XFC,0X30,0X3F,0XF3,0XFF,0X0F,0XF0,0X33,
0XF0,0XFF,0X3F,0X3F,0XFF,0XFF,0XFF,0XF3,0XFF,0XCF,0XF3,0XCF,0XCF,0XF3,0XFC,0XCF,
0XFC,0X30,0X03,0XFF,0XFF,0XFF,0XFC,0X00,0X0F,0XF3,0XFF,0XCF,0XF3,0XCF,0XCF,0XF3,
0XF3,0XCF,0XFF,0XF0,0X0F,0XFC,0XFC,0XFF,0X0C,0XF3,0XFF,0XF3,0XFF,0XCF,0XF3,0XCF,
0XCF,0XFC,0X0F,0XCF,0XC0,0X03,0XFF,0XFF,0X0C,0X00,0XFC,0XF3,0XFF,0XFC,0X00,0X3F,
0XFC,0X30,0X3F,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0XFF,0XFF,0XFF,0X3C,0XF0,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0X3F,0XFF,0X30,0X00,0X3F,0XF3,0XFF,0X3F,0X0F,
0X0F,0XFF,0X3F,0XF3,0XFF,0X3F,0XF3,0XF3,0XFF,0XCF,0XF0,0X33,0XFF,0X3F,0X00,0X3C,
0XCF,0XFF,0XFF,0XCF,0X3F,0XF3,0XCF,0X3F,0XF3,0XF3,0XCF,0XCF,0XF0,0XF3,0XFF,0X3C,
0XCF,0X33,0XCF,0XFF,0XFF,0XCF,0X3F,0XCF,0XCF,0X3F,0XCF,0XF3,0XCF,0XCF,0XFF,0XF3,
0XF0,0X3C,0XC0,0X0F,0XCF,0XF0,0X3F,0XCF,0X00,0X3F,0XCF,0X00,0X3F,0XFC,0X30,0X3F,
0XFF,0XF3,0XF0,0X3C,0X0F,0X00,0XCF,0XCF,0XCF,0XCF,0X3F,0XFF,0XCF,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XCF,0X3C,0XCF,0XCF,0XCF,0XCF,0X3F,0XFF,0XCF,0X3F,
0XFF,0XFC,0X0F,0X3F,0XFF,0XFF,0XFF,0XFF,0XC0,0X0C,0XCF,0XF0,0X3F,0XCF,0X00,0X03,
0XCF,0X00,0X03,0XF3,0XF3,0XCF,0XFC,0X00,0X00,0X3F,0XFF,0XF0,0XCF,0XFF,0XFF,0XCF,
0X3F,0XF3,0XCF,0X3F,0XF3,0XF3,0XF3,0XCF,0XF0,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0X0F,0X3F,0XF3,0X0F,0X3F,0XF3,0XF3,0XF3,0XCF,0XC0,0XFC,0XFC,0XFC,0XF0,0XCF,
0XCF,0XC0,0X3F,0XCF,0X3F,0XF3,0XCF,0X3F,0XF3,0XFC,0X00,0X3F,0XCC,0X00,0X00,0X3C,
0XCC,0XCF,0XCF,0XFF,0XCF,0XFF,0X3F,0X03,0XFF,0X3F,0X03,0XFF,0XFF,0XFF,0XFC,0X00,
0X00,0X3C,0X3C,0X00,0X3F,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X0F,0X3F,
0XFF,0X03,0XFF,0XFC,0XFC,0XCF,0X3F,0XC0,0X0F,0XFF,0XFF,0X0F,0XFF,0XFF,0X0F,0XF3,
0XF3,0XCF,0XC0,0X30,0X3F,0XFC,0XF0,0XCF,0X3F,0XFF,0XFF,0XFF,0X00,0XFF,0XFF,0X00,
0XFF,0XF3,0XF3,0XCF,0XC0,0XFC,0X3C,0XFC,0XFF,0XCF,0XCF,0XFF,0XFF,0XF0,0XFF,0XFF,
0XF0,0XFF,0XFF,0XF3,0XF3,0XCF,0XFC,0XFF,0XFC,0X3F,0XF0,0XFF,0X3F,0XC0,0X0F,0XFF,
0X3F,0XFF,0XFF,0X3F,0XFF,0XFC,0X00,0X3F,0XFC,0X00,0X00,0X3C,0X0F,0X0C,0XFF,0XCF,
0XFF,0XFC,0X00,0X03,0XFC,0X00,0X03,0XFF,0XFF,0XFF,0XFC,0X00,0X00,0XFF,0XCF,0XF0,
0XFF,0XCF,0XFF,0X03,0XFF,0XFF,0X03,0XFF,0XFF,0XFC,0X0F,0X3F,0XFF,0XFF,0XFF,0XFF,
0XC0,0X0F,0X3F,0XF0,0X0F,0XFF,0X33,0XFF,0XFF,0X33,0XFF,0XF3,0XF3,0XCF,0XFF,0XFF,
0XFF,0XFF,0XCF,0XFF,0XCF,0XFF,0XFF,0XC0,0XF3,0XFF,0XC0,0XF3,0XFF,0XF3,0XF3,0XCF,
0XFC,0X00,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XF3,0XFF,0XFC,0XF3,0XFF,0XF3,
0XF3,0XCF,0XFC,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XF0,0X3F,0XFC,0XF3,0XFF,0XFC,0XF3,
0XFF,0XFC,0X00,0X3F,0XF0,0X00,0X03,0XFC,0X00,0X00,0X0F,0XCF,0XCF,0X00,0X00,0X03,
0X00,0X00,0X03,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0XFC,0XFF,0XFF,0XCF,0XCF,0XCF,0XFC,
0XF3,0XFF,0XFC,0XF3,0XFF,0XFC,0X00,0X3F,0XCC,0X00,0X00,0X3C,0XC0,0X03,0X0C,0X00,
0X0F,0XF0,0XF3,0XFF,0XF0,0XF3,0XFF,0XF3,0XFF,0XCF,0XFC,0X00,0XC3,0X3C,0XCC,0XFC,
0XCF,0XFF,0XFF,0XFC,0XF3,0XFF,0XFC,0XF3,0XFF,0XF3,0XFF,0XCF,0XFC,0XF3,0XC3,0X3C,
0XCC,0XC3,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XCF,0XFC,0XF3,
0X0F,0X3C,0XCC,0XF3,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X3F,
0XC0,0X00,0X03,0X3C,0XC0,0XFC,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XC0,0X00,0X03,0X3C,0XFC,0X03,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0XFF,0XCF,0XFC,0XF0,0X3F,0X3C,0XFF,0XFF,0XCF,0XC0,0X0F,0XFF,0X00,0X0F,
0XFF,0X00,0X0F,0XF3,0XFF,0X0F,0XFC,0XF3,0X0C,0X3C,0X00,0X00,0X0F,0XCF,0XFF,0XFC,
0XFF,0XF3,0XFC,0XFF,0XF3,0XF3,0XFC,0XCF,0XFF,0XF3,0XCC,0X3F,0XFF,0XFF,0XFF,0XCF,
0XFF,0XF3,0XFF,0XFC,0XF3,0XFF,0XFC,0XF3,0XF3,0XCF,0XFF,0XFF,0XFF,0XFF,0XFC,0XCF,
0XFF,0XF0,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X0F,0XCF,0XFF,0XFF,0XFF,0X3F,
0XC3,0XCC,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFC,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0X3F,
0XFF,0X3C,0X3C,0XCF,0X3F,0XFF,0XFF,0XFC,0XFF,0XFF,0XF3,0XFF,0X0F,0XFC,0X00,0X3F,
0XFF,0X3F,0XFC,0X3F,0XCF,0X0C,0XCF,0XF0,0X3F,0XF0,0X00,0X0F,0XF3,0XFC,0XCF,0XF3,
0XFF,0XCF,0XFF,0X3F,0XF0,0XFF,0XF3,0XC3,0XFF,0XCC,0XCF,0XFF,0XFF,0XFF,0XF3,0XF3,
0XCF,0XF3,0XFF,0XCF,0XFF,0X3F,0XC3,0XFC,0XFF,0XFF,0XCF,0XCC,0XCF,0XFF,0XFF,0XFF,
0XFC,0X0F,0XCF,0XF3,0XFF,0XCF,0XC0,0X00,0X0F,0XFC,0XC0,0X03,0X3F,0XF0,0XCF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X3F,0XC0,0X00,0X3F,0XFC,0X0F,0XFC,0XFF,0XFF,
0XFF,0XFF,0X3F,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFC,0XFC,0XCC,0X00,
0XFF,0XFF,0XFF,0XFC,0X00,0X03,0XFC,0X00,0X03,0XFC,0XFF,0XCF,0XFF,0X3F,0XFC,0X3C,
0XCF,0XFF,0X3F,0XF0,0X3F,0X03,0XFF,0XFF,0X03,0XFF,0XFF,0XF3,0XFF,0X0F,0XFF,0X3F,
0XFC,0X3C,0XC0,0X03,0XCF,0XCF,0XCF,0XFF,0X33,0XFF,0XFF,0X33,0XFF,0XF3,0XFC,0XCF,
0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XCF,0XCF,0XC0,0XF3,0XFF,0XC0,0XF3,0XFF,0XF3,
0XF3,0XCF,0XFF,0X00,0X03,0XFF,0XFF,0X3F,0XFF,0XF3,0X3F,0XFC,0XF3,0XFF,0XFC,0XF3,
0XFF,0XFC,0X0F,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFC,0X00,0X0F,0XFC,0XF3,0XFF,
0XFC,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFC,0XFF,0X00,
0X00,0X03,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XF0,
0X3F,0XFC,0XF3,0XFF,0XFC,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,
0XFF,0XCF,0XCF,0XF0,0XF3,0XFF,0XF0,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XF3,0XFF,0XFC,0XF3,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,
0XC3,0XFF,0X3F,0X3C,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XF0,0X00,0XC3,0XFF,0X3C,0XFC,0XFF,0XFF,0XFF,0XF3,0XFF,0XFC,0XFF,0X3F,0XCF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X33,0XFC,0XCF,0XFF,0XFF,0XFC,0XFF,0XF3,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0C,0X00,0X0C,0X00,0X0F,0XFF,0X00,0X0F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3C,0XCC,0XCF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XF0,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3C,0XCC,0XCF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XF3,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3C,0XCC,
0XCF,0XF0,0X3F,0XFF,0XFF,0XFF,0XF3,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X0C,0XCC,0X0F,0XCC,0XCF,0XFF,0XFF,0XFF,0XF3,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X33,0XFC,0XCF,0XCC,0XCF,0XFF,0XFF,0XFF,0XF3,0XCC,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X3C,0XFC,0XFF,0XF0,0XCF,0XFF,0XFF,0XFF,0XFC,0X3F,0XCF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3C,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XF0,0X00,0X0F,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X3F,0X3C,0XCF,0X3C,0XC0,0X0F,0XFF,
0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X3F,0XCC,0XCF,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XFF,0XFF,0XFF,0XFF,0XF3,0X03,0XCF,0XFF,0XF3,0XCC,
0XFF,0XF3,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0XFF,0XFF,0XFF,0XF0,0X30,0X0F,0XFC,
0X00,0X0C,0X0F,0XCC,0XCF,0XFF,0XFF,0XFF,0XFF,0XC0,0XFF,0XFF,0XFF,0XFF,0XF0,0XFC,
0X3F,0XFF,0XCF,0XC3,0XCF,0XCC,0XCF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,
0XF0,0X00,0X00,0XFF,0XCC,0X0F,0X3F,0XCF,0X3F,0XFF,0XFF,0XFF,0XF0,0X00,0X0F,0XFF,
0XFF,0XFF,0XF0,0X00,0X00,0XFF,0XCC,0XC0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XF3,0XF3,0XF3,0XFC,0X00,0XCF,0X3F,0XC0,0X3F,0XFF,0XFF,0XFF,
0XF0,0X00,0X0F,0XFF,0XFF,0XFF,0XF3,0XF3,0XF3,0XFF,0XCC,0XCC,0XCF,0XFF,0XCF,0XFF,
0XFF,0XFF,0XF3,0XCF,0XCF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0XFF,0XCC,0XC3,0XCF,0XFF,
0XCF,0XFF,0XFF,0XFF,0XF3,0XCF,0XCF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0XFF,0XCF,0XCF,
0XCF,0XC0,0X0F,0XFF,0XFF,0XFF,0XF3,0XCF,0XCF,0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XCF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X3F,0XFF,0XFF,0XFF,
0XFF,0XF3,0XFF,0X3F,0XFF,0XFF,0XFF,0XC0,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XF3,0XFF,0X3F,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XF3,0XF3,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X33,0XF0,0XFF,0XFF,0XFF,0XFF,0XF0,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X30,0X03,0XFF,0XFF,0XFF,0XFF,0XCC,
0XCF,0XFF,0XFF,0XFF,0XFC,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XF0,0X0F,0XFF,0XFF,0XFF,
0XFF,0XCC,0XCF,0XFF,0XFF,0XFF,0XF3,0XFF,0XCF,0XFF,0XFF,0XFF,0XC0,0X03,0XFF,0XFF,
0XFF,0XFF,0XFF,0XF0,0XCF,0XFF,0XFF,0XFF,0XF3,0XCF,0XCF,0XFF,0XFF,0XFF,0XC0,0X00,
0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XCF,0XCF,0XFF,0XFF,0XFF,
0XFF,0X30,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X30,0X3F,0XFF,
0XFF,0XFF,0XF0,0X33,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XF0,0XF3,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XF0,0X3F,0XFF,0XFF,0XFF,0XF3,0XCF,0XFF,
0XFF,0XFF,0XF3,0XFC,0X0F,0XFF,0XFF,0XFF,0XFF,0XF3,0XF0,0X3F,0XFF,0XFF,0XFF,0XCC,
0XCF,0XFF,0XFF,0XFF,0XF3,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XCC,0XCF,0XFF,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XCF,0X3F,0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,
0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFC,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XC0,0X3F,0XFF,0XFF,0XFF,0XFC,0X00,0X3F,0XFF,
0XFF,0XFF,0XFC,0XF3,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XF3,0XCF,
0XCF,0XFF,0XFF,0XFF,0XFC,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,
0XF3,0XCF,0XCF,0XFF,0XFF,0XFF,0XFC,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XC0,0X0F,0XFF,
0XFF,0XFF,0XF3,0XCF,0XCF,0XFF,0XFF,0XFF,0XFF,0X33,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFC,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0X30,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3C,0XFF,0X3F,
0XFF,0XFF,0XFC,0XC0,0X0F,0XFF,0XFF,0XFF,0XFF,0X3F,0XF3,0XFF,0XFF,0XFF,0XC0,0X00,
0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0X3F,0XF3,0XFF,0XFF,0XFF,
0XC0,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XCF,0X3F,0XCF,0XFF,
0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X0F,0XFF,0XFF,0XFF,0XCF,0X00,
0X3F,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XCF,0XFF,0XFF,0XFF,
0XCF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XCF,0X3F,0XFF,0XFF,0XFF,0XFF,0XF3,0XF3,0X3C,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XCF,0X00,0X03,0XFF,0XFF,0XFF,0XF0,0XC3,0X3C,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0X3F,0XF3,0XFF,0XFF,0XFF,0XFC,0X0F,0X30,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0X3F,0XF3,0XFF,0XFF,0XFF,0XC0,0X03,
0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0X3F,0XF3,0XFF,0XFF,0XFF,
0XC0,0X03,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0X03,0XFF,
0XFF,0XFF,0XFC,0XF3,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFC,0XF0,0X3C,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XF3,0XFF,0XFC,0XFF,0XFF,0XFF,0XC0,0X00,0X0C,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFC,0XFF,0XF3,0XFF,0XFF,0XFF,0XC0,0X03,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X0F,0XFF,0XFF,0XFF,0XFC,0XF3,0X00,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XF3,0X0C,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XF3,
0X3F,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFC,0XFF,0X3F,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,};


const unsigned char gImage_gc4[3096] = { /* 0X01,0X02,0XAC,0X00,0X48,0X00, */
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,};


const unsigned char gImage_save[3096] = { /* 0X01,0X02,0XAC,0X00,0X48,0X00, */
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF2,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X81,0XBF,0XFF,
0XF0,0X1F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF4,0X00,
0X0B,0XFF,0XF0,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XD0,0X00,0X03,0XFF,0XFF,0X41,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XC1,0XFF,0X81,0XFF,0XFF,0XD0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X83,0XFF,0XD0,0XFF,0XFF,0XF0,0XBF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X43,0XFF,0XF0,0X7F,0XFF,0XF0,0X7F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X43,0XFF,0XF8,0X2F,
0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X83,0XFF,
0XFC,0X1F,0XFF,0XF0,0XBF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XC1,0XFF,0XFE,0X0F,0XFF,0XD0,0XBF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XE0,0X0F,0XFF,0X07,0XFF,0X41,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XF8,0X0F,0XFF,0X80,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X9F,0XFF,0XE0,0X00,0X1F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFE,0X41,0XBF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XF4,0XBF,0X7F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X2F,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X4E,0X1F,0XCB,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0X4F,0XC3,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0X8B,0XC3,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X4F,0XCB,
0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X8F,0XC7,0XCB,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XC3,0XD0,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XF7,0XF4,0X7F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XE3,0XF8,0X2F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC3,0XE0,0X0B,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XE4,0X1B,0XFF,0XF6,0XFF,0XFF,0XFF,0XFF,0XFF,0X8F,0XC7,
0X83,0XFF,0XFF,0XFF,0XFF,0XFF,0XFE,0X00,0X00,0XBF,0XF0,0X1F,0XFF,0XFF,0XFF,0XFF,
0X4F,0XCB,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XF4,0X00,0X00,0X1F,0XF0,0X03,0XFF,0XFF,
0XFF,0XFF,0X0F,0X8B,0XC7,0XFF,0XFF,0XFF,0XFF,0XFF,0XE0,0X2F,0XF9,0X0B,0XFF,0X41,
0XFF,0XFF,0XFF,0XFF,0X0F,0X8F,0XCB,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XFF,0XFF,0X03,
0XFF,0XD0,0XFF,0XFF,0XFF,0XFF,0X4B,0X4F,0X4F,0XFF,0XFF,0XFF,0XFF,0XFF,0X82,0XFF,
0XFF,0X82,0XFF,0XF0,0X7F,0XFF,0XFF,0XFF,0X80,0X00,0X0B,0XFF,0XFF,0XFF,0XFF,0XFF,
0X43,0XFF,0XFF,0XC1,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XE4,0X00,0X03,0XFF,0XFF,0XFF,
0XFF,0XFF,0X03,0XFF,0XFF,0XC0,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XF7,0XFF,
0XFF,0XFF,0XFF,0XFF,0X03,0XFF,0XFF,0XC0,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X03,0XFF,0XFF,0XC1,0XFF,0XF0,0X7F,0XFF,0XFF,0XFF,
0X2F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X83,0XFF,0XFF,0XC2,0XFF,0XE0,0XBF,0XFF,
0XFF,0XFF,0X42,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X82,0XFF,0XFF,0X87,0XFF,0XC0,
0XFF,0XFF,0XFF,0XFF,0XF4,0X1F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XFF,0XFF,0X0F,
0XFF,0X43,0XFF,0XFF,0XFF,0XFF,0XFF,0X41,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XE0,0X2F,
0XF8,0X3F,0XE4,0X0B,0XFF,0XFF,0XFF,0XFF,0XFF,0XF8,0X1B,0XFF,0XFF,0XFF,0XFF,0XFF,
0XF4,0X00,0X00,0X00,0X00,0X2F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X03,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0X40,0X00,0X00,0X02,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF8,0X1F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFA,0X80,0X06,0XBF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X81,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XF4,0X2F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X42,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XE4,0X0B,0XFF,0XF6,0XFF,
0XFF,0XFF,0XFF,0XFF,0X2F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFE,0X00,0X00,0X7F,
0XF0,0X1F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF4,0X00,
0X00,0X1F,0XF0,0X03,0XFF,0XFF,0XFF,0XFF,0XFE,0X02,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XD0,0X2F,0XF8,0X07,0XFF,0X01,0XFF,0XFF,0XFF,0XFF,0XE0,0X00,0X2F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XC0,0XFF,0XFF,0X03,0XFF,0XD0,0XFF,0XFF,0XFF,0XFF,0XC7,0X0F,0X4F,0XFF,
0XFF,0XFF,0XFF,0XFF,0X82,0XFF,0XFF,0X82,0XFF,0XF0,0XBF,0XFF,0XFF,0XFF,0X4F,0X0F,
0X87,0XFF,0XFF,0XFF,0XFF,0XFF,0X43,0XFF,0XFF,0XC1,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,
0X0F,0X0F,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0X03,0XFF,0XFF,0XC0,0XFF,0XF0,0X3F,0XFF,
0XFF,0XFF,0X0F,0X0F,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0X03,0XFF,0XFF,0XC0,0XFF,0XF0,
0X3F,0XFF,0XFF,0XFF,0X4F,0X0F,0XC7,0XFF,0XFF,0XFF,0XFF,0XFF,0X03,0XFF,0XFF,0XC1,
0XFF,0XF0,0X7F,0XFF,0XFF,0XFF,0XCB,0X0F,0X8B,0XFF,0XFF,0XFF,0XFF,0XFF,0X83,0XFF,
0XFF,0XC2,0XFF,0XE0,0XBF,0XFF,0XFF,0XFF,0XE0,0X0F,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,
0X82,0XFF,0XFF,0X87,0XFF,0XC0,0XFF,0XFF,0XFF,0XFF,0XFE,0X0F,0XBF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XC0,0XFF,0XFF,0X0F,0XFF,0X42,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XE0,0X3F,0XF8,0X3F,0XE4,0X07,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF4,0X00,0X00,0X00,0X00,0X2F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X40,0X00,0X00,0X01,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFA,0X80,0X02,0XBF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XE4,0X1B,0XFF,0XF6,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFE,0X00,0X00,0X7F,0XF0,0X1F,0XFF,0XFF,0XFF,0XF8,0X6F,0XFD,0XBF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XF8,0X00,0X00,0X1F,0XF0,0X03,0XFF,0XFF,0XFF,0XC0,0X0B,0XFC,
0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XE0,0X2F,0XFD,0X0B,0XFE,0X41,0XFF,0XFF,0XFF,0X8B,
0XD3,0XFF,0X8B,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XFF,0XFF,0X03,0XFF,0XD0,0XFF,0XFF,
0XFF,0X4F,0XF2,0XFF,0XC7,0XFF,0XFF,0XFF,0XFF,0XFF,0X82,0XFF,0XFF,0X82,0XFF,0XF0,
0X7F,0XFF,0XFC,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0X43,0XFF,0XFF,0XC1,
0XFF,0XF0,0X3F,0XFF,0XFF,0X4F,0XF8,0XFF,0XC7,0XFF,0XFF,0XFF,0XFF,0XFF,0X03,0XFF,
0XFF,0XC0,0XFF,0XF0,0X3F,0XFF,0XFF,0X87,0XFC,0XBF,0X8B,0XFF,0XFF,0XFF,0XFF,0XFF,
0X03,0XFF,0XFF,0XC0,0XFF,0XF0,0X3F,0XFF,0XFF,0XC0,0XFE,0X00,0X0F,0XFF,0XFF,0XFF,
0XFF,0XFF,0X03,0XFF,0XFF,0XC1,0XFF,0XF0,0X7F,0XFF,0XFF,0XF9,0XFF,0X91,0XBF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X83,0XFF,0XFF,0XC2,0XFF,0XE0,0XBF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X82,0XFF,0XFF,0X83,0XFF,0XC0,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XFF,0XFF,0X0F,0XFE,0X42,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XE0,0X2F,0XF8,0X3F,0XE4,0X0B,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF8,0X00,0X00,0X00,
0X00,0X2F,0XFF,0XFF,0XFF,0XFE,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X40,
0X00,0X00,0X01,0XFF,0XFF,0XFF,0XFF,0XFD,0X7F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFA,0X80,0X06,0XBF,0XFF,0XFF,0XFF,0XFF,0XF8,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF2,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X80,0X00,0X00,
0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,
0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFE,0X90,0X1A,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XE0,0X00,0X00,
0X2F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC7,
0XFF,0XFF,0X4B,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0X4F,0XFF,0XFF,0XCB,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XE4,0X1B,0XFF,0XF6,0XFF,
0XFF,0XFF,0XFF,0X0F,0XFF,0XFF,0XC7,0XFF,0XFF,0XFF,0XFF,0XFF,0XFE,0X00,0X00,0X7F,
0XF0,0X1F,0XFF,0XFF,0XFF,0X0F,0XFF,0XFF,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XF4,0X00,
0X00,0X1F,0XF0,0X03,0XFF,0XFF,0XFF,0X4F,0XFF,0XFF,0XC7,0XFF,0XFF,0XFF,0XFF,0XFF,
0XD0,0X2F,0XF9,0X07,0XFF,0X41,0XFF,0XFF,0XFF,0X87,0XFF,0XFE,0X4B,0XFF,0XFF,0XFF,
0XFF,0XFF,0XC0,0XFF,0XFF,0X03,0XFF,0XD0,0XFF,0XFF,0XFF,0XE0,0X00,0X00,0X2F,0XFF,
0XFF,0XFF,0XFF,0XFF,0X82,0XFF,0XFF,0X82,0XFF,0XF0,0XBF,0XFF,0XFF,0XFF,0X90,0X1A,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X43,0XFF,0XFF,0XC1,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X03,0XFF,0XFF,0XC0,0XFF,0XF0,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X03,0XFF,0XFF,0XC0,0XFF,0XF0,
0X3F,0XFF,0XFF,0XFE,0X90,0X1A,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X03,0XFF,0XFF,0XC1,
0XFF,0XF0,0X7F,0XFF,0XFF,0XE0,0X00,0X00,0X1F,0XFF,0XFF,0XFF,0XFF,0XFF,0X83,0XFF,
0XFF,0XC2,0XFF,0XE0,0XBF,0XFF,0XFF,0X87,0XFF,0XFE,0X0B,0XFF,0XFF,0XFF,0XFF,0XFF,
0X82,0XFF,0XFF,0X87,0XFF,0XC0,0XFF,0XFF,0XFF,0X4F,0XFF,0XFF,0XCB,0XFF,0XFF,0XFF,
0XFF,0XFF,0XC0,0XFF,0XFF,0X0F,0XFF,0X42,0XFF,0XFF,0XFF,0X0F,0XFF,0XFF,0XC7,0XFF,
0XFF,0XFF,0XFF,0XFF,0XE0,0X3F,0XF8,0X3F,0XE4,0X07,0XFF,0XFF,0XFF,0X0F,0XFF,0XFF,
0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XF8,0X00,0X00,0X00,0X00,0X2F,0XFF,0XFF,0XFF,0X8F,
0XFF,0XFF,0XC7,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X40,0X00,0X00,0X01,0XFF,0XFF,0XFF,
0XFF,0X87,0XFF,0XFF,0X4B,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFA,0X80,0X06,0XAF,0XFF,
0XFF,0XFF,0XFF,0XE0,0X00,0X00,0X2F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X90,0X1A,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFE,0X02,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0X81,0XBF,0XE0,0X00,0X2F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XF8,0X00,0X0F,0X80,0X00,0X07,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XE0,0X00,0X07,0X07,0XFF,0X42,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XBF,0X81,0X1F,0XFF,0XD0,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X82,0XFF,0XE0,0X2F,0XFF,0XE0,
0XBF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X43,0XFF,0XF0,0X3F,
0XFF,0XF0,0X7F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X03,0XFF,
0XF0,0X3F,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0X50,0X1A,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X03,0XFF,0XF0,0X3F,0XFF,0XF0,0X3F,0XFF,0XFF,0XE0,0X00,0X00,0X2F,0XFF,0XFF,0XFF,
0XFF,0XFF,0X03,0XFF,0XF0,0X3F,0XFF,0XF0,0X3F,0XFF,0XFF,0XC7,0XFF,0XFF,0X4F,0XFF,
0XFF,0XFF,0XFF,0XFF,0X83,0XFF,0XF0,0X3F,0XFF,0XF0,0X7F,0XFF,0XFF,0X4F,0XFF,0XFF,
0XC7,0XFF,0XFF,0XFF,0XFF,0XFF,0X82,0XFF,0XE0,0X2F,0XFF,0XE0,0XBF,0XFF,0XFF,0X0F,
0XFF,0XFF,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XBF,0X81,0X1F,0XFF,0XD0,0XFF,0XFF,
0XFF,0X0F,0XFF,0XFF,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XE0,0X00,0X07,0X06,0XFE,0X42,
0XFF,0XFF,0XFF,0X4F,0XFF,0XFF,0XC7,0XFF,0XFF,0XFF,0XFF,0XFF,0XF8,0X00,0X1F,0X80,
0X00,0X07,0XFF,0XFF,0XFF,0XC7,0XFF,0XFF,0X0B,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X91,
0XBF,0XE0,0X00,0X2F,0XFF,0XFF,0XFF,0XD0,0X00,0X00,0X2F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFE,0X42,0XFF,0XFF,0XFF,0XFF,0XFF,0X90,0X1A,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFE,
0X90,0X1A,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XE0,0X00,0X00,0X1F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0X87,0XFF,0XFE,0X4F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0X4F,0XFF,0XFF,0XCB,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0XFF,0XFF,0XC7,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0XFF,0XFF,0XC3,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X8F,0XFF,0XFF,0XC7,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X87,0XFF,0XFE,
0X0B,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XD0,
0X00,0X00,0X1F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFE,0X90,0X1A,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,};

const unsigned char gImage_russian[3096] = { /* 0X81,0X02,0XAC,0X00,0X48,0X00, */
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XCF,0XCF,0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XCF,0XCF,0XFF,0XFF,0XC0,0X00,0X3F,0XFF,0XCC,0XFF,0X3F,0XFF,0XFF,0XFF,
0XFF,0X03,0XFF,0XFF,0XC0,0X00,0XFF,0XFF,0XCC,0XFF,0X3F,0XFF,0XFF,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFC,0X3C,0XFF,0XFF,0XF0,0XFC,0X3F,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XCF,
0XFF,0XFF,0XFF,0XFF,0XFC,0XFC,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XCF,0XFF,0XFF,
0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0X3C,0XFC,0XFF,0XFF,0XFF,0XC0,0XFF,0XFF,0XFF,0XCF,
0XFF,0XFF,0XCF,0XF3,0X3F,0XFF,0XFF,0XFF,0X3C,0XFC,0XFF,0XFF,0XFF,0X3F,0X3F,0XFF,
0XCF,0XF3,0X3F,0XFF,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0X3F,
0X3F,0XFF,0XC0,0X00,0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,
0XCF,0X3F,0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,
0XFF,0XFF,0XCF,0X3F,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,
0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X3F,0XFF,0XC0,0XFF,0XFF,0XFF,0XC0,0X00,0X3F,0XFF,
0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XCF,0XFF,0XFF,0XFF,0XCC,0XFF,
0X3F,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XCF,0XFF,0XFF,0XFF,
0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XC0,0X3F,0XFF,0XCF,0XFF,
0X3F,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,0XFC,0X03,0X3F,0XFF,
0XC0,0X00,0X3F,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XC0,0XFF,
0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XCF,0XF3,0X3F,0XFF,0XFF,0XFF,0X0F,0XFF,0XFF,0XFF,
0XC0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XF3,0XFF,
0XFF,0XFF,0XFF,0X0F,0X3F,0XFF,0XFF,0XFF,0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFC,0XFF,0XFF,0XFF,0XF0,0X3F,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XF0,0X00,0X3F,0XFF,0XFF,0XFF,
0XC3,0XFF,0XFF,0XFF,0XC0,0X00,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XCF,0X3C,0XFF,0XFF,
0XCF,0XFF,0X0F,0XFF,0XFF,0XFF,0X3C,0XF3,0XFF,0XFF,0XC0,0X00,0X3F,0XFF,0XCF,0X3F,
0X3F,0XFF,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0X3C,0XFC,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,
0XCF,0X3F,0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,0X3C,0XFC,0XFF,0XFF,0XFF,0XFF,
0X3F,0XFF,0XC3,0XCF,0X3F,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0X0F,0X3C,0XFF,0XFF,
0XFF,0XC0,0XFF,0XFF,0XF0,0XC0,0X3F,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XC3,0X00,
0XFF,0XFF,0XFF,0X0C,0X3F,0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,
0XFF,0XC3,0XFF,0XFF,0XFF,0X3F,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0X3F,0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XC0,0X00,
0X3F,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XC0,0X00,0X3F,0XFF,0XC0,0X00,0X3F,0XFF,
0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,0XC3,0X03,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XC3,0XFF,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X30,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFC,0X0F,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0X3C,0XFC,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XF0,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0X3C,0XFC,0XFF,0XFF,
0XFC,0X03,0XFF,0XFF,0XFF,0XF0,0X3F,0XFF,0XF0,0X00,0X3F,0XFF,0XFF,0XFF,0X3C,0XFC,
0XFF,0XFF,0XC3,0XFC,0XFF,0XFF,0XFC,0X0F,0XFF,0XFF,0XCF,0X3C,0XFF,0XFF,0XFF,0XFF,
0X3C,0XFC,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XC3,0XFF,0X3F,0XFF,0XCF,0X3F,0X3F,0XFF,
0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XC0,0X00,0X3F,0XFF,0XCF,0X3F,
0X3F,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,0XC3,0XFF,0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,
0XC3,0XCF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFC,0XFC,0XFF,0XFF,0XFF,
0XFF,0XFF,0XF0,0XC0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0XFF,
0XCF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XF0,0X0F,0XFF,0XFF,0XCF,0XFF,
0XFC,0XFF,0XC0,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XC0,0X03,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XCF,0X0F,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,0X3F,0XFC,
0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XF0,0XFF,0XFF,0XC3,0XFC,0X3F,0XFF,0XFF,0XFF,
0X3F,0XFC,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XF0,0X0F,0XFF,0XC3,0XF3,0X3F,0XFF,
0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,0XC3,0XFC,0X3F,0XFF,0XCF,0X03,0XF3,0XFF,0XFC,0XCF,
0XFF,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,0XC3,0XF3,0X3F,0XFF,0XC0,0XFF,0XFC,0XFF,
0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0X03,0XF0,0XFF,0XFF,0XFC,0XCF,0XFF,0XFF,0XCF,0XFF,
0XF0,0XFF,0XCF,0XCF,0X3F,0XFF,0XFF,0XFF,0XC0,0X03,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,
0XCF,0XFF,0XFF,0XFF,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XCF,
0X3F,0XCF,0XFC,0X0F,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,
0XC0,0X00,0X3F,0XF3,0XF0,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,
0XFF,0XFF,0XCF,0XFF,0X3F,0XF3,0XC0,0XF0,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,
0XFF,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XCF,0XFF,0X3F,0XFF,0XC0,0X00,0X3F,0XFF,
0XFF,0XFF,0XC0,0X3C,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XCF,0XFF,0X3F,0XFF,0XCC,0XFF,
0X3F,0XFF,0XFF,0XFC,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XCF,0XFF,0X3F,0XFF,
0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XF3,0XFC,
0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3C,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X03,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XF3,0X3F,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFC,
0XFF,0XFF,0XF0,0X3C,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFC,0XFF,0XFF,0XF3,0X3F,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XC0,0X00,0XFF,0XFF,0XF3,0X3F,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X3C,0XF3,0XFF,0XFF,0XF3,0X3F,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFC,0X03,0XFF,0XFF,0XFF,0XFF,0X3C,0XFC,0XFF,0XFF,0XF3,0X3C,0X3F,0XFF,0XF3,0XFF,
0X3F,0XFF,0XF3,0XFC,0XFF,0XFF,0XFF,0XFF,0X3C,0XFC,0XFF,0XFF,0XFC,0X00,0XFF,0XFF,
0XF0,0X00,0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,0X0F,0X3C,0XFF,0XFF,0XFF,0XFF,
0XFF,0XF0,0XF3,0X3F,0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,0XC3,0X00,0XFF,0XFF,
0XCF,0XFF,0X3F,0XFC,0X3F,0X3F,0XFF,0XFF,0XF3,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XC3,
0XFF,0XFF,0XC0,0X00,0X3F,0XFF,0X3F,0XCF,0XFF,0XFF,0XF3,0XFC,0XFC,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XCC,0XFF,0X3F,0XFF,0X3F,0XF3,0XFF,0XF0,0X00,0X00,0X00,0XFF,
0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0X3F,0XFF,0XFC,0X33,0XF3,0X3F,0XF3,0XF3,0XFC,
0XFC,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,0XFF,0XCF,0XFF,0XF0,0XF0,0X00,0X3F,0XFF,
0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,0X0F,0XF0,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XF3,0XFF,
0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,0X0F,0XCC,0XFF,0XFF,0XCF,0XF3,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XF3,0XFC,0XFF,0XFF,0XFF,0XFF,0XF3,0X3F,0XFF,0XFF,0XC0,0X00,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X03,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,
0XCF,0XFF,0X3F,0XFF,0XFC,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0X3C,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFC,0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,
0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XC0,0X00,0X3F,0XFF,
0XFF,0XFF,0X3F,0X3C,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XCC,0XFF,
0X3F,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XC3,0XFC,0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,
0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0X33,0X3F,0XFF,0XFF,0XC3,0XF3,0X3F,0XFF,0XF3,0XFC,
0X3F,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0X0F,0XCC,0XFF,0XFF,0XFC,0XCF,0XFF,0XFF,
0XFC,0X00,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0X0F,0XF0,0XFF,0XFF,0XFF,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XF3,0X3F,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,
0XCF,0XCF,0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFC,
0XFF,0XFF,0XC0,0X00,0X3F,0XFF,0XC0,0X00,0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XCF,0X3F,0X3F,0XFF,0XFC,0XFF,0XFF,0XFF,
0XFF,0XFF,0XF0,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XC3,0XFF,
0XFF,0XFF,0XFF,0XFF,0XC0,0X03,0XFF,0XFF,0XF0,0XFC,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,
0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,0XC0,0XFF,0X3F,0XFF,0XFF,0X3F,
0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,
0XCF,0X3F,0X3F,0XFF,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,0XCF,0XFF,
0X3F,0XFF,0XC0,0X00,0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,
0XCF,0XFF,0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0X03,0XF0,
0XFF,0XFF,0XF3,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,
0XC0,0X03,0XFF,0XFF,0XFC,0X00,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFC,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0X3F,0XFF,0XCF,0X3F,0X3F,0XFF,
0XFC,0X03,0XFF,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,0XF0,0X00,0X3F,0XFF,0XFF,0X3F,
0XFF,0XFF,0XC3,0XFC,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XF0,0XF3,0X3F,0X3F,0XFF,
0XFF,0X3F,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFC,0X3F,0X3F,
0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,
0X3F,0XCF,0XFF,0XFF,0XCF,0X3F,0X3F,0XFF,0XC3,0XFF,0X3F,0XFF,0XFF,0XFF,0X3F,0XFF,
0XFF,0XFF,0X3F,0XF3,0XFF,0XFF,0XC0,0X00,0X3F,0XFF,0XF3,0XFC,0XFC,0XFF,0XFF,0XFF,
0X3F,0XFF,0XFF,0XFC,0X33,0XF3,0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XC0,0X00,0X00,0XFF,
0XFF,0XFF,0X3F,0XFC,0XFF,0XF0,0XF0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,
0XFC,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XF3,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,
0XF3,0XFC,0X3F,0XFF,0XF0,0X3C,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,
0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XF3,0X3F,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XCC,0XFF,0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XF3,0X3F,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XF3,0X3F,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XF3,0XFC,0X3F,0XFF,0XF3,0X3C,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFC,0X00,0XFF,0XFF,0XFC,0X00,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XF3,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X0F,0XFF,0XFF,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XF0,0XFC,0XFF,0XFF,0XFF,0XFF,0XC0,0X03,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,
0XFC,0X03,0XFF,0XFF,0XC0,0XFF,0X3F,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XC3,0XFC,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,
0XCF,0XFF,0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,0X3F,0XFC,
0XFF,0XFF,0XC0,0X00,0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,
0X3F,0XFC,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XC3,0XFF,0X3F,0XFF,0XF3,0XFC,0X3F,0XFF,
0XFF,0XFF,0X03,0XF0,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XF3,0XFC,0XFC,0XFF,0XFC,0X00,
0XFF,0XFF,0XFF,0XFF,0XC0,0X03,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XCF,0XFF,
0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,
0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X0F,0XFF,0XFF,0XC0,0X00,
0X3F,0XFF,0XC3,0XFF,0XFF,0XFF,0XFF,0XF0,0XFF,0XFF,0XFF,0XFF,0XCF,0XF3,0XFF,0XFF,
0XCF,0XFF,0X3F,0XFF,0XCF,0XFF,0XFF,0XFC,0X0F,0XC0,0X3F,0XFF,0XFF,0XFF,0X3F,0XFC,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0X3F,0X0F,0XCF,0XFF,0XFF,0XFF,
0X3F,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X3F,0XFC,0XFF,0X3F,0XCF,0XFF,
0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XCF,0XFF,0X3F,0XFC,0XFF,0X3F,
0XCF,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,0XC0,0X00,0X3F,0XFF,0XCF,0XFF,0XFF,0XFC,
0XFC,0X3F,0XCF,0XFF,0XFF,0XFF,0XCF,0XF0,0XFC,0XFF,0XC3,0XFF,0X3F,0XFF,0XC3,0XFF,
0XFF,0XFC,0XFC,0XFF,0X3F,0XFF,0XFF,0XFF,0X00,0X00,0X00,0XFF,0XFC,0X0F,0XFF,0XFF,
0XFC,0XFF,0XFF,0XFF,0X00,0XFC,0X3F,0XFF,0XFF,0XFF,0X3F,0XFF,0XFC,0XFF,0XFF,0XF0,
0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XC3,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XF0,0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFC,0X0F,0XFF,0XFF,0XC3,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,
0XC0,0X0F,0XFF,0XFF,0XC3,0XFF,0X3F,0XFF,0XC3,0XF3,0X3F,0XFC,0XFF,0XFF,0XCF,0XFF,
0XFF,0X3F,0X00,0X03,0XFF,0XFF,0XC0,0X00,0X3F,0XFF,0XFC,0XCF,0XFF,0XFC,0X00,0X00,
0X0F,0XFF,0XFF,0X3C,0X0F,0XF3,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0X3F,0XFF,0XFC,
0XFF,0X3F,0XCF,0XFF,0XFF,0X3C,0X3F,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XCF,
0X3F,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0X3C,0X3F,0XF3,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,
0XC0,0X00,0X3F,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0X3C,0X3F,0XF3,0XFF,0XFF,0XC0,0X00,
0X3F,0XFF,0XCF,0XFF,0X3F,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XCF,0X0F,0XF3,0XFF,0XFF,
0XCC,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XF0,0X00,0X0F,
0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XF0,0X3C,0XFF,0XFC,0XFF,0X3F,0XCF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XF3,0X3F,0X3F,0XFC,0X00,0X00,
0X0F,0XFF,0XFF,0XFF,0XF0,0X0F,0XFF,0XFF,0XCF,0XF3,0X3F,0XFF,0XF3,0X3F,0X3F,0XFC,
0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XC0,0X03,0XFF,0XFF,0XC0,0X00,0X3F,0XFF,0XF3,0X3F,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,
0XF3,0X3C,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFC,0X00,0XFF,0XFF,0XF0,0X03,0XFF,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,
0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0XFF,0XFF,0XFF,0XFF,0X3F,0XFC,
0XFF,0XFF,0XFF,0XC0,0X3F,0XFF,0XFF,0XFF,0X3F,0XFF,0X3F,0XFF,0X3F,0XFF,0XFF,0XFF,
0X03,0XF0,0XFF,0XFF,0XFC,0X03,0X3F,0XFF,0XFF,0XC0,0X3F,0XFC,0XFF,0XFF,0XCF,0XFF,
0XFF,0XFF,0XC0,0X03,0XFF,0XFF,0XC0,0XFF,0XFF,0XFF,0XFC,0X03,0X3F,0XFC,0XFF,0XFF,
0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XFF,0XFF,0XFF,0XC0,0XFF,0XFF,0XFC,
0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFC,0X0F,0XFF,0XFF,0X0F,0X3F,0XFF,0XC0,0XFF,
0XFF,0XFC,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0X3F,0XFC,0X3F,0XFF,0XFF,0XF0,0X3F,0XFF,
0XFF,0X0F,0X3F,0XFC,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,
0X3F,0XFF,0XFF,0XF0,0X3F,0XFF,0X3F,0XFF,0X3F,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0X3F,0XFC,
0XFF,0XFF,0XC0,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X03,0XFF,0XFF,0XFF,0XFF,
0X3F,0XFC,0XFF,0XFF,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X3C,0XFF,0XFC,0XFF,0XFC,0XFF,0XFF,0XFC,0X03,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X3F,0X00,0XFF,0XF3,0XFF,0XFF,0X3F,0XFF,0XF3,0XCC,0X3F,0XFF,
0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XF3,0XFF,0XFF,0X3F,0XFF,0XCF,0XCF,
0X3F,0XFF,0X00,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XF3,0XFF,0XFF,0X3F,0XFF,
0XCF,0XCF,0X3F,0XFC,0X00,0XFF,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XF3,0XFF,0XFF,
0X3F,0XFF,0XF3,0XFC,0X3F,0XFC,0XFF,0X3C,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,
0XFF,0XFF,0X3F,0XFF,0XF0,0XFC,0XFF,0XFC,0XFF,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0X0F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0X3F,
0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,};


const unsigned char gImage_gongsi[3096] = { /* 0X81,0X02,0XAC,0X00,0X48,0X00, */
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFC,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFC,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X30,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X30,0XC0,0X03,0XFF,0XFF,0XFF,0XFF,
0XFF,0XF3,0XF0,0XF0,0XFF,0XFF,0XF3,0XFF,0XF0,0XFF,0XFC,0X30,0XC0,0X03,0XFF,0XFF,
0XFF,0XFF,0XFF,0XC3,0XF0,0XC3,0XFF,0XFC,0X33,0X00,0X3C,0X3F,0XFC,0X30,0XC3,0XC3,
0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0XFC,0X33,0X00,0X3C,0X3F,0XFC,0X30,
0XC3,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0XFC,0X03,0X33,0X00,0X3F,
0XFC,0X30,0XC3,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0XF0,0X0F,0XFF,0XF0,0X03,0X33,
0X00,0XFF,0XFC,0X30,0XC3,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0XF0,0XC0,0XFF,0XF0,
0X33,0X33,0X3F,0XFF,0XFC,0X30,0XC0,0X03,0XFF,0XFF,0XFF,0XFC,0X3F,0XF0,0XF0,0XF0,
0X3F,0XFC,0X03,0X33,0X03,0XFF,0XFC,0X30,0XC0,0X03,0XFF,0XFF,0X0F,0XFC,0X3F,0XFF,
0XF0,0XFC,0XFF,0XFC,0X03,0X00,0X00,0XFF,0XFF,0XF0,0XFF,0XFF,0XFF,0XF3,0X0F,0XF0,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X33,0X00,0X3C,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC3,
0X0F,0XC3,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XF3,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0X0F,0X0F,0X0F,0XFF,0XC3,0X00,0X03,0XF0,0XFF,0XFF,0XFF,0X3F,0X3F,0XFF,0XFF,
0XCF,0XFF,0XFF,0XFF,0X0C,0X3F,0XFF,0XC3,0X00,0X03,0XF0,0XFF,0XF0,0XFF,0X0F,0X3F,
0XFF,0XFF,0X0F,0XFF,0XFF,0X00,0X00,0X00,0X03,0XC3,0X3C,0XC3,0XF3,0XF0,0X00,0X00,
0X0F,0XFF,0XFF,0XFC,0X3F,0XF0,0XFF,0X00,0X00,0X00,0X03,0XC0,0X00,0X00,0XC3,0XF0,
0X00,0X00,0X03,0XFF,0XFF,0XF0,0XFF,0XC0,0XFF,0XFF,0X00,0XFF,0XFF,0XC0,0X00,0X00,
0X0F,0XFF,0XF0,0XFF,0XC3,0XFF,0XFC,0X03,0XFC,0X03,0XFF,0XFF,0X0C,0X3F,0XFF,0XC3,
0X3C,0XC3,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X0F,0XFC,0X33,0XFF,0XFF,0X0F,0X0F,
0XFF,0XC3,0X3C,0XC3,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,
0X0F,0XC3,0XFF,0XC3,0X00,0X00,0X33,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0XF0,
0XFF,0XFF,0X0F,0XF0,0XFF,0XC3,0X00,0X03,0XF0,0XFF,0XFF,0X0F,0XC0,0X3F,0XFF,0XFF,
0X00,0XF0,0XFF,0XFF,0X0F,0XFC,0X3F,0XC0,0XFF,0XFF,0XFF,0XF0,0XFF,0X0F,0XF0,0X3F,
0XFC,0X0F,0XF0,0X30,0XFF,0XFF,0XFF,0XFF,0X3F,0XC0,0X00,0X00,0X00,0XF0,0XFF,0X0F,
0XC0,0XFF,0XFC,0X03,0XFF,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0XF0,
0X00,0X00,0X03,0XFF,0XFF,0XF0,0X3F,0XC0,0XFF,0XFF,0XFF,0XFF,0XC3,0XFF,0XF0,0XFF,
0XFF,0XFC,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0X0F,0XF0,0XFF,0XF0,0XF0,0XFF,0XC3,0XFF,
0XFC,0X3F,0XFF,0XFC,0X3F,0X0F,0XF3,0XFF,0XFF,0XFF,0XC3,0XFF,0XFF,0XF0,0XF0,0X0F,
0XCF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0X0F,0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,
0XF0,0XC3,0X0F,0XFF,0XFF,0X0F,0XF3,0XFC,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0X00,0X00,0XF0,0X3F,0XFF,0XFF,0X0F,0XC3,0XFC,0X00,0X00,0X00,0X3F,0XFF,0XFF,
0XFF,0XFC,0XFF,0X00,0X00,0XF0,0X3F,0XFC,0X3F,0X0F,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFC,0X00,0X0C,0XFC,0X3F,0XF0,0XF0,0X03,0X0F,0XFC,0X03,0X0F,0X0F,0XFF,0XF0,0XF0,
0XC3,0XFF,0XFC,0X00,0X0C,0X30,0XFF,0XF0,0XF0,0X0F,0XCF,0XFC,0X30,0X0C,0X3F,0XFC,
0X3C,0X30,0XC3,0XFF,0XFC,0X33,0X0F,0X03,0XFF,0XF0,0XF0,0XFF,0XC3,0XFC,0X3C,0X00,
0XFF,0XFC,0X0C,0X00,0XF0,0XFF,0XFC,0X33,0X00,0X0F,0XFF,0XFF,0X0C,0X3F,0XC3,0XFC,
0X3F,0X03,0XFF,0XFF,0XC0,0XC0,0XF0,0XFF,0XFC,0X33,0X0F,0XF0,0XFF,0XFF,0X0C,0X3F,
0XFF,0XC0,0X00,0X00,0X00,0XFF,0XF0,0XF0,0XF0,0XFF,0XFC,0X00,0X00,0X00,0X3F,0XC0,
0X00,0X00,0X0F,0XC0,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X00,0X00,
0X3F,0XC0,0X00,0X00,0X03,0XFC,0X3F,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X0F,0X0F,0XC3,0XFC,0X3C,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFC,0X03,0XC0,0X3F,0XFF,0XFF,0X0F,0X0F,0XFF,0XFC,0X30,0X0C,0X3F,0XFF,0XFF,0XFF,
0XC0,0X3F,0XFC,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X03,0X0F,0X0F,0XFF,
0XFF,0X0F,0XC0,0X3F,0XFC,0X3C,0X3F,0X0F,0XFF,0XFF,0XC3,0XFF,0XFF,0XFC,0X3F,0X0F,
0XC3,0XFC,0X3F,0X0F,0XFC,0X3F,0XFC,0X00,0X00,0X00,0X3F,0XFF,0XC3,0XFC,0X3F,0XFF,
0XFF,0X0F,0XF3,0XFC,0X3F,0X0F,0XFC,0X3F,0XFC,0X00,0X00,0X00,0X3F,0XC3,0XC3,0XF0,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0X0F,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XC3,
0XC3,0XC3,0XFF,0XFC,0X30,0X0F,0XFF,0XFC,0X3F,0X00,0X00,0X3F,0XFF,0X0F,0XFF,0XFF,
0XFF,0XC3,0XC3,0X0F,0XFF,0XFC,0X30,0X0F,0XFF,0XFC,0X3F,0X00,0X00,0XFF,0XFF,0X0F,
0XFF,0XFF,0XFF,0XC3,0XC3,0XFF,0XFF,0XFC,0X30,0XF0,0X0F,0XFC,0X00,0X0F,0XFF,0XFF,
0XFF,0X0C,0X00,0X00,0XFF,0XC3,0XC0,0X00,0X0F,0XC0,0X00,0XF0,0X03,0XFC,0X00,0X00,
0X3F,0XFF,0XFF,0X0C,0X00,0X00,0X3F,0XC3,0XC0,0X00,0X03,0XC0,0X00,0XF0,0XF3,0XFC,
0X3F,0X00,0X0F,0XFF,0XFF,0X0C,0X33,0XCC,0X3F,0XC3,0XC3,0XFF,0XC3,0XFC,0X30,0XF0,
0XFF,0XFC,0X3F,0X0F,0XC3,0XFF,0XFF,0X0C,0X33,0XCF,0XFF,0XC3,0XC3,0XFF,0XC3,0XC0,
0X00,0XC0,0X00,0XFC,0X3F,0X0F,0XF0,0XFF,0XFF,0X0C,0X33,0XCF,0XFF,0XC3,0XC3,0X0F,
0XFF,0XC0,0X00,0XC0,0X00,0XFC,0X3F,0X0F,0XFC,0X3F,0XF0,0X0C,0X33,0XCF,0XFF,0XC3,
0XC3,0X03,0XFF,0XFC,0X30,0XF0,0XFF,0XFF,0XFF,0X0F,0XFF,0X3F,0XF0,0X00,0X33,0XCF,
0XFF,0XC3,0XC3,0XF0,0X3F,0XFC,0X30,0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,
0X00,0X00,0X3F,0XFF,0XC3,0XFC,0X3F,0XC0,0X00,0XF0,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0X0C,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0XF0,0X03,0XFF,0XFF,0XFF,
0XF0,0XFF,0XFF,0X0F,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X30,0X0F,0XFF,0XFF,
0XFC,0X3F,0XF0,0XFF,0XFF,0X0F,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XC3,0XFC,0X30,0X0F,
0XFF,0XFF,0XFC,0X3F,0XC3,0XFF,0XFF,0X0F,0XF0,0XFF,0XFF,0XFF,0XFF,0XCF,0XC3,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0X0F,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XC0,0X00,0XC3,
0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,
0X00,0XF0,0XC3,0XFF,0XC3,0XFF,0XFF,0XFC,0X3F,0XF3,0XFF,0XFF,0XFF,0XFF,0X0F,0XFF,
0XFF,0XC3,0X30,0XFF,0XC3,0XFF,0XC3,0XFF,0XFF,0XFC,0X00,0X00,0X00,0XFF,0XFF,0XFF,
0X0F,0XFF,0XFF,0XC3,0X30,0X00,0X03,0XC3,0XC3,0XC0,0X00,0XF0,0XC0,0X00,0X00,0X3F,
0XF0,0XFF,0X0F,0XFF,0XFF,0XC3,0X30,0X00,0X03,0XC3,0XC3,0XC0,0X00,0XF0,0XC3,0XFF,
0XFC,0X3F,0XF0,0X3F,0X0F,0XFF,0XFF,0XC3,0X30,0XFF,0XC3,0XC3,0XC3,0XC3,0XC3,0XFF,
0XC3,0X00,0XFF,0XFF,0XF0,0X0F,0X0F,0XFF,0XFF,0XC3,0X30,0X00,0X03,0XF0,0X00,0X03,
0XC3,0XFF,0XC3,0X00,0X0F,0XFF,0XF0,0XC3,0X0F,0XFF,0XFF,0XC3,0X30,0X00,0X03,0XF0,
0X00,0X03,0XC3,0XFF,0XC3,0X0F,0X03,0XFF,0XF0,0XF0,0X00,0X00,0XFF,0XC3,0X30,0XFF,
0XC3,0XF0,0XC3,0XC3,0XC3,0XFF,0XFF,0X0F,0XF0,0XFF,0XF0,0XF0,0X00,0X00,0X3F,0XC0,
0X00,0XF0,0XC3,0XF0,0XC3,0XC0,0X00,0XFF,0XFF,0X0F,0XF0,0XFF,0XF0,0XFF,0X0F,0XFC,
0X3F,0XC0,0X00,0XC3,0XC3,0XF0,0XC3,0XC0,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0XFF,
0X0F,0XFC,0XFF,0XFF,0XFF,0XCF,0XC3,0XFF,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XF0,0XFF,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XC3,0XF0,0XFF,0XF0,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XF0,0XFF,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC3,0XFC,0X3C,0X03,0XFF,
0XFF,0XFF,0XFF,0XFF,0XF0,0XFF,0X0F,0XFF,0XFF,0XFF,0XF0,0XFC,0X03,0XCF,0XF0,0XFF,
0XC0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0XFF,0XFF,0X0F,0XF0,0XFF,0X03,0XFF,
0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0XFF,0XFF,0X0F,0XF0,0XFC,
0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,
0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,
0XFF,0XC0,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XC0,0X3F,0XC3,0XF0,0XFF,0X3F,0XFF,0XC3,0XFF,0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0X00,0X00,0X3C,0X3F,0XC3,0XF0,0XFF,0X0F,0XFF,0XC3,0XC3,0XF0,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0X00,0X00,0X3C,0X3F,0XC0,0X00,0X00,0X03,0XFF,0XC3,0XC3,0XF0,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0X3C,0X3C,0X3F,0XC0,0X00,0X00,0X03,0XFF,0XC3,0XC3,
0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0X3C,0X3C,0X3F,0XFF,0XFF,0XFF,0XFF,0XC0,
0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0X3C,0X3C,0X3F,0XFF,0X0F,0X0C,
0X3F,0XC0,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XC3,
0XC3,0X0C,0X3F,0XFF,0XC3,0XC3,0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,
0XFF,0XC0,0XC0,0X0F,0X0F,0XFF,0XC3,0XC3,0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,
0X3C,0X3F,0XFF,0XFC,0X0C,0X0F,0X0F,0XFF,0XC3,0XC3,0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0X0F,0X3C,0X3F,0XFF,0XFF,0X0F,0X0F,0X0F,0XF0,0X03,0XC3,0XF0,0XFF,0XFF,0XFF,
0XFC,0XFF,0XFF,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X03,0XFF,0XF0,0XFC,
0X00,0X00,0XF0,0XFF,0XFF,0X00,0X00,0X0F,0XFF,0XFF,0XF0,0XFF,0XFF,0XFF,0XC0,0XFF,
0XF0,0XFC,0X00,0X00,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0XFF,0XFF,0XFF,
0XFC,0XFF,0XF0,0XFC,0X33,0X30,0XCC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0XF0,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X33,0X30,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0X03,
0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X33,0X30,0XFC,0X3F,0XFF,0XFF,0XFF,0XF3,
0XFF,0X00,0XF0,0XFF,0XFF,0XFF,0X00,0X00,0X03,0XFC,0X00,0X00,0XC0,0X3F,0XF0,0X03,
0XFF,0XF3,0X3F,0X0C,0X30,0XFF,0XFF,0XFF,0X00,0X00,0X00,0XFC,0X00,0X00,0X0C,0X3F,
0XF0,0X00,0X03,0X33,0X3F,0X0F,0X00,0X00,0X0F,0XFF,0X0F,0XFF,0XF0,0XFF,0XFF,0X0F,
0XFC,0X3F,0XF3,0X30,0X03,0X30,0X3F,0X0F,0X00,0X00,0X03,0XC0,0X0F,0X03,0XF0,0XFF,
0X0C,0X3F,0XC0,0X3F,0XF3,0X33,0X30,0X00,0XFF,0X0F,0XF0,0XFF,0XC3,0XC0,0X03,0X03,
0XFF,0XF0,0X00,0X00,0XC0,0XFF,0XF0,0XC3,0X30,0X03,0XFF,0X0F,0XF0,0XFF,0XCF,0XFF,
0XC0,0XFF,0XFF,0XF0,0X00,0X00,0XFF,0XFF,0XFF,0XF0,0X03,0X33,0XFF,0X0F,0XF0,0XFF,
0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0X0C,0X3F,0XC0,0XFF,0XF0,0X00,0X03,0X33,0XFF,0X0F,
0XF0,0XFF,0XFF,0XFF,0X00,0X00,0X03,0XFF,0X0F,0XC3,0XFC,0X3F,0XF0,0X03,0X30,0X03,
0XFF,0X0F,0XF0,0XFF,0XFF,0XFF,0X00,0X00,0X03,0XFF,0XFF,0XF3,0XFF,0XFF,0XF3,0X33,
0X30,0X00,0XFF,0XFF,0XF0,0XFF,0XFF,0XC3,0X0F,0X0F,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XF3,0X33,0X33,0X30,0X3F,0XFF,0XF0,0XFF,0XFF,0XC0,0X0F,0X0F,0X0F,0XFF,0X0F,0X3F,
0XFF,0XFF,0XF0,0XC0,0X03,0X33,0X3F,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X00,0X03,0XFF,
0X0C,0X3F,0XFF,0XFF,0XF3,0XC0,0X03,0X33,0X3F,0XFF,0XFF,0XFC,0X0F,0XFF,0X00,0X00,
0X03,0XFF,0X00,0XF0,0XFF,0XFF,0XF3,0XCF,0XFF,0XF3,0X3F,0XFF,0XFF,0XFC,0X03,0XFF,
0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X03,
0XC3,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,
0X00,0X03,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0XF0,0XC3,0XFF,0XFF,0XFF,0XFF,0X0F,
0X3F,0XF0,0XF3,0XC3,0XC3,0XF0,0X00,0X00,0X03,0XFF,0X0C,0X30,0XF0,0XFF,0XFC,0X00,
0X03,0X0F,0X3F,0XF0,0XF3,0XC3,0XC3,0XF0,0X00,0X00,0X00,0XFF,0XFF,0X30,0XC0,0XFF,
0XFC,0X00,0X03,0X0C,0X3F,0XF0,0XF3,0XC3,0XC3,0XF0,0XFF,0XFF,0XF0,0XFF,0X0C,0XC0,
0XCC,0X3F,0XFC,0X3C,0XF3,0X0C,0X3F,0X00,0X00,0X00,0X03,0XF0,0XFF,0XFF,0XF3,0XFF,
0X00,0XC0,0XFC,0X3F,0XFC,0X30,0XC3,0X00,0XFF,0X00,0X00,0X00,0X0F,0XF0,0XFF,0XFF,
0XFF,0XF0,0X00,0X0C,0X3C,0X3F,0XFC,0X3C,0XCF,0X03,0XFF,0XF0,0XF3,0XC3,0XFF,0XFF,
0XFF,0XFF,0XFF,0XF0,0X00,0X0F,0X0F,0X3F,0XFC,0X00,0X00,0X0F,0XFF,0XF0,0XF3,0XC3,
0XFF,0XF0,0XFF,0XFF,0XFF,0XFF,0X00,0XFF,0XCF,0X3F,0XF0,0X00,0X00,0X0F,0XFF,0XF0,
0X00,0X00,0XFF,0XC3,0X00,0X00,0X00,0XFF,0X0C,0X3F,0XFF,0XFF,0XF0,0X3C,0X0F,0X03,
0XFF,0XF0,0X00,0X00,0XFF,0XFF,0X00,0X00,0X00,0XFF,0XFF,0X3F,0XFF,0XFF,0XFC,0X30,
0XC3,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFC,0X3C,0XF3,0X0C,0X3F,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0XFF,0XFC,0X3F,
0XFC,0X3F,0XFC,0X00,0X03,0X0C,0X3F,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X00,0X00,0XFF,
0X0C,0X30,0X0C,0X3F,0XFC,0X00,0X03,0X0F,0X3F,0XFF,0XC0,0X03,0XFF,0XFF,0XC3,0XFF,
0XFF,0XFF,0X0C,0X30,0X0C,0X3F,0XFF,0XFF,0XFF,0X0F,0X3F,0XFF,0X3F,0XFC,0XFF,0XFF,
0XF0,0XFF,0XFF,0XFF,0X0C,0X33,0X0C,0X3F,0XFF,0XFF,0XFF,0X0F,0XFF,0XFC,0XFF,0XFF,
0X3F,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X33,0X0C,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,
0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XF3,0XF0,0X00,0X33,0X0C,0X3F,0XF0,0X00,0X00,0X00,
0X3F,0XF3,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XF0,0XFF,0X0C,0X33,0X0C,0X3F,0XF0,0X00,
0X00,0X00,0X3F,0XF3,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XC3,0XFC,0X0C,0X30,0X0C,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0X0F,0XFC,0X00,0X30,
0X0C,0X3F,0XFF,0XFF,0XC3,0XFF,0XFF,0XF3,0XFF,0XFF,0XCF,0XFF,0XFF,0XFC,0X3F,0XFF,
0XC0,0X3F,0XFC,0X3F,0XFF,0XFC,0X3F,0XFF,0XFF,0XF3,0XFF,0XFF,0XCF,0XFF,0XFF,0XF0,
0XFF,0XFF,0XFC,0X3F,0XF0,0XFF,0XFC,0X00,0X00,0X00,0XFF,0XF0,0X00,0X00,0X0F,0XFF,
0XFF,0X03,0XFF,0XFF,0X0F,0X00,0X03,0XFF,0XFC,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,
0XFF,0XC0,0X00,0X0F,0XFF,0XFC,0X3F,0X00,0X00,0XFF,0XFF,0XFF,0XC3,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XC0,0X00,0X03,0XFF,0XFC,0XFF,0X0F,0XFC,0X3F,0XFF,0XFC,0X3F,0XFF,
0XFF,0XF3,0XFF,0XFF,0XCF,0XFF,0XFF,0XC0,0XFF,0XFF,0XFF,0X0F,0XFF,0X3F,0XF0,0X00,
0X00,0X3F,0XFF,0XF3,0XFC,0XFF,0XCF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XF0,0X00,0X00,0X03,0XFF,0XF3,0XFC,0XFF,0XCF,0XFF,0XFF,0XFF,0X0F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X3F,0XF3,0XFC,0XFF,0XCF,0XFF,0XFF,0XFF,0XC3,0XFC,
0X00,0X00,0X00,0XFF,0XFF,0XF0,0X0F,0XFC,0X3F,0XF3,0XFC,0XFF,0XCF,0XFF,0XFF,0XFF,
0XF0,0XFC,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XC0,0XFF,0XFF,0XF3,0XFC,0XFF,0XCF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFC,0XFF,
0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X0F,0XFF,0XFF,0X0F,0XFF,0XFF,0XFF,0XF3,
0XFC,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X0F,0XFF,0XFF,0X0F,0XFF,0XFF,
0XFF,0XF0,0X00,0X00,0X0F,0XFF,0XC0,0X00,0X0F,0XFF,0XF3,0XFF,0XF0,0XFF,0XFF,0X0F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X03,0XFF,0XC0,0X00,0XF0,0X3F,
0XFF,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC3,0XFF,0XF0,0XFF,0X00,0X00,
0X3C,0X3F,0XFF,0X0F,0XFF,0XFF,0XFF,0XFF,0XC0,0X03,0XFF,0XFF,0XC3,0XFF,0X30,0XF0,
0X0C,0X3C,0X3C,0X3F,0XFF,0X0F,0XFF,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,0XC3,0XFC,
0X30,0XF0,0X3C,0X3F,0XFC,0X3F,0XF0,0X0F,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0X3F,0XC0,
0X03,0XF0,0XFF,0XFF,0X0C,0X00,0X00,0X3F,0XF0,0X0F,0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,
0XCF,0XC0,0X00,0X0F,0XFF,0XFF,0XC0,0X00,0X00,0XFF,0XFF,0X0F,0XFF,0XFF,0XFF,0XF3,
0XFF,0XFF,0XCF,0XFF,0XC0,0X03,0XFF,0XFF,0XF0,0XFF,0XFF,0XFF,0XFF,0X0F,0XFF,0XFF,
0XFF,0XF3,0XFF,0XFF,0XCF,0XFC,0X03,0XF0,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0X0F,
0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,0XCF,0XF0,0X03,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0X00,0X00,0X0F,0XFF,0XFC,0XFF,0XFF,0X3F,0XF3,0XC3,0XFF,0X0F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0X00,0X00,0X00,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,0XC3,0XFF,0XC3,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X3F,0XFF,0XC0,0X03,0XFF,0XFF,0XC3,0XFF,
0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,};


const unsigned char gImage_korean[3096] = { /* 0X81,0X02,0XAC,0X00,0X48,0X00, */
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,
0XFF,0X3F,0XFF,0XFC,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0X3F,
0XFF,0XFF,0XF3,0X3C,0X0C,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XC0,0X00,0X00,0X0F,0XF0,
0X00,0X00,0X03,0XFF,0XF3,0X3C,0XCC,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XF3,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC3,0X3C,0XCC,0XFC,0XFF,0XFF,0XCF,0XFF,0XFF,0XCF,
0XFF,0XFC,0XFF,0XF3,0XFF,0XFF,0X3F,0XFF,0XCF,0X3C,0XCC,0XFC,0XFF,0XFF,0XF3,0XFF,
0XFF,0XCF,0XFF,0XFF,0X3F,0XF3,0XFF,0XFC,0XFF,0XFC,0X3F,0X00,0XCC,0XFC,0XFF,0XFF,
0XF3,0XFF,0XFF,0XCF,0XFF,0XFF,0X3F,0XF3,0XFF,0XC3,0XFF,0XFF,0XCF,0X3C,0XCC,0XFC,
0XFF,0XFF,0XF3,0XFF,0XFF,0XCF,0XFF,0XFF,0X3F,0XF0,0X00,0X3F,0XFF,0XFF,0XCF,0X3C,
0XCC,0XFC,0XFF,0XFF,0XF3,0XFF,0XFF,0XC0,0X00,0X00,0X3F,0XF3,0XFF,0X03,0XFF,0XFF,
0XF3,0X3C,0XCC,0XFC,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XFC,
0XFF,0XFF,0XF3,0X3C,0XCC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,
0XFF,0XFF,0X3F,0XFF,0XF3,0X3C,0XC0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XC0,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFC,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X00,0X03,0XF3,0XFF,0XFF,0XFF,0XFF,0XF0,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0X0F,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XF0,0X00,0X03,0XCF,0XFC,
0X00,0X00,0X00,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XF3,0XFF,
0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XF3,
0XF3,0XCF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0XFF,0XFC,0XFF,0XFF,0XC0,0X00,0X00,
0XFF,0XF3,0XFF,0X3F,0XCF,0XFF,0X00,0X0F,0XFF,0XFC,0X3C,0X3F,0XC3,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XF3,0XF0,0XFF,0XCF,0XFC,0XFF,0XC3,0XFF,0XFC,0XFF,0X3C,0X0F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X0F,0XFF,0XCF,0XFC,0XFF,0XFC,0X3F,0XFC,0XFF,0X3F,
0XCF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XF3,0XF0,0XFF,0XCF,0XFC,0XFF,0XFF,0X3F,0XFC,
0X3C,0X3F,0XF3,0XFF,0XFF,0XC0,0X00,0XC0,0X3F,0XF3,0XFF,0X30,0X0F,0XFC,0XFF,0XFF,
0XCF,0XFF,0X00,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XF3,0X3F,0XF3,0XFF,0XCF,0XFF,0XFC,
0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XC0,0XF3,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCC,0X3F,0X33,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCC,0X3F,0X33,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XCC,
0X3F,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,
0XFF,0XFC,0XC0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X00,
0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X0F,0XFF,0XFF,0XFF,0XC0,0X00,0X30,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XC3,0XFF,0XFF,0XFF,0XFC,0XCF,0XCF,0XCF,0XF0,
0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFC,0X3F,0XFF,0XFF,0XF0,0X0F,0XCF,
0XCF,0XFF,0XFF,0X3F,0XFF,0XFC,0X00,0X00,0X00,0XFC,0XFF,0XFF,0X3F,0XFF,0XFF,0XCF,
0XF3,0XCF,0XCF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XCF,0XFF,
0XFF,0XCF,0XF3,0XCF,0XCF,0XF0,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,
0XCF,0XFF,0XFF,0XCF,0XF3,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X3F,0XFF,
0XFF,0XFF,0XCF,0XFF,0XFF,0XF0,0X0F,0XFF,0XFF,0XF0,0X00,0X3F,0XFF,0XFF,0X3F,0XFF,
0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XC3,0XFF,0XFC,
0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XFC,
0XFF,0XFC,0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,0XF3,
0XFF,0XFC,0XFF,0XFF,0X3F,0XFF,0X0F,0XFC,0X00,0X00,0X00,0XFF,0XFF,0XC0,0X00,0X0F,
0X3F,0XF3,0XFF,0XFF,0X3F,0XFF,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0X3F,0X3F,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0X03,0X3F,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,
0XCF,0XFF,0XFF,0XCC,0X30,0X3F,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0XCF,0XFF,0X3F,0XFF,0XFF,0XCC,0X33,0XCF,0X3F,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0XCF,0XF0,0XFF,0XFF,0XFF,0XCC,0X03,0XC0,0X3F,0XFF,0XCF,0XFF,0XFF,0XFC,
0X00,0X00,0X00,0XFC,0XC0,0X0F,0XFF,0XFF,0XFF,0XFC,0XFF,0XCF,0XFF,0XF0,0X00,0X00,
0XF3,0XFF,0XFF,0XFF,0XFF,0XFC,0XCF,0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XCC,0XF3,0XFF,0XFF,0XFF,0XFF,0XFC,0XCF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFC,0XCC,0XF3,0XFC,0X00,0X00,0X00,0XFF,0XCF,0XFF,0XCF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFC,0XCC,0XF3,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XCC,0XF3,0XFC,0X00,0X3F,0XCF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XCC,0XF3,0XFC,0XFF,0X3F,0XF3,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XCC,0XF3,0XFC,0XFF,0X3F,
0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XCC,0X03,0XFC,
0XFF,0X3F,0XF3,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XF0,0X00,0XFF,
0XFF,0XFC,0XFF,0X00,0X03,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XC0,0XCC,0XC0,0XCF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X00,0X00,0XFF,0XFF,0XCC,0XCC,0XCC,
0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCC,
0XCC,0XCC,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XCC,0XCC,0XCC,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0X00,0X0F,
0XFF,0XFF,0XFF,0XCC,0XCC,0XCC,0XCF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFC,0XCC,0X0C,0XFC,
0XFF,0XC3,0XFF,0XFF,0XFF,0XCC,0X0C,0XCC,0X0F,0XFF,0XFF,0XFF,0XFF,0XFC,0XFC,0XCC,
0XCC,0XFC,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X00,0XCC,0XCC,0XFC,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0XFC,0XCC,0XCC,0XFC,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0X3F,0XFF,0XFC,0XFC,0XCC,0XCC,0XFC,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0X3F,0XFF,0XFC,0XFC,0XCC,0XCC,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XC0,
0X00,0X00,0X0F,0XF0,0X00,0X00,0X03,0XFC,0XFC,0XCC,0XCC,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XC0,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0XCC,0XCC,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XCF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFC,0XFC,0XCC,0XCC,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XC3,0XFF,0XFF,0X00,0X00,0XFF,0XFC,0XFC,0XCC,
0XC0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X3F,0XFF,0XFC,0XFF,0XFC,0X3F,0XFF,
0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0X03,0XFF,0XF3,0XFF,0XFF,
0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFC,0X3F,0XF3,
0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XCF,0XF3,0XFC,0X00,0X00,0X00,0XFF,
0XFF,0XFF,0XCF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0XF3,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XCF,0XCF,0X3F,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XF3,0XFC,
0X00,0X00,0X00,0XFF,0XFF,0XCF,0X3F,0X3F,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0XFF,
0XF3,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XC0,0XF0,0X3F,0X3F,0XFF,0XFF,0XFF,0XFF,0XFC,
0X03,0XFF,0XF3,0XFF,0XFF,0X3F,0XCF,0XFF,0XFF,0XCC,0XFF,0X3F,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XF3,0XFF,0XF3,0XFC,0XFF,0X3F,0XF3,0XFF,0XFF,0XCF,0X3F,0X3F,0X3F,0XF0,
0X00,0X00,0X03,0XFF,0XFC,0XFF,0XF3,0XFC,0XFF,0XFF,0XF3,0XFF,0XFF,0XCF,0XCF,0X00,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XF3,0XFC,0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,
0XCF,0X3F,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XCF,0XF3,0XFC,0XFF,0XFF,0XF3,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0XFF,0X3F,0XFF,0XFF,0XCF,0XF3,0XFC,0X00,0X00,
0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFC,0XFF,0X3F,0XFF,0XFF,0XFF,0XF3,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFC,0XFF,0XCF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFC,0XFF,0XCF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFC,0XFF,
0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,
0XFC,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XC0,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XCF,0XFF,
0XFF,0XCF,0XFF,0XFF,0XFF,0XF0,0X03,0XF0,0XFF,0XF3,0XCF,0XCF,0XCF,0XFC,0XFF,0XFF,
0XCF,0XFF,0XFC,0XCF,0XF3,0XFF,0XFF,0XC3,0XF0,0XFC,0XFF,0XF3,0XCF,0XCF,0XCF,0XFC,
0XFF,0XFF,0XF3,0XFF,0XFC,0XCF,0XF3,0XFF,0XFF,0XCF,0XFC,0XFC,0XFF,0XF3,0XCF,0XCF,
0XCF,0XFC,0XFF,0XFF,0XF3,0XFF,0XFC,0XCF,0XF3,0XFF,0XFF,0XC3,0XF0,0XFC,0XFF,0XF3,
0XCF,0XCF,0XCF,0XFC,0XFF,0XFF,0XF3,0XFF,0XFC,0XCF,0XF3,0XFF,0XFF,0XF0,0X03,0XFC,
0XFF,0XF3,0XCF,0XCF,0XCF,0XFC,0XFF,0XFF,0XF3,0XFF,0XFC,0XCF,0XF3,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XF3,0XCF,0XCF,0XCF,0XFC,0X00,0X00,0X03,0XFF,0XFC,0XCF,0XF3,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XCF,0XCF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XCF,
0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XCF,0XCF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFC,0XCF,0XF3,0XFF,0XFF,0XC0,0X00,0X0F,0X3F,0XF3,0XCF,0XCF,0XCF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFC,0XCF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XF0,0X00,0X0F,0XCF,0XFF,
0XFF,0XFF,0XFF,0XFC,0X00,0XCC,0X03,0XFF,0XFF,0XFF,0XF0,0XFF,0X3F,0XFF,0XFF,0XFF,
0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X3F,0XFF,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XCF,0XC0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,
0XFF,0XFF,0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,
0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XCF,0XFC,0X00,0X00,0X00,0XFF,
0XCF,0X03,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XCF,0XFF,0XFF,0XFF,
0XFF,0XFC,0XCC,0X30,0XF3,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFC,0XFF,0XCF,0XFF,
0XFF,0XFF,0XFF,0XFC,0XCC,0XFC,0XF3,0XFF,0XFF,0XC0,0X00,0X30,0X3F,0XFF,0XC3,0XFF,
0XCF,0XFF,0XC0,0X00,0X3F,0XFC,0XCC,0XFC,0X03,0XFF,0XFF,0XFF,0XF3,0XCF,0XCF,0XF0,
0X0F,0XFF,0XCF,0XFF,0X3F,0XFF,0X0F,0XFC,0XCC,0XFC,0XF3,0XFF,0XFF,0XCF,0XFC,0XCF,
0XCF,0XFF,0XCF,0XFF,0XCF,0XFC,0XFF,0XFF,0XF3,0XFC,0XCC,0XFC,0XF3,0XFF,0XFF,0XCF,
0XFC,0XCF,0XCF,0XFF,0XF3,0XFF,0XCF,0XFC,0XFF,0XFF,0XF3,0XFC,0XCC,0X30,0XF3,0XFF,
0XFF,0XCF,0XFC,0XCF,0XCF,0XFF,0XFC,0XFF,0XCF,0XFF,0X3F,0XFF,0X0F,0XFF,0XCF,0X03,
0XF3,0XFF,0XFF,0XCF,0XFC,0XF0,0X3F,0XFF,0XFF,0X3F,0XCF,0XFF,0XC0,0X00,0X3F,0XFF,
0XCF,0XFF,0XF3,0XFF,0XFF,0XC0,0X00,0XFF,0XFF,0XFF,0XFF,0X3F,0XCF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X03,0XFF,0XCF,0XFC,0XFC,0XCF,0X03,0XFC,0X00,0X0F,0XF3,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFC,0XFF,0XCF,0XFC,0XFC,0XCF,0X33,0XFF,0XCF,0XCF,
0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0X3F,0XCF,0XFC,0XF3,0XCC,0XFC,0XFF,
0XCF,0XCF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0X3F,0XCF,0XFC,0XC3,0XCC,
0XFC,0XFF,0XCF,0XCF,0XF3,0XFF,0XFF,0XC0,0X00,0X00,0X0F,0XF3,0XFF,0X00,0X0F,0XFC,
0X0C,0X0C,0XFC,0XFF,0XCF,0XC0,0X03,0XFF,0XFF,0XC0,0X00,0X00,0X0F,0XF3,0XFF,0X3F,
0XCF,0XFC,0XCF,0XCC,0XFC,0XFF,0XCF,0XCF,0XF3,0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,0XF3,
0XFF,0X3F,0XCF,0XFC,0XF3,0XCC,0XFC,0XFF,0XCF,0XCF,0XF3,0XFF,0XFF,0XC0,0X00,0X3F,
0XFF,0XF3,0XFF,0X3F,0XCF,0XFC,0XF3,0XCC,0XFC,0XFF,0XCF,0XCF,0XF3,0XFF,0XFF,0XCF,
0XFF,0XC3,0XFF,0XFC,0XFC,0XFF,0XCF,0XFC,0XFC,0XCF,0X33,0XFF,0XCF,0XCF,0XF3,0XFF,
0XFF,0XCF,0XFF,0XF0,0XFF,0XFF,0X03,0XFF,0XCF,0XFC,0XFC,0XCF,0X03,0XFC,0X00,0X0F,
0XF3,0XFF,0XFF,0XCF,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XCF,0XFF,0XFF,
0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X0F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0XFC,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XCC,0XC3,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XCC,0XCF,0XFF,0X3F,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XCC,0XC3,0XFC,0X3F,0XF3,0XFC,0XCF,0XFF,0XFC,0X00,0X00,
0X00,0XFC,0X00,0X03,0X03,0XFF,0XFF,0XFC,0XFC,0X03,0XFF,0XF3,0XFC,0XCF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XCF,0X3F,0X33,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XF3,0XCF,
0XFF,0XFC,0XFF,0XFF,0XCF,0XFF,0XCF,0X3C,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,
0XC3,0XCF,0XFF,0XFC,0XFF,0XFF,0X3F,0XFF,0XCF,0X3C,0XFC,0XFF,0XFF,0XFF,0XFC,0XFF,
0XFF,0XF0,0X0F,0XC0,0X03,0XFC,0XFF,0XF0,0XFF,0XFC,0X03,0XFC,0XFC,0XFF,0XFF,0XCF,
0XCC,0XFF,0XCF,0XF3,0XCF,0XCF,0XFF,0XFC,0X00,0X0F,0XFF,0XFC,0XFC,0XFC,0XFC,0XFF,
0XFF,0XCF,0XCC,0XFF,0X0F,0XF3,0XF3,0XCF,0XFF,0XFC,0XFF,0XC0,0XFF,0XFC,0XFF,0X3C,
0XFC,0XFF,0XFF,0XC0,0X0C,0XC0,0X3F,0XF3,0XFC,0XCF,0XFF,0XFC,0XFF,0XFF,0X3F,0XFC,
0XFF,0X3F,0X33,0XFF,0XFF,0XCF,0XCC,0XFC,0XFF,0XF3,0XFC,0XCF,0XFF,0XFC,0XFF,0XFF,
0XCF,0XFC,0XFF,0XCF,0X03,0XFF,0XFF,0XCF,0XCC,0XFC,0X3F,0XF3,0XFC,0XCF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0XFF,0XCF,0XFF,0XFF,0XFF,0XC0,0X0C,0XFF,0XCF,0XFF,0XFF,0XCF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XCF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,0X3F,
0XF3,0XFF,0XFF,0XC0,0X00,0X00,0X0F,0XF0,0X00,0X0C,0X0F,0XFC,0X00,0X00,0XF3,0XFC,
0X00,0X00,0XF3,0XFF,0XFF,0XCF,0XFF,0XFC,0XFF,0XFF,0XFF,0X3C,0XCF,0XFF,0XFC,0XFF,
0XF3,0XFF,0XFF,0XF3,0XF3,0XFF,0XFF,0XCF,0XFF,0XFF,0X3F,0XF0,0X0F,0X33,0XF3,0XFC,
0XFC,0XF3,0XF3,0XFF,0XCC,0XF3,0XF3,0XFF,0XFF,0XC0,0X00,0X00,0X3F,0XF3,0XF3,0X33,
0XF3,0XFC,0XFF,0XCF,0XF3,0XFC,0XC3,0X33,0XF3,0XFF,0XFF,0XCF,0XFF,0XFC,0XFF,0XF3,
0XFF,0X33,0XF3,0XFC,0XFC,0X3F,0XF3,0XFC,0XC3,0X33,0XF3,0XFF,0XFF,0XCF,0XFF,0XFF,
0X3F,0XF3,0XFF,0X33,0XF3,0XFC,0X03,0XFF,0XF3,0XFC,0XC3,0X03,0XF3,0XFF,0XFF,0XC0,
0X00,0X00,0X3F,0XF3,0XC0,0X33,0XF3,0XFC,0XFC,0X3F,0XF3,0XFC,0XC3,0X3C,0XF3,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0X3C,0XCF,0XFC,0XFF,0XCC,0X03,0XFC,0XC3,0X3C,
0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0X3C,0X0F,0XFC,0XFF,0XF3,0XFF,0XFF,
0XCC,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,};



const unsigned char gImage_OED[3096] = { /* 0X81,0X02,0XAC,0X00,0X48,0X00, */
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XC0,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0X00,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XC0,0X00,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XC0,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0XFF,0XC0,
0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X00,0X00,0X00,0X03,
0XFF,0XFC,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,
0X00,0X03,0XFF,0XFF,0XC0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0XFF,0XFF,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XF0,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XC0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XC0,0X00,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XC0,0X00,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X0F,0XFF,0XFF,0XFC,0X00,0X00,0X3F,0XF0,
0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0X00,0X00,
0X3F,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XFF,0XFF,0XFF,
0X00,0X00,0X3F,0XFF,0XC0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0X3F,0XFC,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC0,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC0,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC0,0XC3,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC0,0X03,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XFC,
0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0X3F,0XFF,0XC0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0X3F,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC3,0X0C,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC3,0X0C,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC3,0X0C,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC3,0X0C,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC3,
0X0C,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0X3F,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0X3F,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XF0,0X30,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC0,0X00,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC3,0XC3,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC3,
0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0X3F,0XC3,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0X3F,0XC0,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0X3F,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0X3F,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XF0,0XF0,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XF0,0X00,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XC0,0X00,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XC3,
0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X3F,0XC3,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X3F,0XC3,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X3F,0XC3,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XC0,0X00,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0XFF,0XC0,0X03,0XFF,0X00,0X00,0X3F,0XC3,0X0C,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0XFF,0XC0,0X03,0XFF,0X00,0X00,0X3F,0XC3,0X0C,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XC0,0X03,0XFF,0X00,0X00,0X3F,0XC3,0X0C,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XC0,0X03,0XFF,0X00,0X00,0X3F,0XC3,
0X0C,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XC0,0X03,0XFF,0X00,0X00,
0X3F,0XC3,0X0C,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XC0,0X03,0XFF,
0X00,0X00,0X3F,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XC0,
0X03,0XFF,0X00,0X00,0X3F,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0XFF,0XC0,0X03,0XFF,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0XFF,0XC0,0X03,0XFF,0X00,0X00,0X3F,0XF0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0XFF,0XC0,0X03,0XFF,0X00,0X00,0X3F,0XC0,0X00,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XC0,0X03,0XFF,0X00,0X00,0X3F,0XC3,0XC3,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XC0,0X03,0XFF,0X00,0X00,0X3F,0XC3,
0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XC0,0X03,0XFF,0X00,0X00,
0X3F,0XC3,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XC0,0X03,0XFF,
0X00,0X00,0X3F,0XC3,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XC0,
0X03,0XFF,0X00,0X00,0X3F,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0XFF,0XC0,0X03,0XFF,0X00,0X00,0X3F,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0XFF,0XC0,0X03,0XFF,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0XFF,0XC0,0X03,0XFF,0X00,0X00,0X3F,0XF0,0X03,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XC0,0X03,0XFF,0X00,0X00,0X3F,0XC0,0X00,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XC0,0X03,0XFF,0X00,0X00,0X3F,0XC0,
0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XC0,0X03,0XFF,0X00,0X00,
0X3F,0XC3,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XC0,0X03,0XFF,
0X00,0X00,0X3F,0XC3,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XC0,
0X03,0XFF,0X00,0X00,0X3F,0XC3,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0XFF,0XC0,0X03,0XFF,0X00,0X00,0X3F,0XC3,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0XFF,0XC0,0X03,0XFF,0X00,0X00,0X3F,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0XFF,0XC0,0X03,0XFF,0X00,0X00,0X3F,0XC0,0X00,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XC0,0X03,0XFF,0X00,0X00,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XC0,0X03,0XFF,0X00,0X00,0X3F,0XFF,
0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XC0,0X03,0XFF,0X00,0X00,
0X3F,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XC0,0X03,0XFF,
0X00,0X00,0X3F,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XC0,
0X03,0XFF,0X00,0X00,0X3F,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0XFF,0XF0,0X0F,0XFF,0X00,0X00,0X3F,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC0,0X00,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XF0,
0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X0F,0XFF,0XFF,0XFC,0X00,0X00,
0X3F,0XC0,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X3F,0XC3,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X3F,0XC3,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XC3,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XC3,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XC0,0X00,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XC0,0X00,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X00,0X00,0X00,0X03,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,
0X00,0X3F,0XFF,0XC3,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,
0X00,0X00,0X00,0XFF,0XFF,0XC0,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X00,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XF0,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XC0,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFC,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X03,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,
0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XCF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X03,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X00,
0X00,0X00,0X0F,0XFF,0XFF,0XC3,0X3C,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,
0X00,0X00,0X00,0X00,0X03,0XFF,0XFF,0XC3,0X0C,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XC3,0X0C,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFC,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0XFF,0XC3,0X0C,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X00,0X00,0X00,0X03,0XFF,0XC3,0X0C,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X03,0XFF,0XC3,
0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0XFF,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0XFF,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0X03,0XFF,0XFF,0XF0,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC0,
0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0X3F,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0X3F,0XF0,0XC0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0X3F,0XFF,0XC0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XFF,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XF0,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC0,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC0,0XC0,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC0,
0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0X3F,0XC0,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0X3F,0XC3,0X0C,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC3,0X0C,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC3,0X0C,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC3,0X0C,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC3,0X0C,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC0,
0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0X3F,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0X3F,0XF0,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC0,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC3,0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC3,0XC3,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC3,0XC3,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XC3,
0XC3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0X00,0X00,
0X3F,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X0F,0XFF,0XFF,0XF0,
0X00,0X00,0X3F,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,0X00,
0X00,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,
0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XF0,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XC0,0XF0,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XC3,0XFC,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XFF,0XC3,
0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X00,0X00,0X00,0X03,
0XFF,0XC3,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X00,0X00,
0X00,0X0F,0XFF,0XC3,0XF0,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,
0X00,0X00,0X00,0X3F,0XFF,0XC0,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,
0X00,0X00,0X00,0X00,0X00,0XFF,0XFF,0XF0,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0X00,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XC0,0X00,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,};


const unsigned char gImage_oedbook[3096] = { /* 0X81,0X02,0XAC,0X00,0X48,0X00, */
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X40,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X0B,0XFF,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X40,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X00,0X0F,0XFF,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X40,0X00,0X00,0X0C,0X00,
0X00,0X00,0X00,0X00,0X0F,0XFF,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X50,0X00,0X00,
0X0F,0XFC,0X00,0X00,0X00,0X00,0X1F,0XFF,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X50,
0X00,0X00,0X00,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X50,0X00,0X00,0X00,0X00,0X3F,0XC0,0X00,0X00,0X3F,0XFF,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X54,0X00,0X00,0X00,0X00,0X3F,0XC0,0X00,0X00,0X3F,0XFF,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X54,0X00,0X00,0X00,0X0F,0XFC,0X00,0X00,0X00,0XBF,0XFF,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X54,0X00,0X00,0X0F,0XFC,0X00,0X00,0X00,0X00,
0XFF,0XFF,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X00,0X00,0X0F,0X00,0X00,0X00,
0X00,0X00,0XFF,0XFF,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X00,0X00,0X0F,0XFC,
0X00,0X00,0X00,0X00,0XFF,0XFF,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X00,0X00,
0X00,0X0F,0XFC,0X00,0X00,0X03,0XFF,0XFF,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X00,0X00,0X00,0X00,0X0F,0XC0,0X00,0X03,0XFF,0XFF,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X40,0X00,0X00,0X00,0XFF,0XC0,0X00,0X03,0XFF,0XFF,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X40,0X00,0X00,0XFF,0XF0,0X00,0X00,0X07,0XFF,0XFF,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X40,0X00,0X0F,0XF0,0X00,0X00,0X00,0X0F,0XFF,0XFF,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X50,0X00,0X0C,0X00,0X00,0X00,0X00,0X0F,
0XFF,0XFF,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X50,0X00,0X00,0X00,0X00,0X00,
0X00,0X0F,0XFF,0XFF,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X50,0X00,0X0C,0X00,
0X00,0XC0,0X00,0X3F,0XFF,0XFF,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X54,0X00,
0X0C,0X0F,0X00,0XC0,0X00,0X3F,0XFF,0XFF,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,
0X54,0X00,0X0C,0X0F,0X00,0XC0,0X00,0X3F,0XFF,0XFF,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X55,0X54,0X00,0X0C,0X0F,0X00,0XC0,0X00,0XBF,0XFF,0XFF,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X55,0X54,0X00,0X0C,0X0F,0X00,0XC0,0X00,0XFF,0XFF,0XFF,0X55,0X55,
0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X00,0X0C,0X0F,0X00,0XC0,0X00,0XFF,0XFF,0XFF,
0X95,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X00,0X0C,0X0F,0X00,0XC0,0X01,0XFF,
0XFF,0XFF,0XA5,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X00,0X0F,0XFF,0XFF,0XC0,
0X03,0XFF,0XFF,0XFF,0XAA,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X40,0X0F,0XFF,
0XFF,0XC0,0X03,0XFF,0XFF,0XFF,0XAA,0X95,0X55,0X55,0X55,0X55,0X55,0X55,0X55,0X40,
0X00,0X00,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XAA,0XA9,0X55,0X55,0X55,0X55,0X55,0X55,
0X55,0X40,0X00,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XAA,0XAA,0X55,0X55,0X55,0X55,
0X55,0X55,0X55,0X50,0X00,0X00,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XAA,0XAA,0X95,0X55,
0X55,0X55,0X55,0X55,0X55,0X50,0X0F,0XFF,0XFF,0XC0,0X0F,0XFF,0XFF,0XFF,0XAA,0XAA,
0XA9,0X55,0X55,0X55,0X55,0X55,0X55,0X50,0X00,0X00,0X0F,0XC0,0X2F,0XFF,0XFF,0XFF,
0XAA,0XAA,0XAA,0X55,0X55,0X55,0X55,0X55,0X55,0X54,0X00,0X00,0X3C,0X00,0X3F,0XFF,
0XFF,0XFF,0XAA,0XAA,0XAA,0X95,0X55,0X55,0X55,0X55,0X55,0X54,0X00,0X03,0XF0,0X00,
0X3F,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XA9,0X55,0X55,0X55,0X55,0X55,0X54,0X00,0X3F,
0X00,0X00,0X7F,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0X55,0X55,0X55,0X55,0X55,0X54,
0X00,0XFC,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0X95,0X55,0X55,0X55,
0X55,0X55,0X0F,0XC0,0X00,0X00,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0XA5,0X55,
0X55,0X55,0X55,0X55,0X0F,0XFF,0XFF,0XC0,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,
0XA9,0X55,0X55,0X55,0X55,0X55,0X0F,0XFF,0XFF,0XC3,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,
0XAA,0XAA,0XAA,0X55,0X55,0X55,0X55,0X55,0X40,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFF,
0XAA,0XAA,0XAA,0XAA,0XAA,0X95,0X55,0X55,0X55,0X55,0X40,0X00,0X00,0X03,0XFF,0XFF,
0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XA5,0X55,0X55,0X55,0X55,0X40,0X00,0X00,0X07,
0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XA9,0X55,0X55,0X55,0X55,0X50,0X00,
0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0X55,0X55,0X55,0X55,
0X50,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0X95,0X55,
0X55,0X55,0X50,0X00,0X00,0X0F,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XA5,0X55,0X55,0X55,0X50,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XA9,0X55,0X55,0X55,0X54,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0X55,0X55,0X55,0X54,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0X95,0X55,0X55,0X54,0X00,0X00,0XBF,0XFF,0XFF,
0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XA5,0X55,0X55,0X55,0X00,0X00,0XFF,
0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XA5,0X55,0X55,0X55,0X00,
0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XA9,0X55,0X55,
0X55,0X00,0X01,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0X55,0X55,0X55,0X40,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0X95,0X55,0X55,0X40,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XA5,0X55,0X55,0X40,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XA5,0X55,0X55,0X40,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XAA,0XAA,0XAA,0XAA,0XAA,0XA8,0X2A,0XAA,0XA9,0X55,0X55,0X50,0X0F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0X02,0XA0,0X00,0XAA,0XAA,0X55,0X55,0X50,0X0F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0X02,0XA8,0X00,0X02,0XAA,0X95,0X55,0X50,
0X2F,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XA8,0X20,0X00,0XAA,0X00,0XAA,0X95,
0X55,0X54,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XA8,0X80,0X00,0XAA,0XA0,
0XAA,0XA5,0X55,0X54,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XA2,0XA2,0XA0,
0XAA,0XA2,0XAA,0XA9,0X55,0X54,0X7F,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,
0XA2,0XA8,0XAA,0XA2,0XAA,0XA9,0X55,0X55,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,
0XAA,0XAA,0XA2,0XA8,0XAA,0XAA,0XAA,0XAA,0X55,0X55,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XAA,0XAA,0XAA,0XAA,0XA2,0XA8,0XAA,0XAA,0XAA,0XAA,0X55,0X55,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XAA,0XAA,0XAA,0XA2,0XA2,0XA8,0XAA,0XAA,0XAA,0XAA,0X95,0X55,0XFF,0XF0,
0X00,0X03,0XFF,0XFF,0XAA,0XAA,0XAA,0XA0,0X00,0X00,0X00,0X00,0X0A,0XAA,0XA5,0X55,
0XFF,0X00,0X00,0X00,0X3F,0XFF,0XAA,0XAA,0XAA,0XA0,0X00,0X00,0X00,0X00,0X02,0XAA,
0XA5,0X55,0XFF,0X03,0XF0,0X3C,0X0F,0XFF,0XAA,0XAA,0XAA,0XAA,0XA2,0XA8,0XAA,0XAA,
0XAA,0XAA,0XA9,0X55,0XFC,0X3F,0XFC,0X3F,0XC3,0XFF,0XAA,0XAA,0XAA,0XAA,0XA2,0XA8,
0XAA,0XAA,0XAA,0XAA,0XA9,0X55,0XFC,0X3F,0XFF,0X3F,0XC3,0XFF,0XAA,0XAA,0XAA,0XAA,
0XA2,0XA8,0XAA,0XAA,0XAA,0XAA,0XAA,0X55,0XFC,0X3F,0XFF,0X0F,0XF3,0XFF,0XAA,0XAA,
0XAA,0XAA,0XA2,0XA8,0XAA,0XAA,0XAA,0XAA,0XAA,0X95,0XFC,0X3F,0XFF,0X0F,0XF3,0XFF,
0XAA,0XAA,0XAA,0XAA,0XA2,0XA8,0XAA,0XAA,0XAA,0XAA,0XAA,0X95,0XFC,0X3F,0XFC,0X3F,
0XC3,0XFF,0XAA,0XAA,0XAA,0XAA,0XA2,0XA8,0XAA,0XAA,0XAA,0XAA,0XAA,0XA5,0XFF,0X03,
0XF0,0X3F,0X03,0XFF,0XAA,0XAA,0XAA,0XAA,0XA2,0XA8,0XAA,0XAA,0XAA,0XAA,0XAA,0XA5,
0XFF,0X00,0X00,0XFC,0X0F,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XA8,0XAA,0XAA,0XAA,0XAA,
0XAA,0XA9,0XFF,0XF0,0X03,0XFC,0X3F,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XA9,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0XC3,0XFF,0XFF,0XAA,0XAA,
0XAA,0XAA,0XAA,0XA8,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0XC3,0XFF,0XFF,
0XAA,0XAA,0XAA,0XAA,0XAA,0XA0,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0XC3,
0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0X2A,0XA0,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XFC,0X00,
0X00,0X00,0X03,0XFF,0XAA,0XAA,0XAA,0XA8,0X2A,0XA8,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XFC,0X00,0X00,0X00,0X03,0XFF,0XAA,0XAA,0XAA,0XA0,0X2A,0XA8,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XFF,0X0F,0XFF,0XC3,0XFF,0XFF,0XAA,0XAA,0XAA,0XA8,0X0A,0XA8,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XFF,0XC0,0XFF,0XC3,0XFF,0XFF,0XAA,0XAA,0XAA,0XA8,0X0A,0XA8,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XFF,0XF0,0X3F,0XC3,0XFF,0XFF,0XAA,0XAA,0XAA,0XA8,
0X82,0XA8,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XFF,0XFF,0X03,0XC3,0XFF,0XFF,0XAA,0XAA,
0XAA,0XA8,0XA2,0XA8,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XFF,0XFF,0XC0,0XC3,0XFF,0XFF,
0XAA,0XAA,0XAA,0XA8,0XA8,0X00,0X00,0X00,0X0A,0XAA,0XAA,0XAA,0XFF,0XFF,0XF0,0X03,
0XFF,0XFF,0XAA,0XAA,0XAA,0XA8,0XA8,0X00,0X00,0X00,0X02,0XAA,0XAA,0XAA,0XFF,0XFF,
0XFF,0X03,0XFF,0XFF,0XAA,0XAA,0XAA,0XA8,0XAA,0XA8,0XAA,0XAA,0X02,0XAA,0XAA,0XAA,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XA8,0XAA,0XA8,0XAA,0XAA,0X2A,0XAA,
0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XA8,0XAA,0XA8,0XAA,0XAA,
0X2A,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XA8,0XAA,0XA8,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XFF,0XC0,0X0F,0XFF,0XC3,0XFF,0XAA,0XAA,0XAA,0XA8,
0XAA,0XA8,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XFF,0X00,0X03,0XFF,0XC3,0XFF,0XAA,0XAA,
0XAA,0XA8,0XAA,0XA8,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XFC,0X0F,0XC0,0XFF,0XC3,0XFF,
0XAA,0XAA,0XAA,0XA8,0XAA,0XA8,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XFC,0X3F,0XF0,0X3F,
0XC3,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XA8,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XFC,0X3F,
0XFC,0X3F,0XC3,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XA8,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XFC,0X3F,0XFF,0X0F,0XC3,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XFC,0X3F,0XFF,0X0F,0XC3,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XFC,0X3F,0XFF,0XC3,0XC3,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XA8,0X2A,0XAA,0XAA,0XAA,0XFF,0X03,0XFF,0XC0,0XC3,0XFF,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XA8,0X00,0X0A,0XAA,0XAA,0XAA,0XFF,0X00,0X3F,0XF0,0X03,0XFF,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XA8,0X0A,0XAA,0XAA,0XAA,0XFF,0XF0,0X3F,0XFC,0X03,0XFF,
0XAA,0XAA,0XAA,0XAA,0XA2,0XAA,0XAA,0XAA,0X0A,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0X80,0X00,0X00,0X2A,0X0A,0XAA,0XAA,0XAA,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0X80,0X00,0X00,0X0A,0X0A,0XAA,0XAA,0XAA,
0XFF,0XC3,0XFF,0X00,0X3F,0XFF,0XAA,0XAA,0XAA,0XAA,0XA2,0XA8,0XA8,0XAA,0X0A,0XAA,
0XAA,0XAA,0XFF,0X03,0XFC,0X00,0X0F,0XFF,0XAA,0XAA,0XAA,0XAA,0XA2,0XA8,0XA8,0XAA,
0X0A,0XAA,0XAA,0XAA,0XFC,0X0F,0XFC,0X3F,0XC3,0XFF,0XAA,0XAA,0XAA,0XAA,0XA2,0XA8,
0XA8,0XAA,0X0A,0XAA,0XAA,0XAA,0XFC,0X3F,0XF0,0XFF,0XF3,0XFF,0XAA,0XAA,0XAA,0XA2,
0XA2,0XA8,0XA8,0XAA,0X0A,0XAA,0XAA,0XAA,0XFC,0XFF,0XF0,0XFF,0XF3,0XFF,0XAA,0XAA,
0XAA,0XA0,0X00,0X00,0X00,0X00,0X0A,0XAA,0XAA,0XAA,0XC0,0X00,0X00,0X00,0X00,0X3F,
0XAA,0XAA,0XAA,0X80,0X00,0X00,0X00,0X00,0X2A,0XAA,0XAA,0XAA,0XFC,0XFF,0XC0,0XFF,
0XF3,0XFF,0XAA,0XAA,0XAA,0XAA,0XA2,0XA8,0XA8,0XAA,0XAA,0XAA,0XAA,0XAA,0XFC,0X3F,
0XC3,0XFF,0XC3,0XFF,0XAA,0XAA,0XAA,0XAA,0XA2,0XA8,0XA8,0XAA,0XAA,0XAA,0XAA,0XAA,
0XFC,0X0F,0X03,0XFF,0XC3,0XFF,0XAA,0XAA,0XAA,0XAA,0XA2,0XA8,0XA8,0XAA,0XAA,0XAA,
0XAA,0XAA,0XFF,0X00,0X0F,0XF0,0X0F,0XFF,0XAA,0XAA,0XAA,0XAA,0XA2,0XA8,0XA8,0XAA,
0XAA,0XAA,0XAA,0XAA,0XFF,0XC0,0X3F,0XF0,0X3F,0XFF,0XAA,0XAA,0XAA,0XAA,0X80,0X00,
0X00,0X0A,0XAA,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,
0X80,0X00,0X00,0X0A,0XAA,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0X8A,
0XAA,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0X0A,0XAA,0XAA,0XAA,0XAA,0XFF,0XFC,0X3F,0X3F,0XCF,0XFF,0XAA,0XAA,0XAA,0XA8,
0XAA,0XAA,0XA8,0X0A,0X02,0XAA,0XAA,0XAA,0XFF,0XFC,0X3F,0X3F,0XCF,0XFF,0XAA,0XAA,
0XAA,0XA0,0X00,0XAA,0XA0,0X8A,0X0A,0XAA,0XAA,0XAA,0XFF,0XFC,0X3F,0X3F,0XCF,0XFF,
0XAA,0XAA,0XAA,0XA0,0X00,0X00,0X00,0X88,0X2A,0XAA,0XAA,0XAA,0XFF,0XFC,0X3F,0X3F,
0XCF,0XFF,0XAA,0XAA,0XAA,0XA8,0XA2,0X00,0X00,0X88,0X2A,0XAA,0XAA,0XAA,0XFF,0XFC,
0X3F,0X3F,0XCF,0XFF,0XAA,0XAA,0XAA,0XA8,0X02,0X88,0X88,0X88,0XAA,0XAA,0XAA,0XAA,
0XFF,0XFC,0X3F,0X3F,0XCF,0XFF,0XAA,0XAA,0XAA,0XA8,0X22,0X88,0X80,0X08,0XAA,0XAA,
0XAA,0XAA,0XFF,0XFC,0X00,0X00,0X0F,0XFF,0XAA,0XAA,0XAA,0XA8,0X28,0X88,0X80,0X08,
0XAA,0XAA,0XAA,0XAA,0XFF,0XFC,0X00,0X00,0X0F,0XFF,0XAA,0XAA,0XAA,0XA8,0XA8,0X88,
0X88,0X8A,0XAA,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XA8,
0XA8,0X80,0X08,0X8A,0XAA,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,
0XAA,0XA0,0X00,0X00,0X08,0X8A,0XAA,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,
0XAA,0XAA,0XAA,0XA0,0X00,0X08,0X80,0X08,0XAA,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,
0XCF,0XFF,0XAA,0XAA,0XAA,0XA8,0XA2,0X88,0X80,0X08,0X2A,0XAA,0XAA,0XAA,0XFF,0XFF,
0XFF,0XFF,0XCF,0XFF,0XAA,0XAA,0XAA,0XA8,0XA2,0X88,0X88,0X88,0X2A,0XAA,0XAA,0XAA,
0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XAA,0XAA,0XAA,0XA8,0X88,0X80,0X00,0X8A,0X2A,0XAA,
0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XAA,0XAA,0XAA,0XA8,0X28,0X00,0X00,0X8A,
0X8A,0XAA,0XAA,0XAA,0XFF,0XFC,0X00,0X00,0X0F,0XFF,0XAA,0XAA,0XAA,0XA8,0X28,0XAA,
0XA8,0X8A,0X8A,0XAA,0XAA,0XAA,0XFF,0XFC,0X00,0X00,0X0F,0XFF,0XAA,0XAA,0XAA,0XA8,
0XA8,0X2A,0XA8,0X8A,0XA2,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,
0XAA,0XA8,0XAA,0X2A,0XAA,0X8A,0XA2,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,
0XCF,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XFF,0XFF,
0XFF,0XF0,0X0F,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XFF,0XFF,0XFF,0X00,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0X2A,0X2A,0XAA,
0XAA,0XAA,0XFF,0XFF,0XC0,0X33,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0X2A,0XAA,0XA8,0X2A,
0X0A,0XAA,0XAA,0XAA,0XFF,0XFC,0X0F,0XF3,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0X00,0X00,
0X00,0X2A,0X0A,0XAA,0XAA,0XAA,0XFF,0XFC,0X0F,0XF3,0XFF,0XFF,0XAA,0XAA,0XAA,0XA8,
0X00,0X00,0X02,0X2A,0X0A,0XAA,0XAA,0XAA,0XFF,0XFF,0XC0,0X33,0XFF,0XFF,0XAA,0XAA,
0XAA,0XAA,0X2A,0XAA,0XAA,0X2A,0X0A,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0X00,0XFF,0XFF,
0XAA,0XAA,0XAA,0XAA,0X2A,0X8A,0X2A,0X2A,0X2A,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0XFC,
0X0F,0XFF,0XAA,0XAA,0XAA,0XAA,0X22,0X08,0X0A,0X28,0X2A,0XAA,0XAA,0XAA,0XFF,0XFF,
0XFF,0XFF,0XCF,0XFF,0XAA,0XAA,0XAA,0XAA,0X02,0X88,0X2A,0X20,0XAA,0XAA,0XAA,0XAA,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0X28,0X08,0XAA,0X02,0XAA,0XAA,
0XAA,0XAA,0XFF,0XFF,0XCF,0XC0,0X3F,0XFF,0XAA,0XAA,0XAA,0XAA,0X2A,0X8A,0XAA,0X2A,
0XAA,0XAA,0XAA,0XAA,0XFF,0XFF,0X0F,0X0F,0X0F,0XFF,0XAA,0XAA,0XAA,0X8A,0X00,0X00,
0X00,0X2A,0XAA,0XAA,0XAA,0XAA,0XFF,0XFC,0X3F,0X0F,0XCF,0XFF,0XAA,0XAA,0XAA,0X80,
0X00,0X00,0X00,0X02,0XAA,0XAA,0XAA,0XAA,0XFF,0XFC,0XFF,0X3F,0XCF,0XFF,0XAA,0XAA,
0XAA,0XA0,0X28,0X80,0XAA,0X00,0XAA,0XAA,0XAA,0XAA,0XFF,0XFC,0XFF,0X3F,0XCF,0XFF,
0XAA,0XAA,0XAA,0XAA,0X20,0X08,0X2A,0X28,0X2A,0XAA,0XAA,0XAA,0XFF,0XFC,0XFC,0X3F,
0XCF,0XFF,0XAA,0XAA,0XAA,0XAA,0X22,0X8A,0X2A,0X2A,0X2A,0XAA,0XAA,0XAA,0XFF,0XFF,
0X00,0X3F,0X0F,0XFF,0XAA,0XAA,0XAA,0XAA,0X0A,0X8A,0X8A,0X2A,0X2A,0XAA,0XAA,0XAA,
0XFF,0XFF,0XC0,0XFC,0X3F,0XFF,0XAA,0XAA,0XAA,0XAA,0X00,0X00,0X02,0X2A,0X8A,0XAA,
0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XA8,0X00,0X00,0X00,0X2A,
0X8A,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0X2A,0XA2,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XAA,0X2A,0XA2,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,
0XAA,0XAA,0XAA,0XAA,0XAA,0X2A,0XA2,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,0XAA,
0XAA,0XAA,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,};


const unsigned char gImage_japanese[3096] = { /* 0X81,0X02,0XAC,0X00,0X48,0X00, */
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0XFC,0XFF,0X03,0XFF,0XCF,0XFC,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X33,0XCF,0XF3,0XFF,0XCF,0XF3,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XCF,0XCF,0XF3,0XFF,0XCF,0XCC,0X00,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0X33,0XCF,0XF3,0XFF,0XCC,0X3C,0XFF,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0XF3,0XCF,0XF3,0XF0,0XC3,0XFC,
0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X0F,0XF0,0X00,0X0F,0XFF,
0X0F,0XFC,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XCF,
0XFF,0XFF,0XCF,0XFC,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XF3,0XCF,0XFF,0XFF,0XCF,0XFC,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XCF,0XF0,0X03,0XFF,0XFF,0XCF,0XFC,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XC0,0XF3,0XCC,0X3F,0XFF,0XCF,0XFC,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0X33,0XCF,0XCF,0XFC,0X03,0XFC,0XFF,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XCF,0XCF,0XF3,0XF3,0XCC,0X3C,0XFF,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0X33,0XCF,0XF3,0XFF,0XCF,0XCC,
0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCC,0XFC,0XCF,0XF3,0XFF,
0XCF,0XF3,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,
0XFF,0XFF,0XCF,0XFC,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0X00,0X00,0X00,0X03,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0X33,0X3F,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X33,0X3F,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X33,0X3C,0XF3,0XFF,0XFC,0X00,0X00,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X33,0X3C,0XF3,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X3C,0X00,
0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFC,0XF3,0XFF,0XFF,0XFC,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFC,0XF3,0XFF,0XF3,0XFC,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0X00,0X3C,0X00,0XFF,0XF3,0XFC,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0X33,0X3C,0XF3,0X3F,0XFC,0X00,0X00,0X00,0X3F,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X33,0X3C,0XF3,0XCF,0XFC,0XFC,0XC3,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X33,0X3F,0XFF,0XFF,0XFC,0XFC,0XFC,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X33,0X3F,0XFF,0XFF,0XFC,
0XFC,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,
0X03,0XFF,0XFC,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XF0,0X0F,0XFF,0XFF,0XFF,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0X0F,0XF0,0XFF,0XFF,0XF0,0XFF,0X0F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XCF,0XFC,0XFF,0XFF,0X3F,0XFF,0XCF,0XFF,0XF3,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XCF,0XFC,0XFF,0XFF,0X3F,0XFF,0XCF,0XFF,
0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XCF,0XF3,0XFF,0XFF,0XCF,0XFF,
0X3F,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XF3,0XFF,0XFF,
0XCF,0XFF,0X3F,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XCF,0XF3,
0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,
0XCF,0XF0,0X03,0XFF,0XFF,0XFF,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,
0X3F,0XFF,0XCF,0XF3,0XFC,0X0F,0XFF,0XFF,0X3F,0XC0,0XFF,0XFF,0XFF,0X00,0X00,0X3F,
0X3F,0XFF,0XFF,0XFF,0XCF,0XFC,0XFF,0XF0,0XFF,0XFF,0XCF,0XFF,0X0F,0XFF,0XFF,0X3F,
0XFF,0X3F,0X3F,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0X3F,0XFF,0XCF,0XFF,0XF3,0XFF,
0XFF,0X3F,0XFF,0XFF,0X3F,0XF0,0XFF,0XCF,0XFF,0XFF,0X3F,0XFF,0X3F,0XFF,0XF3,0XFF,
0XF3,0XFF,0XF3,0X00,0X00,0X03,0X3F,0XF3,0X0F,0X3F,0XFF,0XFF,0XC3,0XFC,0XFF,0XFF,
0XFC,0X3F,0XCF,0XFF,0XF3,0XFF,0XFF,0XFF,0X3C,0X03,0XF0,0X00,0X0F,0XFF,0XFC,0X03,
0XFF,0XFF,0XFF,0XC0,0X3F,0XFF,0XFC,0XFF,0XFC,0XFF,0X3F,0XF3,0XFC,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFC,0XFF,0X3F,0XF3,0XFF,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X00,0X3F,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,
0X3F,0XFF,0X3F,0X3F,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0X3C,0XFF,0XFF,0X3F,0X3F,0X0F,0XFF,0XFC,0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,
0XFF,0X3F,0XFF,0XFC,0XFF,0XFC,0XFF,0X3C,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XFC,0XFF,
0XFF,0XFF,0XFC,0XFF,0XC0,0X03,0XFF,0XFC,0XCF,0X33,0X3F,0XFF,0XFC,0XFF,0XFF,0XFF,
0XFF,0X3F,0XFF,0XFF,0XF3,0XFF,0XCF,0XFC,0XFF,0XF3,0XCF,0X3F,0X3F,0XFF,0XFC,0XFF,
0XFF,0XFF,0XFF,0XC0,0X00,0XFF,0XFF,0XFF,0XCF,0XFF,0X3F,0XCF,0XCF,0X3F,0X3F,0XFF,
0XFC,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XCF,0X3F,
0XCF,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XF0,0XFF,0XFF,0X3C,0XFF,
0XCF,0X3F,0XCF,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XF3,0X3F,0XF0,
0XFF,0X3F,0XCF,0X0F,0XCF,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XF3,
0XFC,0X0F,0XFF,0XCF,0XCF,0X30,0XCF,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,
0XFF,0XF0,0X03,0XFF,0XFF,0XF3,0XCF,0X3F,0X0F,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XF0,0X33,0XFC,0X3F,0XFF,0XFC,0XCF,0X3F,0XCF,0XFF,0XF3,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XC0,0XFF,0XC3,0XFF,0XFC,0XFF,0X3F,0XCF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFC,0XFF,0XFF,0X3F,0X3F,0XCF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0X3F,0XFF,0X3F,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3C,0XF3,0X33,0X3F,0XFF,
0XFF,0XFF,0XFF,0XCF,0XFF,0XF0,0X3F,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0X3C,0X33,0X33,
0X3F,0XF0,0X00,0X03,0XFF,0X33,0XFC,0X0F,0XFF,0XFF,0X3F,0X3F,0XFF,0XFF,0XFF,0X3C,
0XC0,0X00,0X3F,0XCF,0XFF,0XFC,0XFF,0XCF,0XC3,0XFF,0XFF,0XFF,0X3F,0X3F,0XFF,0XFF,
0XFF,0X00,0XF3,0X33,0X3F,0X3F,0XFF,0XFF,0X3F,0XFC,0X3F,0XFF,0XFF,0XFF,0X3F,0X3F,
0XFF,0XFF,0XF0,0X3C,0X33,0X33,0X3F,0X3F,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0X3F,0X3F,0XFF,0XFF,0XFF,0X3C,0XC0,0X00,0X3F,0X3F,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0X3F,0X3F,0XFF,0XFF,0XFF,0XCC,0XFC,0XFF,0XFF,0X3F,0XFF,0XFF,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0X3F,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0X3F,0X0F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0X3F,0XF3,0XFF,0XFF,0XFF,0XC0,0X3F,
0XFF,0X3F,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0X3F,0XFC,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0X3F,0XF3,0XFF,0X3F,0XFC,0X03,0XFF,0XFF,0XFF,0X3F,0X3F,0XFC,0XFF,
0XFF,0XF3,0XFF,0XFF,0XFF,0X3F,0XF3,0XFF,0X3F,0XFF,0XFC,0X0F,0XFF,0XFF,0X3F,0X3F,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XF3,0XFF,0X3F,0XFF,0XFF,0XF0,0XFF,0XFF,
0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XF3,0XFF,0X3F,0XFF,0XFF,0XFF,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XF3,0XFF,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X00,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XC3,
0XFF,0XF0,0X00,0X03,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XCF,0XFF,0XCF,0XFF,0XFF,0XFF,
0XFF,0XFC,0XFF,0XCF,0XFF,0XFC,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XCF,0XFF,0XCF,0XFF,
0XFF,0XFF,0XFF,0XFC,0XFF,0X3F,0XFF,0XFF,0X3F,0XFF,0XFC,0XFF,0XFF,0XFF,0XCF,0XFF,
0XCF,0XFF,0XFF,0XFF,0XFF,0XC3,0XFF,0X3F,0XFF,0XFF,0X3F,0XFF,0XFC,0XFF,0XFF,0XFF,
0XCF,0XFF,0XCF,0XFF,0XFF,0X00,0X00,0X3F,0XFF,0X3F,0XFF,0XFF,0X3F,0XFF,0XFC,0XFF,
0XFF,0XFF,0XCF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFF,0XFC,0XFF,0XFF,
0XFC,0XFF,0XFF,0XFF,0XCF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X00,0X03,
0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XCF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XCF,0XFF,0XCF,0XFF,0XFF,0XFF,0X00,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XCF,0XFF,0XCF,0XFF,0XFF,0XF0,
0XFF,0XFF,0XFC,0X00,0X00,0X00,0X0F,0XFF,0XFC,0XFF,0XFF,0XFF,0XCF,0XFF,0XCF,0XFF,
0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XCF,0XFF,
0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XC3,0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,
0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XC3,0XFF,0X00,0X00,0X00,
0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XFC,0XFF,0XFF,
0XFC,0XFF,0XFF,0XFC,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XFC,
0XFF,0XFF,0XC3,0XFF,0XFF,0XF3,0X3F,0XCF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,0XFF,0XF3,
0XFF,0XF3,0XFF,0XFF,0X3F,0XFF,0XFF,0XFC,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,
0XF0,0X00,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,
0XF3,0XFF,0XFF,0XFC,0X03,0XFF,0XFC,0X00,0X00,0X0F,0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,
0XFF,0X00,0X03,0XFF,0XFF,0XFC,0XFC,0X0F,0XFF,0XFF,0XFF,0XF0,0XFF,0XFF,0XCF,0XFF,
0XFF,0XFF,0XFF,0X3F,0XF3,0XFF,0XFF,0XFC,0XFF,0XF0,0XFF,0XFF,0X03,0XFF,0X3F,0XFF,
0X3F,0XFF,0XFF,0XFF,0XFF,0X3F,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,
0XCF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XF3,0XFF,0XFF,0XFF,0XFF,0X00,
0X3F,0XCF,0XFF,0XFF,0X0F,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0X3F,0XF3,0XFF,0XFC,0X00,
0X0F,0X3F,0X3F,0XCF,0XFF,0XF0,0XFF,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF3,0XFF,
0XFC,0XF3,0XCF,0X3F,0X3F,0XCF,0XFF,0X0C,0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,
0XF3,0XFF,0XFC,0XF3,0XCF,0X00,0X3F,0XCF,0XFC,0XFC,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFC,0XF3,0XCF,0X3F,0X3F,0XCF,0XFF,0XFF,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XF3,0XCF,0X00,0X3F,0XCF,0XFF,0XFF,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XF3,0XCF,0X3F,0X3C,0X0C,0X0F,0XFF,
0X3F,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X00,0X0F,0X3F,0X3F,0XCF,
0XF0,0X3F,0X3F,0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,
0X3F,0XCF,0XFF,0XC3,0XCF,0XCF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0X3F,0XCF,0XFF,0XFC,0X0F,0XC3,0XFC,0XFF,0XFF,0XFF,0XCF,0XFF,0XFC,0XFF,
0XFF,0X3F,0XFF,0XFF,0XFF,0XCF,0XFF,0XFF,0XCF,0XCC,0XFC,0XFF,0XFF,0XFF,0XCF,0XCF,
0XF3,0XFF,0XFC,0XFF,0X3C,0X3F,0XFF,0XCF,0XFF,0XFF,0XCF,0XCC,0XFC,0XFF,0XFF,0XFF,
0X3F,0X3F,0XF3,0XFF,0XF3,0XFC,0XFF,0XC3,0XFF,0XC0,0X00,0X03,0XFF,0XCF,0X3C,0XFF,
0XFF,0XFF,0X3F,0X3F,0XCF,0XFF,0XFF,0XF3,0XFF,0XFC,0X3F,0XFF,0XFF,0XFC,0X3F,0XCF,
0X00,0X00,0X03,0XFF,0X3F,0X3F,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XCF,0XCF,0XFC,0XFF,0XF3,0XFC,0XFC,0XFF,0XCF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XCF,0XFC,0XFF,0XF3,0XFC,0XFC,0XFF,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFC,0XFF,0XFF,0XFC,0XFC,0XFF,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XCF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XF0,0X3F,0XFF,0X03,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0X33,0XFF,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0X33,0X33,0X00,0X33,0XFF,0XF0,0X00,0X00,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X33,0X33,0X33,0X33,0XFF,0XF3,0XFF,0XF3,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X33,0X33,0X33,0X33,0XFF,0XF3,0XFF,
0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X33,0X33,0X33,0X33,0XFF,
0XF3,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X33,0XFF,0X33,
0X33,0XFF,0XF3,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,
0X03,0X00,0X03,0XFF,0XF3,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0X33,0XFF,0X33,0X3F,0XFF,0XF3,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0X33,0X33,0X33,0X3F,0XFF,0XF3,0XFF,0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0X33,0X33,0X33,0X3F,0XFF,0XF3,0XFF,0XF3,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X33,0X33,0X33,0X3F,0XFF,0XF3,0XFF,0XF3,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X33,0X33,0X00,0X3F,0XFF,0XF3,0XFF,
0XF3,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X33,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF0,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,};


const unsigned char gImage_RECT[3096] = { /* 0X01,0X02,0XAC,0X00,0X48,0X00, */
0X00,0X00,0X3F,0XFC,0X00,0X00,0X3F,0XFC,0X00,0X00,0X3F,0XFC,0X00,0X00,0X3F,0XFC,
0X00,0X00,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,0X3F,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFC,
0X3F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFC,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X00,0X00,0X3F,0XFC,0X00,0X00,0X3F,0XFC,0X00,0X00,
0X3F,0XFC,0X00,0X00,0X3F,0XFC,0X00,0X00,};


#endif
