
#include "mbed.h"

class Ebadge {
    public:
        Ebadge(PinName rxd, PinName txd, PinName isp);
        void reset();
        bool flash();
        void terminal_Baud(int baudrate = 115200);
        void terminal();
        bool isIspPressed();
        void download();
        void upload();
        void save();
        void read();
        void paint();
        void clean();
        void empty();
        void toggle();
        void check();
        void overwrite();
    
    private:
        bool _cmd(const char* format);
        bool _cpRam2Disp();
    protected:
        Serial _uart;
        PinName _isp;
};
