/*
Accelerometer driver.

CPV, 4/9/2009
*/

#ifndef __ACCELEROMETER_H__
#define __ACCELEROMETER_H__


#include "mbed.h"
#include "filters.h"


class Accelerometer1D
{
public:
  void initialise(PinName pin, int tau, int offset=0xffff>>1);
  void tick(void) { m_filter.tick((int)AnalogIn(m_pin).read_u16()&0xfff0); }
  int operator()(void) { return m_filter() - m_offset; }
  int read(void) { return m_filter() - m_offset; }

protected:
  FilterIirI m_filter;
  PinName m_pin;
  int m_offset;
};


class Accelerometer2D
{
public:
  Accelerometer2D(PinName ch0, PinName ch1, int tau, int offset=0xffff>>1);
  void tick(void);
  int read(int ch) { return m_channels[ch].read(); }

protected:
  Accelerometer1D m_channels[2];
};


class Accelerometer3D
{
public:
  Accelerometer3D(PinName ch0, PinName ch1, PinName ch2, int tau, int offset=0xffff>>1);
  void tick(void);
  int read(int ch) { return m_channels[ch].read(); }

protected:
  Accelerometer1D m_channels[3];
};


#endif // __ACCELEROMETER_H__
