/*
Accelerometer driver.

CPV, 4/9/2009
*/

#include "accelerometer.h"


void Accelerometer1D::initialise(PinName pin, int tau, int offset)
{
  m_pin = pin;
  m_offset = offset;
  m_filter.initialise(tau);
}


//===============================================


Accelerometer2D::Accelerometer2D(PinName ch0, PinName ch1, int tau, int offset)
{
  m_channels[0].initialise(ch0,tau,offset);
  m_channels[1].initialise(ch1,tau,offset);
}


void Accelerometer2D::tick(void)
{
  m_channels[0].tick();
  m_channels[1].tick();
}


//===============================================


Accelerometer3D::Accelerometer3D(PinName ch0, PinName ch1, PinName ch2, int tau, int offset)
{
  m_channels[0].initialise(ch0,tau,offset);
  m_channels[1].initialise(ch1,tau,offset);
  m_channels[2].initialise(ch2,tau,offset);
}


void Accelerometer3D::tick(void)
{
  m_channels[0].tick();
  m_channels[1].tick();
  m_channels[2].tick();
}

