/*            *************************************************************************************
              CPMG_T2  Basic standard sequence, VERSION 1, October 22th 2012
              CPMG SPIN ECHO PULSE SEQUENCE FOR T2 MEASURMENT IN NMR SPECTROMETRIE.
              {D1 - P1 - [D2 - P2 - D2]n - FID }NS
                Homonuclear sequence :  (p1, P2 --> same channel)
                DESIGN FOR NXPLPC1768 ARM CORTEX M3 MCU BOARD:
                INPUT : NONE (reset on board)
                OUTPUT :  ACQU                  ---> P26 AND LED1
                       :  PULSES P1 & P2        ---> P25
                       :  Emmitter              ---> P24, P23
                       :  Transmitter           ---> P24, P23
              ***** IN THIS VERSION RECEIVER AND TRANSMITTER HAVE THE SAME PHASE CYCLE *****
              *************************************************************************************
              Alain L-J
              France
              91128 Palaiseau CEDEX France
              *************************************************************************************
              This program comes as is with its flaws and bugs.
              NO WARRANTY IS PROVIDED.
              This program is distributed in the hope that it will be useful,
              but WITHOUT ANY WARRANTY; without even the implied warranty of
              FITNESS FOR A PARTICULAR PURPOSE
              This software is distributed on an "AS IS" BASIS,
              WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
              *************************************************************************************
                UNLESS OTHERWISE SPECIFIED THE PARAMETERS OF THE PULSE SEQUENCE ARE SET :
 D1           : relaxation delay ( ms to s)
 D2, D3,etc,  : fixed delay (ms to s)
 DE           : fixed delay before acqusisition
 DW           : Dwell time period for sampled t2 acquisition time domain
 D0           : incremenatble delay ( from 1us to s)(t1 time domain dimension for 2D experiment)
 NS           : Number of scan
 VD           : Variable delay using a file list
 PW           : Pulse length (us)
 P90          : 90° transmitter or decoupler pulse length
 P180         : 180° transmitter or decoupler pulse length
 P3 P4        : 90°, 180°, X-nucleus pulses length
 DO           : Decoupler gated off or on
 HD           : HomoDecoupling in time sharing during acqusition
 HG           : HomoGating decoupling with receiver gated OFF
 BB           : Broadband modulation gate
 CW           : Continuous wave
 FID          : Free Induction Decay acquisition (data acquisition for time AQ
 AQ           : Acquisition time (physical t2  acquisition time domain dimension)
 PHn          : Phase for pulse number n (ie : PH1 for pulse P1)
 PH0          : Receiver phase
              *************************************************************************************
              For CPMG sequence :
              For best SNR, Transmitter Pulse phase PH1 and Acquisition receiver phase (PH0) should follow the standard quadrature phase cycle,
              QP : 0, 0, 180°, 180°, 90°, 90°, 270°,270°
              PH2 phase should be : 90°, 90°, 90°, 90°, 180°, 180°, 180°, 180°
              n must be even
              optimise D2 to eliminate J modulation and/or diffusion effect
              ***** IN THIS VERSION RECEIVER AND TRANSMITTER HAVE THE SAME PHASE CYCLE and are cycled 0°, 90°, 180°, 270°*****
              *************************************************************************************
*/


#include "mbed.h"

#define D1  0.0005                /*  Relaxation delay in second              */
#define Fs  48000                 /* Sample frequency in Hz NOT USE           */
#define DW  1                     /* DW time period in us                     */
#define NS  8.0                   /* 8 accumulations                          */
#define D2  0.000010              /* echo delay in ms                         */
#define n   1
#define AQ  0.0005
#define P90 0.000005



DigitalOut Relaxation(LED1);    /* Delay on pin 26 ??? and flash LED1 during relaxation delay */
BusOut Acqu(p26, LED2)  ;      /* */
DigitalOut  p1(p25);
DigitalOut  p2(p25);            /* Only for reason of clarity P2 =2*P1 */
BusOut  PH1PH2(p24, p23) ;      // transmitter and receiver phases are the same

int main()
{

    // while (1) {
    p1 =0 ;
    Relaxation = 0 ;
    Acqu=0x00;
    PH1PH2=0x00;  //0 init

    for (float i = 0.0f ; i < NS ; i += 1.0f) {

        Relaxation = 1;         /* LED1 light*/
        wait(D1);               // relaxation
        Relaxation = 0;         // turn off the led


        p1=1;
        wait(P90);              // 90°
        p1=0;

        wait(D2);               // delay D2

        p2=1;
        wait(2*P90);            //180°
        p2=0;

        wait(D2);               // delay

        Acqu=0x11;              // Acquire FID (we can write 3 in decimal)
        wait(AQ);
        Acqu=0x00;

        PH1PH2=PH1PH2+1;        //Phase cycling

    }
    //wait(1); //for slow test
}
//}

/* INCREMENTATION DE LA DUREE D'ECLAIREMENT DE LED1 AVEC PwmOut
PwmOut led(LED1);

int main() {
    while(1) {
        for(float p = 0.0f; p < 1.0f; p += 0.1f) {
            led = p;
            wait(0.1);
        }
    }
} */

/* Digital I/O

    DigitalOut - Configure and control a digital output pin.
    DigitalIn - Configure and control a digital input pin.
    DigitalInOut - Bi-directional digital pins

    BusIn - Flexible way to read multiple DigitalIn pins as one value
    BusOut - Flexible way to write multiple DigitalIn pins as one value
    BusInOut - Flexible way to read/write multiple DigitalIn pins as one value

    PortIn - Fast way to read multiple DigitalIn pins as one value
    PortOut - Fast way to write multiple DigitalIn pins as one value
    PortInOut - Fast way to read/write multiple DigitalIn pins as one value

    PwmOut - Pulse-width modulated output */

/* Features

  NXP LPC1768 MCU
      High performance ARM® Cortex™-M3 Core
      96MHz, 32KB RAM, 512KB FLASH
      Ethernet, USB Host/Device, 2xSPI, 2xI2C, 3xUART, CAN, 6xPWM, 6xADC, GPIO
  Prototyping form-factor
      40-pin 0.1" pitch DIP package, 54x26mm
      5V USB or 4.5-9V supply
      Built-in USB drag 'n' drop FLASH programmer
  mbed.org Developer Website
      Lightweight Online Compiler
      High level C/C++ SDK
      Cookbook of published libraries and projects
      */
