#include "mbed.h"
#include "LCD_DISCO_F746NG.h"
#include <stdio.h>


LCD_DISCO_F746NG lcd;
DigitalOut led1(LED1);
AnalogIn mesure_analogique(PA_0);
PwmOut Buzzer(PA_8);
DigitalIn mon_bouton(PI_11);

int main()
{  
    float val,time;
    int X, Y,X_max,Y_max,Range;
    int a = mon_bouton.read();
    char chaine[50];
// initialisations
    val=0;
    led1 = 1;
    time=0.2f;
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    X_max=lcd.GetXSize();
    Y_max=lcd.GetYSize();
    X=0;
    Range=200;
    Y=Y_max-10;
    
    if(a == 0){ //bouton poussoir non enfoncé
        while(1)
        {
            val=mesure_analogique.read();
            val=val*3.3;
            sprintf((char*)chaine,"tension (en V) = %3.3f",val);
            lcd.DisplayStringAt(0, LINE(1), (uint8_t *)&chaine, CENTER_MODE);
            Y=Y_max-Range*val/3.3;
            lcd.DrawPixel(X,Y,LCD_COLOR_WHITE);
            wait_ms(3);//3 ms est la meilleure des valeurs
            X=X+1;
            if(X > X_max) { 
                X = 0;
                lcd.Clear(LCD_COLOR_BLACK);
                sprintf((char*)chaine,"tension (en V) = %3.3f",val); 
                }
            if(val<=1.9){ 
                Buzzer.write(0);
            }
            if(val>=3){
                Buzzer.write(0);
           }
           if(val<=0.1){
                Buzzer.pulsewidth(160.0f);
                }
            else{
                Buzzer.period_ms(10.0f); //pour le son 
                //Buzzer.write(0.1f);
                Buzzer.pulsewidth_ms(5.0f);
                }
           }
        }
        else{//bouton poussoir enfoncé obj :figer l'écran
}
