/***********************************************************************
**  ██████╗ ███████╗██╗███████╗██╗    ██╗ █████╗ ██████╗ ███╗   ███╗  **
**  ██╔══██╗██╔════╝██║██╔════╝██║    ██║██╔══██╗██╔══██╗████╗ ████║  **
**  ██████╔╝███████╗██║███████╗██║ █╗ ██║███████║██████╔╝██╔████╔██║  **
**  ██╔═══╝ ╚════██║██║╚════██║██║███╗██║██╔══██║██╔══██╗██║╚██╔╝██║  **
**  ██║     ███████║██║███████║╚███╔███╔╝██║  ██║██║  ██║██║ ╚═╝ ██║  **
**  ╚═╝     ╚══════╝╚═╝╚══════╝ ╚══╝╚══╝ ╚═╝  ╚═╝╚═╝  ╚═╝╚═╝     ╚═╝  **
************************************************************************
** Copyright 2016 University of York - See notice at end of file      **
***********************************************************************/

/// PsiSwarm C++ Blank Example Code - Version 0.8
/// James Hilder, Alan Millard, Alexander Horsfield, Homero Elizondo, Jon Timmis

/// Include main.h - this includes psiswarm.h all the other necessary core files
#include "main.h"
#include <cstdlib> 

Psiswarm psi;

char * program_name = "Blank";
char * author_name  = "YRL";
char * version_name = "0.80";

Timer t; //set a timer
int how_long;

///User code loop:  This is where user code should go; it is run as an infinite loop
void user_code_loop()
{
    motors.forward(0.2); //simple code, the psiswarm continues forwards
    led.set_leds(0b10101010,0b01010101); //illuminate circumference with alternating led pattern

    t.start();
    how_long = t.read();
    
    if(how_long > 1) {
        float turn = (rand()%6)/10.0f - 0.25;
        //float turn = 
        
        char s1[17];

        sprintf(s1,"%.3f",turn);
        display.clear_display();
        display.set_position(0,0);
        display.write_string(s1);
        
        motors.turn(turn);
        wait(1);
        t.reset();
    }     
    
}

///Place user code here that should be run after initialisation but before the main loop
void user_code_setup()
{
    wait(1);
    display.clear_display();
    display.set_position(0,0);
    display.write_string("Going for a walk...");  //display 'Going for a walk...' to indicate robot's function
}

/// Code goes here to handle what should happen when the user switch is pressed
void handle_switch_event(char switch_state)
{
    /// Switch_state = 1 if up is pressed, 2 if down is pressed, 4 if left is pressed, 8 if right is pressed and 16 if the center button is pressed
    /// NB For maximum compatability it is recommended to minimise reliance on center button press
}

void handle_user_serial_message(char * message, char length, char interface)
{
    // This is where user code for handling a (non-system) serial message should go
    //
    // message = pointer to message char array
    // length = length of message
    // interface = 0 for PC serial connection, 1 for Bluetooth
}

/// The main routine: it is recommended to leave this function alone and add user code to the above functions
int main()
{
    psi.init();             ///psi.init() in psiswarm.cpp sets up the robot
    user_code_setup();      ///run user code setup block
    user_code_running = 1;  ///nb. user code can be paused by external commands sent from PC\BT interfaces
    while(1) {
        user_code_loop();   ///run user code
    }
}


/***********************************************************************
** Copyright 2016 University of York                                  **
**                                                                    **
** Licensed under the Apache License, Version 2.0 (the "License")     **
** You may not use this file except in compliance with the License.   **
** You may obtain a copy of the License at                            **
** http://www.apache.org/licenses/LICENSE-2.0   Unless required by    **
** applicable law or agreed to in writing, software distributed under **
** under the License is distributed on an "AS IS" BASIS WITHOUT       **  
** WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.   ** 
** See the License for the specific language governing permissions    ** 
** and limitations under the License.                                 **
***********************************************************************/