#include "mbed.h"

//ZigBee
Serial xbee(p28, p27);
DigitalOut rst(p29);
int myData;

//Left Motors
DigitalOut enLeft(p7);
DigitalOut ctrlLeft(p11);
PwmOut pwrLeft(p23);

//Right Motors
DigitalOut enRight(p8);
DigitalOut ctrlRight(p12);
PwmOut pwrRight(p24);

//Arm Motors
DigitalOut enArm(p5);
DigitalOut ctrlArm(p9);
PwmOut pwrArm(p21);

//Bucket Motors
DigitalOut enBucket(p6);
DigitalOut ctrlBucket(p10);
PwmOut pwrBucket(p22);

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

int stop = 0;

int main() {
    // ZigBee Init
    xbee.baud(19200);
    rst = 0;
    wait_ms(1);
    rst = 1;
    wait_ms(1);
    
    //Motor Enables
    enLeft = 0;
    enRight = 0;
    enArm = 0;
    enBucket = 0;
    
    //Motor PWMs
    pwrLeft = 0.9;
    pwrRight = 0.9;
    pwrArm = 0.9;
    pwrBucket = 0.4;
        
    while(1) {
        
        myData = xbee.getc();
        
        // Move Forward
        if(myData == '0'){
            myled1 = 1;
            stop = 0;
            while(stop != 1) {
                //Left Motors
                enLeft = 1;
                ctrlLeft = 1;
                //Right Motors
                enRight = 1;
                ctrlRight = 1;
                wait(1.5);
                stop = 1;
            }
            enLeft = 0;
            enRight = 0;
            myled1 = 0;
        }
        
        // Move Backward
        else if(myData == '1'){
            stop = 0;
            while(stop != 1) {
                //Left Motors
                enLeft = 1;
                ctrlLeft = 0;
                //Right Motors
                enRight = 1;
                ctrlRight = 0;
                wait(1.5);
                stop = 1;
            }
            enLeft = 0;
            enRight = 0;
        }
        
        //Turn Left
        else if(myData == '2') {
            stop = 0;
            while(stop != 1) {
                //Left Motors
                enLeft = 1;
                ctrlLeft = 0;
                //Right Motors
                enRight = 1;
                ctrlRight = 1;
                wait(1.5);
                stop = 1;
            }
            enLeft = 0;
            enRight = 0;
        }
        
        //Turn Right
        else if(myData == '3') {
            stop = 0;
            while(stop != 1) {
                //Left Motors
                enLeft = 1;
                ctrlLeft = 1;
                //Right Motors
                enRight = 1;
                ctrlRight = 0;
                wait(1.5);
                stop = 1;
            }
            enLeft = 0;
            enRight = 0;
        }
        
        //Arm Up
        else if(myData == '4') {
            stop = 0;
            while(stop != 1) {
                enArm = 1;
                ctrlArm = 1;
                wait(1);
                stop = 1;
            }
            enArm = 0;
        }
        
        //Arm Down
        else if(myData == '5') {
            stop = 0;
            while(stop != 1) {
                enArm = 1;
                ctrlArm = 0;
                wait(1);
                stop = 1;
            }
            enArm = 0;
        }
        
        //Bucket Out
        else if(myData == '6') {
            stop = 0;
            while(stop != 1) {
                enBucket = 1;
                ctrlBucket = 1;
                wait(0.5);
                stop = 1;
            }
            enBucket = 0;
        }
        
        //Bucket In
        else if(myData == '7') {
            stop = 0;
            while(stop != 1) {
                enBucket = 1;
                ctrlBucket = 0;
                wait(0.5);
                stop = 1;
            }
            enBucket = 0;
        }
    }
}
