
#include "mbed.h"
#include "mbed_logo.h"
#include "SSD1308.h"

//Pin Defines for I2C Bus
#define D_SDA                  p28
 #define D_SCL                  p27
 I2C i2c(D_SDA, D_SCL);

//Host PC Communication channels
Serial pc(USBTX, USBRX); // tx, rx

// Instantiate OLED
SSD1308 oled = SSD1308(&i2c, SSD1308_SA0);

int main() {
  pc.printf("OLED test start\r");  
  oled.writeString(0, 0, "Hello World !");
  oled.printf(".");
wait(10);
  oled.fillDisplay(0xAA);
  oled.setDisplayOff();
  wait(0.5);   
  oled.setDisplayOn();
wait (0.5);
  oled.clearDisplay();
  oled.setDisplayInverse();
  wait(1);
  oled.setDisplayNormal();                                         

  oled.writeBitmap((uint8_t*) mbed_logo);

  pc.printf("OLED test done\r\n");  
}
